/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.ClMemoryAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.ICreatableAndModifiable;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.IAssetPropertyProvider;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AssetsViewController {
    private static final @NonNull Map<@NonNull AssetTableSpec, Image> ASSET_TABLE_ICONS = AssetsViewController.initialiseAssetTableIconMap();
    private static final @NonNull Map<@NonNull Object, Image> ASSET_ICONS = AssetsViewController.initialiseAssetIconMap();
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull ReadOnlyObjectWrapper<AssetsViewRoot> root = new ReadOnlyObjectWrapper();

    public AssetsViewController(@NonNull ReadOnlyBooleanProperty enabledProperty) {
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
    }

    public ReadOnlyObjectProperty<AssetsViewRoot> rootProperty() {
        return this.root.getReadOnlyProperty();
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        navigationUriChangeEvent.getNewSnapshotProxy().submitTask(snapshot -> this.buildTree(snapshot));
    }

    private void buildTree(@Nullable TraceStateSnapshot snapshot) {
        AssetsViewRoot rootNode = snapshot == null ? null : new AssetsViewRoot(snapshot);
        Platform.runLater(() -> this.root.set((Object)rootNode));
    }

    private static @NonNull Map<@NonNull Object, Image> initialiseAssetIconMap() {
        @NonNull HashMap<@NonNull Object, Image> cache = new HashMap<Object, Image>();
        cache.put(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS.SPEC, FXImages.FILM);
        cache.put(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC, FXImages.TEXTURE);
        cache.put(KapiSpec.GLES.assetTables.IMAGE_UNIT_TRAITS.SPEC, FXImages.IMAGE);
        cache.put(KapiSpec.GLES.assetTables.BUFFER_TRAITS.SPEC, FXImages.BUFFER);
        cache.put(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS.SPEC, FXImages.BUFFER);
        cache.put(KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS.SPEC, FXImages.BUFFER);
        cache.put(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS.SPEC, FXImages.BUFFER);
        cache.put(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS.SPEC, FXImages.BUFFER);
        cache.put(KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS.SPEC, FXImages.FILM);
        cache.put(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS.SPEC, FXImages.IMAGE);
        cache.put(KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS.SPEC, FXImages.TEXTURE);
        cache.put(KapiSpec.GLES.constants.GL_VERTEX_SHADER, FXImages.SHADER_VERTEX);
        cache.put(KapiSpec.GLES.constants.GL_FRAGMENT_SHADER, FXImages.SHADER_FRAGMENT);
        cache.put(KapiSpec.GLES.constants.GL_COMPUTE_SHADER, FXImages.SHADER_COMPUTE);
        cache.put(KapiSpec.GLES.constants.GL_GEOMETRY_SHADER, FXImages.SHADER_GEOMETRY);
        cache.put(KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER, FXImages.SHADER_TESS_CONTROL);
        cache.put(KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER, FXImages.SHADER_TESS_EVALUATION);
        cache.put(ClMemoryAsset.ClMemoryType.BUFFER, FXImages.BUFFER);
        cache.put(ClMemoryAsset.ClMemoryType.IMAGE, FXImages.IMAGE);
        cache.put(GlFramebufferAttachmentAsset.GlFramebufferAttachmentType.COLOR, FXImages.COLOUR_ATTACHMENT);
        cache.put(GlFramebufferAttachmentAsset.GlFramebufferAttachmentType.DEPTH, FXImages.DEPTH_ATTACHMENT);
        cache.put(GlFramebufferAttachmentAsset.GlFramebufferAttachmentType.STENCIL, FXImages.STENCIL_ATTACHMENT);
        cache.put(GlFramebufferAttachmentAsset.GlFramebufferAttachmentType.DEPTH_STENCIL, FXImages.DEPTH_STENCIL_ATTACHMENT);
        return cache;
    }

    private static @NonNull Map<@NonNull AssetTableSpec, Image> initialiseAssetTableIconMap() {
        @NonNull HashMap<@NonNull AssetTableSpec, Image> cache = new HashMap<AssetTableSpec, Image>();
        cache.put(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS.SPEC, FXImages.FILMS);
        cache.put(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC, FXImages.SHADERS);
        cache.put(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC, FXImages.TEXTURES);
        cache.put(KapiSpec.GLES.assetTables.IMAGE_UNIT_TRAITS.SPEC, FXImages.IMAGES);
        cache.put(KapiSpec.GLES.assetTables.SAMPLER_TRAITS.SPEC, FXImages.SAMPLER);
        cache.put(KapiSpec.GLES.assetTables.BUFFER_TRAITS.SPEC, FXImages.BUFFERS);
        cache.put(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC, FXImages.PROGRAM);
        cache.put(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS.SPEC, FXImages.PROGRAM_PIPELINE);
        cache.put(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS.SPEC, FXImages.TEXTURES);
        cache.put(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS.SPEC, FXImages.BUFFER_BINDING_POINTS);
        cache.put(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS.SPEC, FXImages.RENDERBUFFER);
        cache.put(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_NON_ARRAY_VALUE_TRAITS.SPEC, FXImages.SHADER_ATTRIBUTE);
        cache.put(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS.SPEC, FXImages.VERTEX_ARRAY);
        cache.put(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS.SPEC, FXImages.TRANSFORM_FEEDBACK);
        cache.put(KapiSpec.GLES.assetTables.UNIFORM_TRAITS.SPEC, FXImages.SHADER_UNIFORM);
        cache.put(KapiSpec.CL.assetTables.PROGRAM_TRAITS.SPEC, FXImages.PROGRAM);
        cache.put(KapiSpec.CL.assetTables.KERNEL_TRAITS.SPEC, FXImages.KERNEL_COMPUTE);
        cache.put(KapiSpec.CL.assetTables.MEMORY_TRAITS.SPEC, FXImages.BUFFERS);
        cache.put(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS.SPEC, FXImages.BUFFERS);
        cache.put(KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS.SPEC, FXImages.BUFFERS);
        cache.put(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS.SPEC, FXImages.BUFFERS);
        cache.put(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS.SPEC, FXImages.BUFFERS);
        cache.put(KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS.SPEC, FXImages.FILMS);
        cache.put(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS.SPEC, FXImages.RENDERBUFFER);
        cache.put(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS.SPEC, FXImages.IMAGES);
        cache.put(KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS.SPEC, FXImages.TEXTURES);
        cache.put(KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS.SPEC, FXImages.KERNEL_COMPUTE);
        cache.put(KapiSpec.VULKAN.assetTables.PIPELINELAYOUT_TRAITS.SPEC, FXImages.KERNEL_COMPUTE);
        cache.put(KapiSpec.VULKAN.assetTables.SHADERMODULE_TRAITS.SPEC, FXImages.SHADERS);
        cache.put(KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS.SPEC, FXImages.PROGRAM);
        cache.put(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS.SPEC, FXImages.DESCRIPTOR);
        cache.put(KapiSpec.VULKAN.assetTables.DESCRIPTORSET_TRAITS.SPEC, FXImages.DESCRIPTOR);
        cache.put(KapiSpec.VULKAN.assetTables.DESCRIPTORSETLAYOUT_TRAITS.SPEC, FXImages.DESCRIPTOR);
        return cache;
    }

    private static @Nullable Image getIconForAssetTable(AssetTable element) {
        return ASSET_TABLE_ICONS.get(element.getAssetTableSpec());
    }

    private static @Nullable Image getIconForAssetProperty(@Nullable IAssetProperty assetProperty) {
        AssetTableSpec spec;
        if (!(assetProperty instanceof IAssetItem)) {
            return null;
        }
        IAssetItem asset = (IAssetItem)assetProperty;
        AssetTableSpec objectToCheckFor = spec = asset.getAssetSpec();
        if (asset instanceof GlShaderAsset) {
            objectToCheckFor = ((GlShaderAsset)asset).getType();
        } else if (asset instanceof GlFramebufferAttachmentAsset) {
            objectToCheckFor = ((GlFramebufferAttachmentAsset)asset).getAttachmentType();
        } else if (asset instanceof ClMemoryAsset) {
            objectToCheckFor = ((ClMemoryAsset)asset).getMemoryType();
        }
        Image image = ASSET_ICONS.get(objectToCheckFor);
        if (image == null) {
            image = ASSET_TABLE_ICONS.get(spec);
        }
        return image;
    }

    private static class AssetTableTreeItem
    extends TreeItem<PropertyTableItem>
    implements IRepresentsSamePropertyTableItem {
        private final @NonNull AssetTableSpec tableSpec;

        private AssetTableTreeItem(@NonNull TraceStateSnapshot snapshot, @NonNull AssetTable table, @NonNull List<@NonNull IAssetProperty> propertiesStrongReferences) {
            super((Object)new PropertyTableItem(snapshot, (String)NullUtils.neverNull((Object)table.getAssetTableSpec().getPluralName()), "", null, AssetsViewController.getIconForAssetTable(table)));
            this.tableSpec = table.getAssetTableSpec();
            ObservableList children = this.getChildren();
            for (IAssetItem next : table) {
                assert (next != null);
                children.add((Object)new LazyTreeItem(snapshot, (IAssetProperty)next, propertiesStrongReferences));
            }
        }

        @Override
        public boolean representsSamePropertyTableItem(@Nullable Object other) {
            if (other instanceof AssetTableTreeItem) {
                return this.tableSpec.equals(((AssetTableTreeItem)other).tableSpec);
            }
            return false;
        }
    }

    public static class AssetsViewRoot {
        public final @NonNull TraceStateSnapshot snapshot;
        public final @NonNull TreeItem<PropertyTableItem> root;
        private final @NonNull List<@NonNull IAssetProperty> propertiesStrongReferences = new ArrayList<IAssetProperty>();

        private AssetsViewRoot(@NonNull TraceStateSnapshot snapshot) {
            this.snapshot = snapshot;
            ArrayList<@NonNull KapiSpec> specs = new ArrayList<KapiSpec>();
            TraceDataModel model = snapshot.getModel();
            if (model.containsGLES() || model.containsEGL()) {
                specs.add((KapiSpec)KapiSpec.GLES);
                specs.add((KapiSpec)KapiSpec.EGL);
            }
            if (model.containsCL()) {
                specs.add((KapiSpec)KapiSpec.CL);
            }
            if (model.containsVULKAN()) {
                specs.add((KapiSpec)KapiSpec.VULKAN);
            }
            this.root = new RootTreeItem(specs, snapshot, this.propertiesStrongReferences);
        }
    }

    public static interface IRepresentsSamePropertyTableItem {
        public boolean representsSamePropertyTableItem(@Nullable Object var1);
    }

    private static class KapiSpecTreeItem
    extends TreeItem<PropertyTableItem>
    implements IRepresentsSamePropertyTableItem {
        private final @NonNull KapiSpec spec;

        public KapiSpecTreeItem(@NonNull TraceStateSnapshot snapshot, @NonNull KapiSpec spec, @NonNull List<@NonNull IAssetProperty> propertiesStrongReferences) {
            super((Object)new PropertyTableItem(snapshot, (String)NullUtils.neverNull((Object)spec.getApi().getApiInfo().getOfficialName()), "", null, null));
            this.spec = spec;
            ObservableList children = this.getChildren();
            Collection tables = snapshot.getTargetAssetTables(spec);
            tables.removeIf(table -> !table.getAssetTableSpec().isUserVisible());
            for (AssetTable table2 : tables) {
                assert (table2 != null);
                children.add((Object)new AssetTableTreeItem(snapshot, table2, propertiesStrongReferences));
            }
            children.sort((Comparator)new Comparator<TreeItem<PropertyTableItem>>(){

                @Override
                public int compare(TreeItem<PropertyTableItem> o1, TreeItem<PropertyTableItem> o2) {
                    return ((PropertyTableItem)o1.getValue()).getName().compareTo(((PropertyTableItem)o2.getValue()).getName());
                }
            });
        }

        @Override
        public boolean representsSamePropertyTableItem(@Nullable Object other) {
            if (other instanceof KapiSpecTreeItem) {
                return this.spec.equals(((KapiSpecTreeItem)other).spec);
            }
            return false;
        }
    }

    private static class LazyTreeItem
    extends TreeItem<PropertyTableItem>
    implements IRepresentsSamePropertyTableItem {
        private final @NonNull WeakReference<IAssetProperty> weakProperty;
        private boolean childrenInitialised = false;
        private final @NonNull WeakReference<TraceStateSnapshot> weakSnapshot;
        private final @NonNull WeakReference<List<@NonNull IAssetProperty>> weakPropertyHolder;

        private LazyTreeItem(@NonNull TraceStateSnapshot snapshot, @NonNull IAssetProperty property, @NonNull List<@NonNull IAssetProperty> propertiesStrongReferences) {
            super((Object)new PropertyTableItem(snapshot, property.getSimpleValue(), "", property, AssetsViewController.getIconForAssetProperty(property)));
            this.weakProperty = new WeakReference<IAssetProperty>(property);
            this.weakSnapshot = new WeakReference<TraceStateSnapshot>(snapshot);
            this.weakPropertyHolder = new WeakReference<List<IAssetProperty>>(propertiesStrongReferences);
            propertiesStrongReferences.add(property);
        }

        private LazyTreeItem(@NonNull TraceStateSnapshot snapshot, @NonNull String name, @NonNull IAssetProperty property, @NonNull List<@NonNull IAssetProperty> propertiesStrongReferences) {
            super((Object)new PropertyTableItem(snapshot, name, property.getSimpleValue(), property, AssetsViewController.getIconForAssetProperty(property)));
            assert (!name.isEmpty());
            this.weakProperty = new WeakReference<IAssetProperty>(property);
            this.weakSnapshot = new WeakReference<TraceStateSnapshot>(snapshot);
            this.weakPropertyHolder = new WeakReference<List<IAssetProperty>>(propertiesStrongReferences);
            propertiesStrongReferences.add(property);
        }

        public ObservableList<TreeItem<PropertyTableItem>> getChildren() {
            if (!this.childrenInitialised) {
                this.childrenInitialised = true;
                IAssetProperty property = (IAssetProperty)this.weakProperty.get();
                TraceStateSnapshot snapshot = (TraceStateSnapshot)this.weakSnapshot.get();
                List propertyHolder = (List)this.weakPropertyHolder.get();
                if (property instanceof IAssetPropertyProvider && snapshot != null && propertyHolder != null) {
                    IAssetPropertyProvider provider = (IAssetPropertyProvider)property;
                    ArrayList<@NonNull LazyTreeItem> children = new ArrayList<LazyTreeItem>();
                    for (Map.Entry entry : provider.getProperties().entrySet()) {
                        assert (!((String)entry.getKey()).isEmpty());
                        children.add(new LazyTreeItem(snapshot, (String)entry.getKey(), (IAssetProperty)entry.getValue(), propertyHolder));
                    }
                    if (children.size() == 1) {
                        ((TreeItem)children.get(0)).setExpanded(true);
                    }
                    super.getChildren().setAll(children);
                }
            }
            return super.getChildren();
        }

        public boolean isLeaf() {
            if (this.childrenInitialised) {
                return this.getChildren().size() == 0;
            }
            IAssetProperty property = (IAssetProperty)this.weakProperty.get();
            if (property instanceof IAssetPropertyProvider) {
                return !((IAssetPropertyProvider)property).hasProperties();
            }
            return true;
        }

        @Override
        public boolean representsSamePropertyTableItem(@Nullable Object other) {
            if (other instanceof LazyTreeItem) {
                return ((PropertyTableItem)this.getValue()).getName().equals(((PropertyTableItem)((LazyTreeItem)other).getValue()).getName());
            }
            return false;
        }
    }

    public static class PropertyTableItem {
        private final @NonNull String name;
        private final @NonNull String value;
        private final @NonNull WeakReference<IAssetProperty> assetProperty;
        private final @Nullable Image graphic;
        private final boolean wasCreatedInThisFunction;
        private final boolean wasModifiedInThisFunction;
        private final boolean wasActiveInThisFunction;

        private PropertyTableItem(@NonNull TraceStateSnapshot snapshot, @NonNull String name, @NonNull String value, @Nullable IAssetProperty assetProperty, @Nullable Image graphic) {
            assert (!name.isEmpty());
            this.name = name;
            this.value = value;
            this.assetProperty = new WeakReference<IAssetProperty>(assetProperty);
            this.graphic = graphic;
            boolean created = false;
            boolean modified = false;
            boolean active = false;
            if (assetProperty instanceof ICreatableAndModifiable) {
                FunctionCall fc = snapshot.getCurrentFunctionCall();
                if (((ICreatableAndModifiable)assetProperty).wasCreatedByFunction(fc)) {
                    created = true;
                }
                if (((ICreatableAndModifiable)assetProperty).wasPreviouslyModifiedByFunction(fc)) {
                    modified = true;
                }
            }
            if (assetProperty instanceof IAssetItem && ((IAssetItem)assetProperty).isAssetActive()) {
                active = true;
            }
            this.wasCreatedInThisFunction = created;
            this.wasModifiedInThisFunction = modified;
            this.wasActiveInThisFunction = active;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull String getValue() {
            return this.value;
        }

        public @Nullable IAssetProperty getAssetProperty() {
            return (IAssetProperty)this.assetProperty.get();
        }

        public @Nullable Image getGraphic() {
            return this.graphic;
        }

        public boolean wasCreatedInThisFunctionCall() {
            return this.wasCreatedInThisFunction;
        }

        public boolean wasModifiedInThisFunctionCall() {
            return this.wasModifiedInThisFunction;
        }

        public boolean wasActiveInThisFunctionCall() {
            return this.wasActiveInThisFunction;
        }
    }

    private static class RootTreeItem
    extends TreeItem<PropertyTableItem>
    implements IRepresentsSamePropertyTableItem {
        private RootTreeItem(@NonNull List<@NonNull KapiSpec> specs, @NonNull TraceStateSnapshot snapshot, @NonNull List<@NonNull IAssetProperty> propertiesStrongReferences) {
            ObservableList children = this.getChildren();
            for (KapiSpec spec : specs) {
                children.add((Object)new KapiSpecTreeItem(snapshot, spec, propertiesStrongReferences));
            }
        }

        @Override
        public boolean representsSamePropertyTableItem(@Nullable Object other) {
            return other instanceof RootTreeItem;
        }
    }
}

