/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.util.AppFinder;
import com.arm.mgd.core.util.executors.NamedSingleThreadExecutor;
import java.io.File;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ApplicationPathConfigurerDialogController {
    private final @NonNull String applicationName;
    private final @NonNull StringProperty currentPath = new SimpleStringProperty();
    private final @NonNull BooleanProperty isPathToApplicationValid = new SimpleBooleanProperty();
    private final @NonNull StringProperty pathValidityInfo = new SimpleStringProperty();
    private final @NonNull BooleanProperty autoDetectEnabled = new SimpleBooleanProperty();
    private final @NonNull StringProperty autoDetectInfo = new SimpleStringProperty();
    private final @NonNull NamedSingleThreadExecutor ioThread;
    private final @NonNull IntegerProperty ioTasksQueued = new SimpleIntegerProperty(0);
    private final @NonNull BooleanProperty ioInProgress = new SimpleBooleanProperty();

    public ApplicationPathConfigurerDialogController(@NonNull String applicationName, @NonNull String initialPath) {
        this.applicationName = applicationName;
        this.ioThread = new NamedSingleThreadExecutor(String.valueOf(applicationName) + " finder thread", true);
        this.autoDetectEnabled.set(true);
        this.autoDetectInfo.set((Object)("Attempt to locate " + applicationName + " by searching through directories specified in the PATH environment variable."));
        this.currentPath.addListener((observable, oldValue, newValue) -> this.onPathChange((String)newValue));
        this.currentPath.set((Object)initialPath);
        this.ioInProgress.bind((ObservableValue)this.ioTasksQueued.greaterThan(0));
    }

    public void dispose() {
        this.ioThread.shutdown();
    }

    private void enqueueOnIoThread(@NonNull Runnable runnable) {
        assert (Platform.isFxApplicationThread());
        this.ioTasksQueued.set(this.ioTasksQueued.get() + 1);
        this.ioThread.runLater(() -> {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> {
                    this.ioTasksQueued.set(this.ioTasksQueued.get() - 1);
                    assert (this.ioTasksQueued.get() >= 0);
                });
                throw throwable;
            }
            Platform.runLater(() -> {
                this.ioTasksQueued.set(this.ioTasksQueued.get() - 1);
                assert (this.ioTasksQueued.get() >= 0);
            });
        });
    }

    private void onPathChange(@Nullable String newPath) {
        assert (Platform.isFxApplicationThread());
        this.isPathToApplicationValid.set(false);
        if (newPath == null || newPath.isEmpty()) {
            this.pathValidityInfo.set((Object)("Enter the path to " + this.applicationName + "."));
        } else {
            this.enqueueOnIoThread(() -> {
                File file = new File(newPath);
                boolean exists = file.exists();
                boolean isFile = file.isFile();
                boolean canExecute = file.canExecute();
                Platform.runLater(() -> {
                    if (newPath.equals(this.currentPath.get())) {
                        if (exists) {
                            if (isFile) {
                                if (canExecute) {
                                    this.isPathToApplicationValid.set(true);
                                    this.pathValidityInfo.set((Object)(String.valueOf(newPath) + " is a valid executable."));
                                } else {
                                    this.pathValidityInfo.set((Object)(String.valueOf(newPath) + " is not executable."));
                                }
                            } else {
                                this.pathValidityInfo.set((Object)(String.valueOf(newPath) + " is not a file."));
                            }
                        } else {
                            this.pathValidityInfo.set((Object)(String.valueOf(newPath) + " does not exist."));
                        }
                    }
                });
            });
        }
    }

    public void autoDetectFromPath() {
        assert (Platform.isFxApplicationThread());
        this.enqueueOnIoThread(() -> {
            try {
                File detectedFile = AppFinder.locate((String)this.applicationName);
                Platform.runLater(() -> {
                    if (detectedFile != null) {
                        this.currentPath.set((Object)detectedFile.getAbsolutePath());
                    } else {
                        this.autoDetectInfo.set((Object)("Couldn't locate " + this.applicationName + ". (Tried directories specified in the PATH environment variable.)"));
                        this.autoDetectEnabled.set(false);
                    }
                });
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        });
    }

    public @NonNull StringProperty currentPathProperty() {
        return this.currentPath;
    }

    public @NonNull ReadOnlyBooleanProperty isPathToApplicationValidProperty() {
        return this.isPathToApplicationValid;
    }

    public @NonNull ReadOnlyStringProperty pathValidityInfoProperty() {
        return this.pathValidityInfo;
    }

    public @NonNull ReadOnlyBooleanProperty ioInProgressProperty() {
        return this.ioInProgress;
    }

    public @NonNull ReadOnlyStringProperty autoDetectInfoProperty() {
        return this.autoDetectInfo;
    }

    public @NonNull ReadOnlyBooleanProperty autoDetectEnabledProperty() {
        return this.autoDetectEnabled;
    }
}

