/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBTaskManager;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.Resolution;
import com.arm.mgd.core.util.deviceinfo.EglConfigInfo;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AndroidDeviceControlItemFrameBufferConfig {
    private final @NonNull ADBTaskManager taskManager;
    private final @NonNull AndroidBridge androidBridge;
    private final @Nullable ADBDevice device;
    private final @NonNull ObjectProperty<@NonNull Info> info;
    private final @Nullable ArrayList<EglConfigInfo> eglConfigs;
    private Resolution resolution;
    private EglConfigInfo config;

    AndroidDeviceControlItemFrameBufferConfig(@NonNull ADBTaskManager taskManager, @NonNull AndroidBridge androidBridge, @Nullable ADBDevice device) {
        this.taskManager = taskManager;
        this.androidBridge = androidBridge;
        this.device = device;
        this.info = new SimpleObjectProperty((Object)new Info(FrameBufferConfigStatus.NOT_FORCED, ""));
        this.resolution = null;
        this.config = null;
        if (this.device != null) {
            this.eglConfigs = new ArrayList();
            this.retriveEglConfigs();
        } else {
            this.eglConfigs = null;
        }
        this.updateConfigStatus();
    }

    void updateConfigStatus() {
        assert (Platform.isFxApplicationThread());
        ADBDevice localDevice = this.device;
        if (localDevice == null) {
            this.info.set((Object)new Info(FrameBufferConfigStatus.DISCONNECTED, "Can't connect to a device that isn't online"));
        } else {
            this.info.set((Object)new Info(FrameBufferConfigStatus.NOT_FORCED, localDevice + " is connected"));
        }
    }

    private void retriveEglConfigs() {
        assert (this.device != null);
        try {
            String[] configsList;
            String strConfigs = this.retrieveStrEglConfigs();
            String[] stringArray = configsList = strConfigs.split("\n");
            int n = configsList.length;
            int n2 = 0;
            while (n2 < n) {
                String tmpConfig = stringArray[n2];
                if (tmpConfig.startsWith("query-configs")) {
                    EglConfigInfo eglConfigInfo = new EglConfigInfo(tmpConfig);
                    StringBuilder sb = new StringBuilder();
                    for (String attribName : eglConfigInfo.getAttribs().keySet()) {
                        if (attribName.equals("query-configs")) continue;
                        sb.append(attribName).append(":").append(eglConfigInfo.getAttrib(attribName));
                    }
                    assert (this.eglConfigs != null);
                    this.eglConfigs.add(eglConfigInfo);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private @NonNull String retrieveStrEglConfigs() {
        if (this.device == null) {
            return "";
        }
        final CompletableFuture<@NonNull T> resultFuture = new CompletableFuture();
        assert (this.device != null);
        this.taskManager.submitPrivateTask(this.androidBridge.getDeviceEGLConfigs(this.device), completedTask -> completedTask.accept((ADBTaskManager.CompletedTask.CompletedTaskVisitor)new ADBTaskManager.CompletedTask.CompletedTaskVisitor<String>(){

            public void onTaskSuccess(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull IADBTask.TaskResult<String> result) {
                String localOutput = (String)result.getResults();
                if (!$assertionsDisabled && localOutput == null) {
                    throw new AssertionError();
                }
                resultFuture.complete(localOutput);
            }

            public void onTaskThrewInvalidADBException(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull IADBTask.InvalidADBException exception) {
                resultFuture.completeExceptionally((Throwable)exception);
            }

            public void onTaskThrewADBExecutionException(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull IADBTask.ADBExecutionException exception) {
                resultFuture.completeExceptionally(exception);
            }
        }));
        try {
            return (String)resultFuture.get();
        }
        catch (Exception e) {
            assert (this.device != null);
            CoreLogging.warning(null, (Throwable)e, (String)("Failed to read EGL configs from device: " + this.device.getID()));
            return "";
        }
    }

    public @NonNull ReadOnlyObjectProperty<@NonNull Info> infoProperty() {
        return this.info;
    }

    public void setResolution(int width, int height) {
        this.resolution = new Resolution(width, height);
        if (((Info)this.info.getValue()).status == FrameBufferConfigStatus.FB_VP_FORCED) {
            return;
        }
        if (((Info)this.info.getValue()).status == FrameBufferConfigStatus.FB_FORCED) {
            this.info.set((Object)new Info(FrameBufferConfigStatus.FB_VP_FORCED, ""));
        } else {
            this.info.set((Object)new Info(FrameBufferConfigStatus.VP_FORCED, ""));
        }
    }

    public void resetResolution() {
        this.resolution = null;
        if (((Info)this.info.getValue()).status == FrameBufferConfigStatus.FB_VP_FORCED) {
            this.info.set((Object)new Info(FrameBufferConfigStatus.FB_FORCED, ""));
        } else if (((Info)this.info.getValue()).status == FrameBufferConfigStatus.VP_FORCED) {
            this.info.set((Object)new Info(FrameBufferConfigStatus.NOT_FORCED, ""));
        }
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setConfig(EglConfigInfo config) {
        this.config = config;
        if (((Info)this.info.getValue()).status == FrameBufferConfigStatus.FB_VP_FORCED) {
            return;
        }
        if (((Info)this.info.getValue()).status == FrameBufferConfigStatus.VP_FORCED) {
            this.info.set((Object)new Info(FrameBufferConfigStatus.FB_VP_FORCED, ""));
        } else {
            this.info.set((Object)new Info(FrameBufferConfigStatus.FB_FORCED, ""));
        }
    }

    public void resetConfig() {
        this.config = null;
        if (((Info)this.info.getValue()).status == FrameBufferConfigStatus.FB_VP_FORCED) {
            this.info.set((Object)new Info(FrameBufferConfigStatus.VP_FORCED, ""));
        } else if (((Info)this.info.getValue()).status == FrameBufferConfigStatus.FB_FORCED) {
            this.info.set((Object)new Info(FrameBufferConfigStatus.NOT_FORCED, ""));
        }
    }

    public EglConfigInfo getConfig() {
        return this.config;
    }

    public ArrayList<EglConfigInfo> getAvalaibleConfigs() {
        return this.eglConfigs;
    }

    public static enum FrameBufferConfigStatus {
        DISCONNECTED,
        FB_FORCED,
        VP_FORCED,
        FB_VP_FORCED,
        NOT_FORCED;

    }

    public class Info {
        private final @NonNull FrameBufferConfigStatus status;
        private final @Nullable String statusInfo;

        private Info(@Nullable FrameBufferConfigStatus status, String info) {
            this.status = status;
            this.statusInfo = info;
        }

        public @NonNull FrameBufferConfigStatus getStatus() {
            return this.status;
        }

        public @Nullable String getInfo() {
            return this.statusInfo;
        }

        public @NonNull AndroidDeviceControlItemFrameBufferConfig getConfig() {
            return AndroidDeviceControlItemFrameBufferConfig.this;
        }
    }
}

