/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBTaskManager;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.adb.AndroidPackageTraceManager;
import com.arm.mgd.core.adb.IAndroidPackageTraceManager;
import com.arm.mgd.ui.handlers.ConnectTargetHandler;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.LiveTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AndroidDeviceControlItemConnection {
    private final @NonNull ADBTaskManager taskManager;
    private final @NonNull AndroidBridge androidBridge;
    private final @Nullable ADBDevice device;
    private final @NonNull ObjectProperty<@NonNull Info> info;
    private final @NonNull ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AndroidBridge.ConnectionOperationTag> operationsInProgress = new ArrayList();
    private final @NonNull ObjectProperty<// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable AndroidBridge.ConnectionOperationTag> currentOperation = new SimpleObjectProperty();
    private final @NonNull ReadOnlyBooleanWrapper isDeviceConnectedProperty;

    AndroidDeviceControlItemConnection(@NonNull ADBTaskManager taskManager, @NonNull AndroidBridge androidBridge, @Nullable ADBDevice device, @NonNull ReadOnlyBooleanWrapper isDeviceConnected) {
        this.taskManager = taskManager;
        this.androidBridge = androidBridge;
        this.device = device;
        this.info = new SimpleObjectProperty((Object)new Info(ConnectionStatus.OPERATION_IN_PROGRESS, "Checking connection status"));
        this.currentOperation.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                switch (newValue) {
                    case CONNECT_TAG: {
                        this.info.set((Object)new Info(ConnectionStatus.OPERATION_IN_PROGRESS, "Connecting"));
                        break;
                    }
                    case DISCONNECT_TAG: {
                        this.info.set((Object)new Info(ConnectionStatus.OPERATION_IN_PROGRESS, "Disconnecting"));
                        break;
                    }
                    case REPLAY_UPLOAD_TAG: {
                        this.info.set((Object)new Info(ConnectionStatus.OPERATION_IN_PROGRESS, "Uploading"));
                        break;
                    }
                    case REPLAY_TAG: {
                        this.info.set((Object)new Info(ConnectionStatus.OPERATION_IN_PROGRESS, "Replaying"));
                        break;
                    }
                    case PER_APP_TRACING_START_APP: {
                        this.info.set((Object)new Info(ConnectionStatus.OPERATION_IN_PROGRESS, "Starting"));
                        break;
                    }
                    case CONFIG_UPLOAD_TAG: 
                    case CONFIG_DELETE_TAG: {
                        break;
                    }
                    default: {
                        throw new AssertionError(newValue);
                    }
                }
            }
        });
        this.isDeviceConnectedProperty = isDeviceConnected;
    }

    void updateConnectionStatus() {
        assert (Platform.isFxApplicationThread());
        if (this.currentOperation.get() != null) {
            return;
        }
        ADBDevice localDevice = this.device;
        if (localDevice == null) {
            this.info.set((Object)new Info(ConnectionStatus.DISCONNECTED_AND_CANT_CONNECT, "Can't connect to a device that isn't online"));
            this.isDeviceConnectedProperty.set(false);
        } else {
            LiveTargetConnection connection = TargetConnectionManager.getLiveConnectionToADBDevice(localDevice);
            if (connection != null) {
                this.info.set((Object)new Info(ConnectionStatus.CONNECTED, localDevice + " is connected"));
                this.isDeviceConnectedProperty.set(true);
            } else {
                this.info.set((Object)new Info(ConnectionStatus.DISCONNECTED_AND_CAN_BE_CONNECTED_TO, localDevice + " is not connected"));
                this.isDeviceConnectedProperty.set(false);
            }
        }
    }

    void onConnectionOperationStart(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AndroidBridge.ConnectionOperationTag tag) {
        this.operationsInProgress.add(tag);
        this.currentOperation.set((Object)this.operationsInProgress.get(0));
    }

    void onConnectionOperationEnd(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AndroidBridge.ConnectionOperationTag tag) {
        boolean removed = this.operationsInProgress.remove(tag);
        assert (removed);
        AndroidBridge.ConnectionOperationTag newOperation = this.operationsInProgress.isEmpty() ? null : this.operationsInProgress.get(0);
        this.currentOperation.set((Object)newOperation);
        this.updateConnectionStatus();
    }

    public boolean canConnect() {
        assert (Platform.isFxApplicationThread());
        return this.device != null && ((Info)this.info.get()).getStatus().equals((Object)ConnectionStatus.DISCONNECTED_AND_CAN_BE_CONNECTED_TO);
    }

    public void connect(@Nullable Consumer<@NonNull LiveTargetConnection> onConnectionSuccessCallback, @Nullable AndroidPackageTraceManager traceManager) {
        assert (Platform.isFxApplicationThread());
        if (this.canConnect()) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            this.taskManager.submitPublicTask(this.androidBridge.connectToDevice((ADBDevice)NullUtils.neverNull((Object)this.device), (ip, port) -> {
                LiveTargetConnection connection = ConnectTargetHandler.doConnectTargetSynchronous(ip, port, this.device, (IAndroidPackageTraceManager)traceManager, this.androidBridge, window);
                if (connection != null && onConnectionSuccessCallback != null) {
                    onConnectionSuccessCallback.accept(connection);
                }
                return connection != null;
            }));
            this.currentOperation.set((Object)AndroidBridge.ConnectionOperationTag.CONNECT_TAG);
        }
    }

    public boolean canDisconnect() {
        assert (Platform.isFxApplicationThread());
        return this.device != null && ((Info)this.info.get()).getStatus().equals((Object)ConnectionStatus.CONNECTED);
    }

    public void disconnect() {
        assert (Platform.isFxApplicationThread());
        if (this.canDisconnect()) {
            this.taskManager.submitPublicTask(this.androidBridge.disconnectFromDevice((ADBDevice)NullUtils.neverNull((Object)this.device), () -> {
                LiveTargetConnection connection = TargetConnectionManager.getLiveConnectionToADBDevice((ADBDevice)NullUtils.neverNull((Object)this.device));
                if (connection != null) {
                    ((AbstractTargetConnection)connection).disconnect();
                }
            }));
            this.currentOperation.set((Object)AndroidBridge.ConnectionOperationTag.DISCONNECT_TAG);
        }
    }

    public @NonNull ReadOnlyObjectProperty<@NonNull Info> infoProperty() {
        return this.info;
    }

    public static enum ConnectionStatus {
        OPERATION_IN_PROGRESS,
        DISCONNECTED_AND_CAN_BE_CONNECTED_TO,
        CONNECTED,
        DISCONNECTED_AND_CANT_CONNECT;

    }

    public class Info {
        private final @NonNull ConnectionStatus status;
        private final @Nullable String statusInfo;

        private Info(@Nullable ConnectionStatus status, String info) {
            this.status = status;
            this.statusInfo = info;
        }

        public @NonNull ConnectionStatus getStatus() {
            return this.status;
        }

        public @Nullable String getInfo() {
            return this.statusInfo;
        }

        public @NonNull AndroidDeviceControlItemConnection getConnection() {
            return AndroidDeviceControlItemConnection.this;
        }
    }
}

