/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.ADBTaskManager;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItemConnection;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItemFrameBufferConfig;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AndroidDeviceControlItem {
    private final @NonNull ADBTaskManager taskManager;
    private final @NonNull AndroidBridge androidBridge;
    private final @NonNull ADBDeviceIdentifier deviceIdentifier;
    private final @Nullable ADBDevice device;
    private final @NonNull AndroidDeviceControlItemConnection connection;
    private final @NonNull InstallableComponent rootInterceptorComponent;
    private final @NonNull InstallableComponent rootVulkanLayerComponent;
    private final @NonNull AndroidDeviceControlItemFrameBufferConfig framebufferConfig;
    private final @NonNull ReadOnlyBooleanWrapper isDeviceOnlineProperty;
    private final @NonNull ReadOnlyBooleanWrapper isDeviceConnectedProperty = new ReadOnlyBooleanWrapper();

    AndroidDeviceControlItem(@NonNull ADBTaskManager taskManager, @NonNull AndroidBridge androidBridge, @NonNull ADBDeviceIdentifier deviceIdentifier, @Nullable ADBDevice device) {
        assert (Platform.isFxApplicationThread());
        this.taskManager = taskManager;
        this.androidBridge = androidBridge;
        this.deviceIdentifier = deviceIdentifier;
        this.device = device;
        if (device != null) {
            this.rootInterceptorComponent = new RootInterceptorComponent(taskManager, androidBridge, device);
            this.rootVulkanLayerComponent = new RootVulkanLayerComponent(taskManager, androidBridge, device);
        } else {
            this.rootInterceptorComponent = new NullDeviceComponent();
            this.rootVulkanLayerComponent = new NullDeviceComponent();
        }
        this.connection = new AndroidDeviceControlItemConnection(taskManager, androidBridge, device, this.isDeviceConnectedProperty);
        this.framebufferConfig = new AndroidDeviceControlItemFrameBufferConfig(taskManager, androidBridge, device);
        this.isDeviceOnlineProperty = new ReadOnlyBooleanWrapper(this.device != null);
    }

    private @Nullable InstallableComponent getComponentForComponentType(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AndroidBridge.InstallableComponentType componentType) {
        switch (componentType) {
            case ROOT_DAEMON: {
                return null;
            }
            case ROOT_INTERCEPTOR: {
                return this.getRootInterceptorComponent();
            }
            case ROOT_VULKAN_LAYER: {
                return this.getRootVulkanLayerComponent();
            }
            case PER_APP_TRACING: {
                return null;
            }
        }
        assert (false) : componentType;
        return null;
    }

    void onAddTaggedTask(@NonNull Object tag) {
        if (tag instanceof AndroidBridge.InstallableComponentOperationTag) {
            AndroidBridge.InstallableComponentOperationTag operationTag = (AndroidBridge.InstallableComponentOperationTag)tag;
            InstallableComponent component = this.getComponentForComponentType(operationTag.componentType);
            if (component != null) {
                component.onOperationStart(operationTag.operationType);
            }
        } else if (tag instanceof AndroidBridge.ConnectionOperationTag) {
            this.connection.onConnectionOperationStart((AndroidBridge.ConnectionOperationTag)tag);
        }
    }

    void onFinishTaggedTask(@NonNull Object tag, @Nullable Exception e) {
        if (tag instanceof AndroidBridge.InstallableComponentOperationTag) {
            AndroidBridge.InstallableComponentOperationTag operationTag = (AndroidBridge.InstallableComponentOperationTag)tag;
            InstallableComponent component = this.getComponentForComponentType(operationTag.componentType);
            if (component != null) {
                component.onOperationFinish(operationTag.operationType, e);
            }
        } else if (tag instanceof AndroidBridge.ConnectionOperationTag) {
            this.connection.onConnectionOperationEnd((AndroidBridge.ConnectionOperationTag)tag);
        }
    }

    void refresh(boolean refreshAllComponents) {
        this.connection.updateConnectionStatus();
        AndroidBridge.InstallableComponentType[] installableComponentTypeArray = AndroidBridge.InstallableComponentType.values();
        int n = installableComponentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidBridge.InstallableComponentType type = installableComponentTypeArray[n2];
            InstallableComponent component = this.getComponentForComponentType(type);
            if (component != null && (refreshAllComponents || !component.isExpensiveToQuery())) {
                component.refresh();
            }
            ++n2;
        }
    }

    boolean canBeRebooted() {
        return this.device != null;
    }

    void reboot() {
        if (this.canBeRebooted()) {
            this.taskManager.submitPublicTask(this.androidBridge.rebootDevice((ADBDevice)NullUtils.neverNull((Object)this.device)));
        }
    }

    public void updateInstalledPackages(final @NonNull InstalledPackageListener listener) {
        if (this.device == null) {
            listener.installedPackagesUpdated(new ArrayList<ADBInstalledPackage>());
            return;
        }
        assert (this.device != null);
        this.taskManager.submitPrivateTask(this.androidBridge.getInstalledPackages(this.device), completedTask -> completedTask.accept((ADBTaskManager.CompletedTask.CompletedTaskVisitor)new ADBTaskManager.CompletedTask.CompletedTaskVisitor<List<ADBInstalledPackage>>(){

            public void onTaskSuccess(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull IADBTask.TaskResult<@NonNull List<@NonNull ADBInstalledPackage>> result) {
                listener.installedPackagesUpdated((List)result.getResults());
            }

            public void onTaskThrewInvalidADBException(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull IADBTask.InvalidADBException exception) {
                listener.installedPackagesUpdated(new ArrayList<ADBInstalledPackage>());
            }

            public void onTaskThrewADBExecutionException(// Could not load outer class - annotation placement on inner may be incorrect
             @NonNull IADBTask.ADBExecutionException exception) {
                listener.installedPackagesUpdated(new ArrayList<ADBInstalledPackage>());
            }
        }));
    }

    public void uploadReplayFile(@NonNull File fileToUpload) {
        if (this.device != null) {
            this.taskManager.submitPublicTask(this.androidBridge.uploadReplayFile(this.device, fileToUpload));
        }
    }

    public void uploadConfigurationFile(@NonNull File fileToUpload) {
        if (this.device != null) {
            this.taskManager.submitPublicTask(this.androidBridge.uploadCounterConfigurationFile(this.device, fileToUpload));
        }
    }

    public void deleteConfigurationFiles() {
        if (this.device != null) {
            this.taskManager.submitPublicTask(this.androidBridge.deleteCounterConfigurationFiles(this.device));
        }
    }

    public @Nullable ADBDevice getDevice() {
        return this.device;
    }

    public @NonNull ADBDeviceIdentifier getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public @NonNull AndroidDeviceControlItemConnection getConnection() {
        return this.connection;
    }

    public @NonNull AndroidDeviceControlItemFrameBufferConfig getFramebufferConfig() {
        return this.framebufferConfig;
    }

    public @NonNull InstallableComponent getRootInterceptorComponent() {
        return this.rootInterceptorComponent;
    }

    public @NonNull InstallableComponent getRootVulkanLayerComponent() {
        return this.rootVulkanLayerComponent;
    }

    public @NonNull ReadOnlyBooleanProperty getDeviceOnlineProperty() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.isDeviceOnlineProperty.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyBooleanProperty getDeviceConnectedProperty() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.isDeviceConnectedProperty.getReadOnlyProperty());
    }

    public static abstract class InstallableComponent {
        private final @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull AndroidBridge.InstallableComponentOperationType> operationsInProgress = new ArrayList<AndroidBridge.InstallableComponentOperationType>();
        private final @NonNull ObjectProperty<// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable AndroidBridge.InstallableComponentOperationType> currentOperation = new SimpleObjectProperty();
        private final @NonNull ObjectProperty<@NonNull Info> info = new SimpleObjectProperty((Object)new Info(InstallStatus.OPERATION_IN_PROGRESS, "Checking status", null));
        private boolean refreshInProgress = false;
        private @Nullable String errorToPropagateOnRefresh = null;

        private InstallableComponent() {
            this.currentOperation.addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    switch (newValue) {
                        case INSTALL: {
                            this.info.set((Object)new Info(InstallStatus.OPERATION_IN_PROGRESS, "Installing", null));
                            break;
                        }
                        case UNINSTALL: {
                            this.info.set((Object)new Info(InstallStatus.OPERATION_IN_PROGRESS, "Uninstalling", null));
                            break;
                        }
                        case QUERY_STATUS: {
                            break;
                        }
                        default: {
                            throw new AssertionError(newValue);
                        }
                    }
                }
            });
        }

        private void onOperationStart(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull AndroidBridge.InstallableComponentOperationType operationType) {
            this.operationsInProgress.add(operationType);
            this.currentOperation.set((Object)this.operationsInProgress.get(0));
        }

        private void onOperationFinish(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull AndroidBridge.InstallableComponentOperationType operationType, @Nullable Exception e) {
            boolean removed = this.operationsInProgress.remove(operationType);
            assert (removed);
            AndroidBridge.InstallableComponentOperationType newOperation = this.operationsInProgress.isEmpty() ? null : this.operationsInProgress.get(0);
            this.currentOperation.set((Object)newOperation);
            this.errorToPropagateOnRefresh = e != null ? e.getMessage() : null;
            this.refresh();
        }

        public boolean canBeInstalled() {
            return ((Info)this.info.get()).status.canBeInstalled && this.currentOperation.get() == null;
        }

        public boolean canBeUninstalled() {
            return ((Info)this.info.get()).status.canBeUninstalled && this.currentOperation.get() == null;
        }

        public void install() {
            assert (Platform.isFxApplicationThread());
            if (this.canBeInstalled()) {
                this.currentOperation.set((Object)AndroidBridge.InstallableComponentOperationType.INSTALL);
                this.doInstall();
            }
        }

        public void uninstall() {
            assert (Platform.isFxApplicationThread());
            if (this.canBeUninstalled()) {
                this.currentOperation.set((Object)AndroidBridge.InstallableComponentOperationType.UNINSTALL);
                this.doUninstall();
            }
        }

        public @NonNull ReadOnlyObjectProperty<@NonNull Info> infoProperty() {
            return this.info;
        }

        private void refresh() {
            assert (Platform.isFxApplicationThread());
            if (this.currentOperation.get() == null && !this.refreshInProgress) {
                this.refreshInProgress = true;
                this.queryStatus().thenAccept(result -> Platform.runLater(() -> {
                    this.refreshInProgress = false;
                    if (this.currentOperation.get() == null) {
                        if (this.errorToPropagateOnRefresh != null) {
                            this.info.set((Object)new Info(installQueryResult.status, installQueryResult.info, this.errorToPropagateOnRefresh));
                            this.errorToPropagateOnRefresh = null;
                        } else if (installQueryResult.exception != null) {
                            this.info.set((Object)new Info(installQueryResult.status, installQueryResult.info, installQueryResult.exception.getMessage()));
                        } else if (((Info)this.info.get()).getStatus() != installQueryResult.status) {
                            this.info.set((Object)new Info(installQueryResult.status, installQueryResult.info, null));
                        }
                    }
                }));
            }
        }

        protected abstract boolean isExpensiveToQuery();

        public abstract boolean isRootComponent();

        public abstract @NonNull String name();

        protected abstract @NonNull CompletableFuture<@NonNull InstallQueryResult> queryStatus();

        protected abstract void doInstall();

        protected abstract void doUninstall();

        public class Info {
            private final @NonNull InstallStatus status;
            private final @Nullable String statusInfo;
            private final @Nullable String errorMessage;

            private Info(@Nullable InstallStatus status, @Nullable String statusInfo, String errorMessage) {
                this.status = status;
                this.statusInfo = statusInfo;
                this.errorMessage = errorMessage;
            }

            public @NonNull InstallableComponent getInstallableComponent() {
                return InstallableComponent.this;
            }

            public @NonNull InstallStatus getStatus() {
                return this.status;
            }

            public @Nullable String getStatusInfo() {
                return this.statusInfo;
            }

            public @Nullable String getErrorMessage() {
                return this.errorMessage;
            }
        }

        protected static class InstallQueryResult {
            public final @NonNull InstallStatus status;
            public final @Nullable String info;
            public final @Nullable Exception exception;

            public InstallQueryResult(@NonNull InstallStatus status, @Nullable String info, @Nullable Exception exception) {
                this.status = status;
                this.info = info;
                this.exception = exception;
            }
        }

        public static enum InstallStatus {
            OPERATION_IN_PROGRESS(false, false),
            CAN_NOT_BE_INSTALLED(false, false),
            NOT_INSTALLED_AND_CAN_BE_INSTALLED(true, false),
            INSTALLED_BUT_NEEDS_UPDATE(true, true),
            INSTALLED_AND_UP_TO_DATE(true, true);

            private final boolean canBeInstalled;
            private final boolean canBeUninstalled;

            private InstallStatus(boolean canBeInstalled, boolean canBeUninstalled) {
                this.canBeInstalled = canBeInstalled;
                this.canBeUninstalled = canBeUninstalled;
            }
        }
    }

    private static class InstallableComponentStatusVisitor
    implements ADBTaskManager.CompletedTask.CompletedTaskVisitor<AndroidBridge.InstallableComponentStatus> {
        final @NonNull CompletableFuture<@NonNull InstallableComponent.InstallQueryResult> futureToComplete;

        private InstallableComponentStatusVisitor(@NonNull CompletableFuture<@NonNull InstallableComponent.InstallQueryResult> futureToComplete) {
            this.futureToComplete = futureToComplete;
        }

        public void onTaskSuccess(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IADBTask.TaskResult<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull AndroidBridge.InstallableComponentStatus> result) {
            switch ((AndroidBridge.InstallableComponentStatus)result.getResults()) {
                case INSTALLED: {
                    this.futureToComplete.complete(new InstallableComponent.InstallQueryResult(InstallableComponent.InstallStatus.INSTALLED_AND_UP_TO_DATE, "Installed", null));
                    break;
                }
                case NOT_INSTALLED: {
                    this.futureToComplete.complete(new InstallableComponent.InstallQueryResult(InstallableComponent.InstallStatus.NOT_INSTALLED_AND_CAN_BE_INSTALLED, "Not installed", null));
                    break;
                }
                case NOT_INSTALLED_NOT_ROOTED: {
                    this.futureToComplete.complete(new InstallableComponent.InstallQueryResult(InstallableComponent.InstallStatus.NOT_INSTALLED_AND_CAN_BE_INSTALLED, "No root access", null));
                    break;
                }
                case OUT_OF_DATE: {
                    this.futureToComplete.complete(new InstallableComponent.InstallQueryResult(InstallableComponent.InstallStatus.INSTALLED_BUT_NEEDS_UPDATE, "Needs update", null));
                    break;
                }
                case CAN_NOT_BE_INSTALLED_UNSUPPORTED_ARCH: {
                    this.futureToComplete.complete(new InstallableComponent.InstallQueryResult(InstallableComponent.InstallStatus.CAN_NOT_BE_INSTALLED, "Unsupported architecture", null));
                    break;
                }
                case CAN_NOT_BE_INSTALLED_VULKAN_UNSUPPORTED: {
                    this.futureToComplete.complete(new InstallableComponent.InstallQueryResult(InstallableComponent.InstallStatus.CAN_NOT_BE_INSTALLED, "Not supported", null));
                    break;
                }
                case CAN_NOT_BE_INSTALLED_OS_VERSION_UNSUPPORTED: {
                    this.futureToComplete.complete(new InstallableComponent.InstallQueryResult(InstallableComponent.InstallStatus.CAN_NOT_BE_INSTALLED, "OS version unsupported", null));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public void onTaskThrewInvalidADBException(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IADBTask.InvalidADBException exception) {
            this.futureToComplete.complete(new InstallableComponent.InstallQueryResult(InstallableComponent.InstallStatus.CAN_NOT_BE_INSTALLED, "Error", (Exception)exception));
        }

        public void onTaskThrewADBExecutionException(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IADBTask.ADBExecutionException exception) {
            this.futureToComplete.complete(new InstallableComponent.InstallQueryResult(InstallableComponent.InstallStatus.CAN_NOT_BE_INSTALLED, "Error", (Exception)((Object)exception)));
        }
    }

    public static interface InstalledPackageListener {
        public void installedPackagesUpdated(@NonNull List<@NonNull ADBInstalledPackage> var1);
    }

    private static class NullDeviceComponent
    extends InstallableComponent {
        private NullDeviceComponent() {
        }

        @Override
        protected boolean isExpensiveToQuery() {
            return true;
        }

        @Override
        protected @NonNull CompletableFuture<@NonNull InstallableComponent.InstallQueryResult> queryStatus() {
            return (CompletableFuture)NullUtils.neverNull(CompletableFuture.completedFuture(new InstallableComponent.InstallQueryResult(InstallableComponent.InstallStatus.CAN_NOT_BE_INSTALLED, "N/A", null)));
        }

        @Override
        protected void doInstall() {
        }

        @Override
        protected void doUninstall() {
        }

        @Override
        public boolean isRootComponent() {
            return false;
        }

        @Override
        public @NonNull String name() {
            return "a component of " + VersionProperties.FULL_PRODUCT_NAME;
        }
    }

    private static class RootInterceptorComponent
    extends InstallableComponent {
        private final @NonNull ADBTaskManager taskManager;
        private final @NonNull AndroidBridge androidBridge;
        private final @NonNull ADBDevice device;

        private RootInterceptorComponent(@NonNull ADBTaskManager taskManager, @NonNull AndroidBridge androidBridge, @NonNull ADBDevice device) {
            this.taskManager = taskManager;
            this.androidBridge = androidBridge;
            this.device = device;
        }

        @Override
        protected void doInstall() {
            this.taskManager.submitPublicTask(this.androidBridge.installRootInterceptor(this.device));
        }

        @Override
        protected void doUninstall() {
            this.taskManager.submitPublicTask(this.androidBridge.uninstallRootInterceptor(this.device));
        }

        @Override
        protected boolean isExpensiveToQuery() {
            return true;
        }

        @Override
        protected @NonNull CompletableFuture<@NonNull InstallableComponent.InstallQueryResult> queryStatus() {
            CompletableFuture<@NonNull InstallableComponent.InstallQueryResult> resultFuture = new CompletableFuture<InstallableComponent.InstallQueryResult>();
            this.taskManager.submitPrivateTask(this.androidBridge.getRootInterceptorInstallStatus(this.device), completedTask -> completedTask.accept((ADBTaskManager.CompletedTask.CompletedTaskVisitor)new InstallableComponentStatusVisitor(resultFuture)));
            return resultFuture;
        }

        @Override
        public boolean isRootComponent() {
            return true;
        }

        @Override
        public @NonNull String name() {
            return "the system-level interceptor";
        }
    }

    private static class RootVulkanLayerComponent
    extends InstallableComponent {
        private final @NonNull ADBTaskManager taskManager;
        private final @NonNull AndroidBridge androidBridge;
        private final @NonNull ADBDevice device;

        private RootVulkanLayerComponent(@NonNull ADBTaskManager taskManager, @NonNull AndroidBridge androidBridge, @NonNull ADBDevice device) {
            this.taskManager = taskManager;
            this.androidBridge = androidBridge;
            this.device = device;
        }

        @Override
        protected void doInstall() {
            this.taskManager.submitPublicTask(this.androidBridge.installRootVulkanLayer(this.device));
        }

        @Override
        protected void doUninstall() {
            this.taskManager.submitPublicTask(this.androidBridge.uninstallRootVulkanLayer(this.device));
        }

        @Override
        protected boolean isExpensiveToQuery() {
            return true;
        }

        @Override
        protected @NonNull CompletableFuture<@NonNull InstallableComponent.InstallQueryResult> queryStatus() {
            CompletableFuture<@NonNull InstallableComponent.InstallQueryResult> resultFuture = new CompletableFuture<InstallableComponent.InstallQueryResult>();
            this.taskManager.submitPrivateTask(this.androidBridge.getRootVulkanLayerInstallStatus(this.device), completedTask -> completedTask.accept((ADBTaskManager.CompletedTask.CompletedTaskVisitor)new InstallableComponentStatusVisitor(resultFuture)));
            return resultFuture;
        }

        @Override
        public boolean isRootComponent() {
            return true;
        }

        @Override
        public @NonNull String name() {
            return "the system-level Vulkan layer";
        }
    }
}

