/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.adb.ADBTaskManager;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItem;
import com.arm.mgd.ui.dialogs.ApplicationPathConfigurerDialog;
import com.arm.mgd.ui.preferences.PreferenceConstant;
import com.arm.mgd.ui.targetconn.LiveTargetConnection;
import com.arm.mgd.utils.EclipseUtils;
import com.arm.mgd.utils.NullUtils;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.scene.control.SelectionModel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;

public class AndroidDeviceControlController {
    private final @NonNull ADBTaskManager taskManager = CoreInstance.getADBTaskManager();
    private final @NonNull ReadOnlyObjectWrapper<@Nullable AndroidBridge> adbWrapper = new ReadOnlyObjectWrapper();
    private final @NonNull BooleanProperty hasADBLoaded = new SimpleBooleanProperty();
    private final @NonNull StringProperty invalidADBReasonProperty = new SimpleStringProperty();
    private final @NonNull ListProperty<@NonNull AndroidDeviceControlItem> adbDeviceItems = new SimpleListProperty(FXCollections.observableArrayList());
    private final @NonNull HashMap<@NonNull ADBDeviceIdentifier, AndroidDeviceControlItem> deviceIdentifierToDeviceItemMap = new HashMap();
    private final @NonNull SelectionModel<AndroidDeviceControlItem> devicesSelectionModel;
    private final @NonNull ReadOnlyObjectProperty<AndroidDeviceControlItem> selectedDeviceItemProperty;
    private final @NonNull BooleanProperty blockingUpdateInProgress = new SimpleBooleanProperty();
    private boolean refreshDevicesInProgress = false;
    private boolean fullRefreshDevicesInProgress = false;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ADBTaskManager.PublicTaskListener listener;
    private final @NonNull HashMap<@NonNull ADBDevice, List<@NonNull Object>> runningTaskTags = new HashMap();
    private final @NonNull ScheduledFuture<?> scheduledRefreshDevices;
    private final @NonNull ScheduledFuture<?> scheduledRefreshComponents;

    public AndroidDeviceControlController(@NonNull SelectionModel<AndroidDeviceControlItem> devicesSelectionModel) {
        this.selectedDeviceItemProperty = (ReadOnlyObjectProperty)NullUtils.neverNull((Object)devicesSelectionModel.selectedItemProperty());
        this.devicesSelectionModel = devicesSelectionModel;
        this.hasADBLoaded.bind((ObservableValue)this.adbWrapper.isNotNull());
        this.listener = new ADBTaskManager.PublicTaskListener(){

            public void onTaskAdded(@NonNull IADBTask<Void> task) {
                Platform.runLater(() -> AndroidDeviceControlController.this.addTaggedTask(task.getDevice(), task.getTag()));
            }

            public void onTaskStarted(@NonNull IADBTask<Void> task) {
            }

            public void onTaskCompleted(final // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull ADBTaskManager.CompletedTask<Void> completedTask) {
                Platform.runLater(() -> completedTask.accept((ADBTaskManager.CompletedTask.CompletedTaskVisitor)new ADBTaskManager.CompletedTask.CompletedTaskVisitor<Void>(){

                    public void onTaskSuccess(// Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull IADBTask.TaskResult<Void> result) {
                        AndroidDeviceControlController.this.finishTaggedTask(result.getDevice(), completedTask.getTask().getTag(), null);
                    }

                    public void onTaskThrewInvalidADBException(// Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull IADBTask.InvalidADBException exception) {
                        AndroidDeviceControlController.this.onADBFailure((Exception)exception);
                    }

                    public void onTaskThrewADBExecutionException(// Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull IADBTask.ADBExecutionException exception) {
                        AndroidDeviceControlController.this.finishTaggedTask(completedTask.getTask().getDevice(), completedTask.getTask().getTag(), (Exception)((Object)exception));
                    }
                }));
            }

            public void onTaskRemoved(// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull ADBTaskManager.CompletedTask<Void> completedTask) {
            }
        };
        CoreInstance.getADBTaskManager().addListener(this.listener);
        ScheduledExecutorService scheduler = CoreInstance.getScheduledExecutorService();
        this.scheduledRefreshDevices = (ScheduledFuture)NullUtils.neverNull(scheduler.scheduleWithFixedDelay(() -> Platform.runLater(() -> this.refreshDevices()), 0L, 1L, TimeUnit.SECONDS));
        this.scheduledRefreshComponents = (ScheduledFuture)NullUtils.neverNull(scheduler.scheduleWithFixedDelay(() -> Platform.runLater(() -> this.refreshDeviceInfo()), 0L, 10L, TimeUnit.SECONDS));
        this.initializeADB();
    }

    public void dispose() {
        this.scheduledRefreshDevices.cancel(true);
        this.scheduledRefreshComponents.cancel(true);
        CoreInstance.getADBTaskManager().removeListener(this.listener);
        this.adbWrapper.set(null);
        this.adbDeviceItems.clear();
        this.deviceIdentifierToDeviceItemMap.clear();
    }

    private void addTaggedTask(@Nullable ADBDevice device, @Nullable Object tag) {
        if (device != null && tag != null) {
            boolean added = this.getRunningTaskTagList(device).add(tag);
            assert (added);
            AndroidDeviceControlItem item = this.deviceIdentifierToDeviceItemMap.get(device.getIdentifier());
            if (item != null) {
                item.onAddTaggedTask(tag);
            }
        }
    }

    private void finishTaggedTask(@Nullable ADBDevice device, @Nullable Object tag, @Nullable Exception e) {
        if (device != null && tag != null) {
            boolean removed = this.getRunningTaskTagList(device).remove(tag);
            assert (removed);
            AndroidDeviceControlItem item = this.deviceIdentifierToDeviceItemMap.get(device.getIdentifier());
            if (item != null) {
                item.onFinishTaggedTask(tag, e);
            }
        }
    }

    private @NonNull List<@NonNull Object> getRunningTaskTagList(@NonNull ADBDevice device) {
        List<@NonNull Object> retVal = this.runningTaskTags.get(device);
        if (retVal == null) {
            retVal = new ArrayList<Object>();
            this.runningTaskTags.put(device, retVal);
        }
        return retVal;
    }

    public void launchADBConfigurationDialog() {
        IPreferenceStore preferenceStore = PreferenceConstant.getPreferenceStore();
        String adbPath = preferenceStore.getString(PreferenceConstant.LOCATION_OF_ADB.getPreferenceName());
        assert (adbPath != null);
        new ApplicationPathConfigurerDialog("adb", adbPath, "Configure ADB Location").showAndWaitForResult().ifPresent(newPath -> preferenceStore.setValue(PreferenceConstant.LOCATION_OF_ADB.getPreferenceName(), newPath));
        this.initializeADB();
    }

    private void onADBFailure(@NonNull Exception e) {
        assert (Platform.isFxApplicationThread());
        this.blockingUpdateInProgress.set(false);
        this.refreshDevicesInProgress = false;
        this.fullRefreshDevicesInProgress = false;
        this.adbWrapper.set(null);
        this.adbDeviceItems.clear();
        this.deviceIdentifierToDeviceItemMap.clear();
        this.invalidADBReasonProperty.set((Object)e.getMessage());
    }

    private void initializeADB() {
        IPreferenceStore preferenceStore = PreferenceConstant.getPreferenceStore();
        String adbPath = preferenceStore.getString(PreferenceConstant.LOCATION_OF_ADB.getPreferenceName());
        assert (adbPath != null);
        if (adbPath.equals("")) {
            this.invalidADBReasonProperty.set((Object)"The path to ADB has not been set.");
        } else {
            this.blockingUpdateInProgress.set(true);
            @Nullable String currentDevPath = null;
            try {
                currentDevPath = AndroidDeviceControlController.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            String developmentRootDir = currentDevPath != null ? String.valueOf(currentDevPath) + "/../../../" : null;
            this.taskManager.submitPrivateTask(AndroidBridge.create((String)adbPath, (String)EclipseUtils.getRootInstallDirectory(), (String)developmentRootDir), completedTask -> Platform.runLater(() -> completedTask.accept((ADBTaskManager.CompletedTask.CompletedTaskVisitor)new ADBTaskManager.CompletedTask.CompletedTaskVisitor<AndroidBridge>(){

                public void onTaskSuccess(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IADBTask.TaskResult<@NonNull AndroidBridge> result) {
                    AndroidDeviceControlController.this.adbWrapper.set((Object)((AndroidBridge)result.getResults()));
                    AndroidDeviceControlController.this.invalidADBReasonProperty.set(null);
                    AndroidDeviceControlController.this.blockingUpdateInProgress.set(false);
                    AndroidDeviceControlController.this.fullRefreshDevices();
                }

                public void onTaskThrewInvalidADBException(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IADBTask.InvalidADBException exception) {
                    AndroidDeviceControlController.this.onADBFailure((Exception)exception);
                }

                public void onTaskThrewADBExecutionException(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IADBTask.ADBExecutionException exception) {
                    AndroidDeviceControlController.this.onADBFailure((Exception)((Object)exception));
                }
            })));
        }
    }

    private void addDevice(@NonNull AndroidBridge wrapper, @NonNull ADBDeviceIdentifier identifier, @Nullable ADBDevice device) {
        assert (Platform.isFxApplicationThread());
        AndroidDeviceControlItem existingItem = this.deviceIdentifierToDeviceItemMap.get(identifier);
        if (existingItem != null && !Objects.equals(existingItem.getDevice(), device)) {
            this.deviceIdentifierToDeviceItemMap.remove(identifier);
            this.adbDeviceItems.remove((Object)existingItem);
            existingItem = null;
        }
        if (existingItem == null) {
            AndroidDeviceControlItem item = new AndroidDeviceControlItem(this.taskManager, wrapper, identifier, device);
            this.adbDeviceItems.add((Object)item);
            this.deviceIdentifierToDeviceItemMap.put(identifier, item);
            if (device != null) {
                this.getRunningTaskTagList(device).forEach(taskTag -> item.onAddTaggedTask(taskTag));
            }
            item.refresh(true);
        }
    }

    public void fullRefreshDevices() {
        assert (Platform.isFxApplicationThread());
        if (this.fullRefreshDevicesInProgress) {
            return;
        }
        final AndroidBridge wrapper = (AndroidBridge)this.adbWrapper.get();
        if (wrapper != null) {
            this.fullRefreshDevicesInProgress = true;
            this.blockingUpdateInProgress.set(true);
            this.taskManager.submitPrivateTask(wrapper.getDevices(NullUtils.emptyMap()), completedTask -> Platform.runLater(() -> completedTask.accept((ADBTaskManager.CompletedTask.CompletedTaskVisitor)new ADBTaskManager.CompletedTask.CompletedTaskVisitor<Map<ADBDeviceIdentifier, ADBDevice>>(){

                public void onTaskSuccess(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IADBTask.TaskResult<@NonNull Map<@NonNull ADBDeviceIdentifier, @Nullable ADBDevice>> result) {
                    AndroidDeviceControlController.this.fullRefreshDevicesInProgress = false;
                    AndroidDeviceControlController.this.blockingUpdateInProgress.set(false);
                    AndroidDeviceControlController.this.adbDeviceItems.clear();
                    AndroidDeviceControlController.this.deviceIdentifierToDeviceItemMap.clear();
                    Map resultsMap = (Map)result.getResults();
                    resultsMap.entrySet().forEach(entry -> AndroidDeviceControlController.this.addDevice(wrapper, (ADBDeviceIdentifier)entry.getKey(), (ADBDevice)entry.getValue()));
                    if (!$assertionsDisabled && AndroidDeviceControlController.this.adbDeviceItems.size() != AndroidDeviceControlController.this.deviceIdentifierToDeviceItemMap.size()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && AndroidDeviceControlController.this.adbDeviceItems.size() != resultsMap.size()) {
                        throw new AssertionError();
                    }
                    if (AndroidDeviceControlController.this.adbDeviceItems.size() == 1) {
                        AndroidDeviceControlController.this.devicesSelectionModel.selectFirst();
                    }
                }

                public void onTaskThrewInvalidADBException(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IADBTask.InvalidADBException exception) {
                    AndroidDeviceControlController.this.onADBFailure((Exception)exception);
                }

                public void onTaskThrewADBExecutionException(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IADBTask.ADBExecutionException exception) {
                    AndroidDeviceControlController.this.onADBFailure((Exception)((Object)exception));
                }
            })));
        }
    }

    public void refreshDevices() {
        assert (Platform.isFxApplicationThread());
        if (this.refreshDevicesInProgress || this.fullRefreshDevicesInProgress) {
            return;
        }
        final AndroidBridge wrapper = (AndroidBridge)this.adbWrapper.get();
        if (wrapper != null) {
            this.refreshDevicesInProgress = true;
            HashMap<@NonNull ADBDeviceIdentifier, @Nullable ADBDevice> currentDeviceItemMap = new HashMap<ADBDeviceIdentifier, ADBDevice>();
            for (AndroidDeviceControlItem item : this.adbDeviceItems) {
                currentDeviceItemMap.put(item.getDeviceIdentifier(), item.getDevice());
            }
            this.taskManager.submitPrivateTask(wrapper.getDevices(currentDeviceItemMap), completedTask -> Platform.runLater(() -> completedTask.accept((ADBTaskManager.CompletedTask.CompletedTaskVisitor)new ADBTaskManager.CompletedTask.CompletedTaskVisitor<Map<ADBDeviceIdentifier, ADBDevice>>(){

                public void onTaskSuccess(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IADBTask.TaskResult<@NonNull Map<@NonNull ADBDeviceIdentifier, @Nullable ADBDevice>> result) {
                    AndroidDeviceControlController.this.refreshDevicesInProgress = false;
                    if (AndroidDeviceControlController.this.fullRefreshDevicesInProgress) {
                        return;
                    }
                    Map resultsMap = (Map)result.getResults();
                    AndroidDeviceControlController.this.deviceIdentifierToDeviceItemMap.entrySet().removeIf(entry -> !resultsMap.containsKey(entry.getKey()));
                    AndroidDeviceControlController.this.adbDeviceItems.removeIf(item -> !resultsMap.containsKey(item.getDeviceIdentifier()));
                    resultsMap.entrySet().forEach(entry -> AndroidDeviceControlController.this.addDevice(wrapper, (ADBDeviceIdentifier)entry.getKey(), (ADBDevice)entry.getValue()));
                    if (!$assertionsDisabled && AndroidDeviceControlController.this.adbDeviceItems.size() != AndroidDeviceControlController.this.deviceIdentifierToDeviceItemMap.size()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && AndroidDeviceControlController.this.adbDeviceItems.size() != resultsMap.size()) {
                        throw new AssertionError();
                    }
                    if (AndroidDeviceControlController.this.adbDeviceItems.size() == 1) {
                        AndroidDeviceControlController.this.devicesSelectionModel.selectFirst();
                    }
                }

                public void onTaskThrewInvalidADBException(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IADBTask.InvalidADBException exception) {
                    AndroidDeviceControlController.this.onADBFailure((Exception)exception);
                }

                public void onTaskThrewADBExecutionException(// Could not load outer class - annotation placement on inner may be incorrect
                @NonNull IADBTask.ADBExecutionException exception) {
                    AndroidDeviceControlController.this.onADBFailure((Exception)((Object)exception));
                }
            })));
        }
    }

    public void refreshDeviceInfo() {
        assert (Platform.isFxApplicationThread());
        this.adbDeviceItems.forEach(item -> item.refresh(false));
    }

    public boolean canConnect(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        return selectedItems.stream().anyMatch(item -> item.getConnection().canConnect());
    }

    public void connect(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems, @Nullable Consumer<@NonNull LiveTargetConnection> onConnectionSuccessCallback) {
        selectedItems.forEach(item -> item.getConnection().connect(onConnectionSuccessCallback, null));
    }

    public boolean canDisconnect(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        return selectedItems.stream().anyMatch(item -> item.getConnection().canDisconnect());
    }

    public void disconnect(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        selectedItems.forEach(item -> item.getConnection().disconnect());
    }

    public boolean canInstallRootInterceptor(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        return selectedItems.stream().anyMatch(item -> item.getRootInterceptorComponent().canBeInstalled());
    }

    public void installRootInterceptor(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        selectedItems.forEach(item -> item.getRootInterceptorComponent().doInstall());
    }

    public boolean canUninstallRootInterceptor(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        return selectedItems.stream().anyMatch(item -> item.getRootInterceptorComponent().canBeUninstalled());
    }

    public void uninstallRootInterceptor(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        selectedItems.forEach(item -> item.getRootInterceptorComponent().doUninstall());
    }

    public boolean canInstallRootVulkanLayer(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        return selectedItems.stream().anyMatch(item -> item.getRootVulkanLayerComponent().canBeInstalled());
    }

    public void installRootVulkanLayer(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        selectedItems.forEach(item -> item.getRootVulkanLayerComponent().doInstall());
    }

    public boolean canUninstallRootVulkanLayer(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        return selectedItems.stream().anyMatch(item -> item.getRootVulkanLayerComponent().canBeUninstalled());
    }

    public void uninstallRootVulkanLayer(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        selectedItems.forEach(item -> item.getRootVulkanLayerComponent().doUninstall());
    }

    public boolean canReboot(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        return selectedItems.stream().anyMatch(item -> item.canBeRebooted());
    }

    public void reboot(@NonNull List<@NonNull AndroidDeviceControlItem> selectedItems) {
        selectedItems.forEach(item -> item.reboot());
    }

    public @NonNull ReadOnlyBooleanProperty hasADBLoadedProperty() {
        return this.hasADBLoaded;
    }

    public @NonNull ReadOnlyStringProperty invalidADBReasonProperty() {
        return this.invalidADBReasonProperty;
    }

    public @NonNull ReadOnlyListProperty<@NonNull AndroidDeviceControlItem> adbDevicesProperty() {
        return this.adbDeviceItems;
    }

    public @NonNull ReadOnlyBooleanProperty blockingUpdateInProgressProperty() {
        return this.blockingUpdateInProgress;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable AndroidBridge> getAndroidBridgeProperty() {
        return (ReadOnlyObjectProperty)NullUtils.neverNull((Object)this.adbWrapper.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyObjectProperty<AndroidDeviceControlItem> getSelectedDeviceItemProperty() {
        return this.selectedDeviceItemProperty;
    }
}

