/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.ui.controllers.IClipboardCopyable;
import com.arm.mgd.ui.controllers.NavigationChangeTableViewController;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractTableViewThumbnailController<T extends IClipboardCopyable>
extends NavigationChangeTableViewController<T> {
    private final AssetTableSpec assetTableSpec;
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    protected @NonNull Map<IAssetItem, T> cachedViewItems = new HashMap<IAssetItem, T>();

    public AbstractTableViewThumbnailController(@NonNull ReadOnlyBooleanProperty enabledProperty, AssetTableSpec assetTableSpec) {
        this.assetTableSpec = assetTableSpec;
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, this.getNavigationChangedListener());
    }

    @Override
    public void dispose() {
        this.navigationChangedListener.dispose();
    }

    protected abstract @NonNull T createTableViewItem();

    protected abstract void setTableViewItem(@NonNull T var1, @NonNull IAssetItem var2);

    public abstract String getClipboardHeader();

    @Override
    protected void refreshData(@Nullable TraceStateSnapshot snapshot) {
        HashMap<IAssetItem, T> newCachedViewItems = new HashMap<IAssetItem, T>();
        LinkedHashSet<T> newItems = new LinkedHashSet<T>();
        if (snapshot != null) {
            IAssetItem[] iAssetItemArray = snapshot.getAssetTableBySpec(this.assetTableSpec).toArray();
            int n = iAssetItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAssetItem assetItem = iAssetItemArray[n2];
                T tableViewItem = this.getCachedOrNewViewItem(assetItem);
                this.putTableViewItemIntoCache(newCachedViewItems, assetItem, tableViewItem);
                newItems.add(tableViewItem);
                ++n2;
            }
        }
        this.cachedViewItems = newCachedViewItems;
        Platform.runLater(() -> this.setItems(newItems));
    }

    protected @NonNull T getCachedOrNewViewItem(@NonNull IAssetItem assetItem) {
        @Nullable T tableViewItem = this.getTableViewItemFromCache(this.cachedViewItems, assetItem);
        if (tableViewItem == null) {
            tableViewItem = this.createTableViewItem();
        }
        this.setTableViewItem(tableViewItem, assetItem);
        return tableViewItem;
    }

    private @Nullable T getTableViewItemFromCache(Map<IAssetItem, T> cache, IAssetItem assetItem) {
        return (T)((IClipboardCopyable)cache.get(assetItem));
    }

    private T putTableViewItemIntoCache(Map<IAssetItem, T> cache, IAssetItem assetItem, T item) {
        return (T)((IClipboardCopyable)cache.put(assetItem, item));
    }

    @Override
    protected void copySelected(@NonNull List<? extends @NonNull IClipboardCopyable> list) {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent clipboardContent = new ClipboardContent();
        StringBuilder stringBuilder = new StringBuilder();
        for (IClipboardCopyable iClipboardCopyable : list) {
            stringBuilder.append(iClipboardCopyable.getClipboardContent()).append("\n");
        }
        String string = stringBuilder.toString();
        if (!string.isEmpty()) {
            StringBuilder titleBuilder = new StringBuilder();
            titleBuilder.append(this.getClipboardHeader());
            titleBuilder.append("\n");
            titleBuilder.append(string);
            clipboardContent.putString(titleBuilder.toString());
            clipboard.setContent((Map)clipboardContent);
        }
    }
}

