/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.controllers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.ADBDeviceIdentifier;
import com.arm.mgd.core.adb.ADBInstalledPackage;
import com.arm.mgd.core.adb.ADBTaskManager;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IAndroidPackageTraceManager;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.ui.controllers.AndroidDeviceControlItem;
import com.arm.mgd.ui.controls.ADBPackageItem;
import com.arm.mgd.ui.handlers.ConnectTargetHandler;
import com.arm.mgd.ui.targetconn.LiveTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.ui.utils.SimpleCoreProgressMonitor;
import com.arm.mgd.utils.NullUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ADBPackageControlController {
    private final @NonNull ReadOnlyListWrapper<@NonNull ADBPackageItem> listItems;
    private final @NonNull ReadOnlyObjectProperty<AndroidDeviceControlItem> selectedDeviceItem;
    private final @NonNull ReadOnlyObjectProperty<ADBPackageItem> selectedPackageItemProperty;
    private final @NonNull ReadOnlyBooleanWrapper isSelectedPackageItemDebuggable = new ReadOnlyBooleanWrapper(false);
    private final @NonNull ReadOnlyObjectProperty<AndroidBridge> androidBridgeProperty;
    private final @NonNull BooleanProperty blockingUpdateInProgress = new SimpleBooleanProperty();
    private final @NonNull BooleanProperty onConnectionOccurredProperty = new SimpleBooleanProperty(false);
    private final @NonNull ReadOnlyBooleanProperty installGlesProperty;
    private final @NonNull ReadOnlyBooleanProperty installVulkanProperty;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ADBTaskManager.CompletedTask.CompletedTaskVisitor<@NonNull List<@NonNull ADBInstalledPackage>> taskVisitor = new ADBTaskManager.CompletedTask.CompletedTaskVisitor<List<ADBInstalledPackage>>(){

        public void onTaskSuccess(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IADBTask.TaskResult<@NonNull List<@NonNull ADBInstalledPackage>> result) {
            @Nullable ADBDevice device = result.getDevice();
            if (!$assertionsDisabled && device == null) {
                throw new AssertionError();
            }
            AndroidDeviceControlItem selectedDevice = (AndroidDeviceControlItem)ADBPackageControlController.this.selectedDeviceItem.get();
            if (selectedDevice == null) {
                ADBPackageControlController.this.listItems.clear();
                ADBPackageControlController.this.blockingUpdateInProgress.set(false);
                return;
            }
            if (device.equals((Object)selectedDevice.getDevice())) {
                ADBPackageControlController.this.updateListItems((List)result.getResults());
                ADBPackageControlController.this.blockingUpdateInProgress.set(false);
            }
        }

        public void onTaskThrewInvalidADBException(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IADBTask.InvalidADBException exception) {
            ADBPackageControlController.this.onADBException((IADBTask.ADBException)exception);
        }

        public void onTaskThrewADBExecutionException(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull IADBTask.ADBExecutionException exception) {
            ADBPackageControlController.this.onADBException((IADBTask.ADBException)exception);
        }
    };
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ADBTaskManager.PrivateTaskListener<@NonNull List<@NonNull ADBInstalledPackage>> getPackagesTaskListener = completedTask -> completedTask.accept(this.taskVisitor);

    public ADBPackageControlController(@NonNull ReadOnlyObjectProperty<AndroidDeviceControlItem> selectedDeviceItem, @NonNull ReadOnlyObjectProperty<ADBPackageItem> selectedPackageItemProperty, @NonNull ReadOnlyObjectProperty<AndroidBridge> androidBridgeProperty, @NonNull ReadOnlyBooleanProperty installGlesProperty, @NonNull ReadOnlyBooleanProperty installVulkanProperty) {
        this.listItems = new ReadOnlyListWrapper(FXCollections.observableArrayList());
        this.selectedDeviceItem = selectedDeviceItem;
        this.androidBridgeProperty = androidBridgeProperty;
        this.selectedPackageItemProperty = selectedPackageItemProperty;
        this.installGlesProperty = installGlesProperty;
        this.installVulkanProperty = installVulkanProperty;
        this.selectedDeviceItem.addListener((observable, oldSelectedDeviceItem, newSelectedDeviceItem) -> {
            ADBDeviceIdentifier oldDeviceIdentifier;
            if (newSelectedDeviceItem == null || newSelectedDeviceItem.getDevice() == null) {
                this.listItems.clear();
                return;
            }
            ADBDeviceIdentifier aDBDeviceIdentifier = oldDeviceIdentifier = oldSelectedDeviceItem != null ? oldSelectedDeviceItem.getDeviceIdentifier() : null;
            if (!newSelectedDeviceItem.getDeviceIdentifier().equals((Object)oldDeviceIdentifier)) {
                @NonNull ADBDevice newDevice = (ADBDevice)NullUtils.neverNull((Object)newSelectedDeviceItem.getDevice());
                if (newDevice.getPackages().isEmpty()) {
                    this.listPackages();
                } else {
                    this.blockingUpdateInProgress.set(true);
                    this.updateListItems(newDevice.getPackages());
                    this.blockingUpdateInProgress.set(false);
                }
            }
        });
        this.selectedPackageItemProperty.addListener((observable, oldSelectedPackageItem, newSelectedPackageItem) -> {
            boolean isDebuggable = newSelectedPackageItem != null && newSelectedPackageItem.getSelectedPackage().isDebuggable();
            this.isSelectedPackageItemDebuggable.set(isDebuggable);
        });
    }

    public void dispose() {
        assert (Platform.isFxApplicationThread());
        this.listItems.clear();
    }

    public @NonNull ReadOnlyListProperty<@NonNull ADBPackageItem> listItemsProperty() {
        return (ReadOnlyListProperty)NullUtils.neverNull((Object)this.listItems.getReadOnlyProperty());
    }

    public @NonNull ReadOnlyBooleanProperty blockingUpdateInProgressProperty() {
        return this.blockingUpdateInProgress;
    }

    public void listPackages() {
        this.blockingUpdateInProgress.set(true);
        AndroidBridge bridge = (AndroidBridge)this.androidBridgeProperty.get();
        assert (bridge != null);
        AndroidDeviceControlItem item = (AndroidDeviceControlItem)this.selectedDeviceItem.get();
        assert (item != null);
        CoreInstance.getADBTaskManager().submitPrivateTask(bridge.getInstalledPackages((ADBDevice)NullUtils.neverNull((Object)item.getDevice())), this.getPackagesTaskListener);
    }

    public void launchActivityAndConnect() {
        final AndroidBridge bridge = (AndroidBridge)this.androidBridgeProperty.get();
        assert (bridge != null);
        final ADBPackageItem packageItem = (ADBPackageItem)this.selectedPackageItemProperty.get();
        assert (packageItem != null);
        AndroidDeviceControlItem deviceItem = (AndroidDeviceControlItem)this.selectedDeviceItem.get();
        assert (deviceItem != null);
        final ADBDevice device = deviceItem.getDevice();
        assert (device != null);
        final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        final boolean installGLES = this.installGlesProperty.get();
        final boolean installVulkan = this.installVulkanProperty.get();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                block12: {
                    monitor.setTaskName("Launching trace session");
                    IAndroidPackageTraceManager traceManager = null;
                    try {
                        SimpleCoreProgressMonitor coreMonitor = new SimpleCoreProgressMonitor(monitor);
                        TargetConnectionManager.cleanupPastConnectionToADBDevice(device, coreMonitor);
                        if (installGLES && installVulkan) {
                            traceManager = bridge.getMultiAPIPackageTraceManager((ADBDevice)NullUtils.neverNull((Object)device), packageItem.getSelectedPackage(), packageItem.getSelectedActivity());
                        } else if (installGLES) {
                            traceManager = bridge.getGLESPackageTraceManager((ADBDevice)NullUtils.neverNull((Object)device), packageItem.getSelectedPackage(), packageItem.getSelectedActivity());
                        } else if (installVulkan) {
                            traceManager = bridge.getVulkanPackageTraceManager((ADBDevice)NullUtils.neverNull((Object)device), packageItem.getSelectedPackage(), packageItem.getSelectedActivity());
                        } else {
                            CoreLogging.info(null, (String)"Capture was started without any APIs selected. GA will assume that you have already packaged the interceptor library into your application.");
                            traceManager = bridge.getNoAPIPackageTraceManager((ADBDevice)NullUtils.neverNull((Object)device), packageItem.getSelectedPackage(), packageItem.getSelectedActivity());
                        }
                        IAndroidPackageTraceManager finalTraceManagerReference = (IAndroidPackageTraceManager)NullUtils.neverNull((Object)traceManager);
                        traceManager.setProgressMonitor((ICoreProgressMonitor)coreMonitor);
                        try {
                            bridge.connectToDevice((ADBDevice)NullUtils.neverNull((Object)device), (ip, port) -> ConnectTargetHandler.connectAndKillRunningDaemon(ip, port, device)).run(finalTraceManagerReference.getExecutor());
                        }
                        catch (IADBTask.ADBExecutionException ex) {
                            throw new ProtocolVersionException("An older version of the GA Daemon is already running on the device. Please kill the daemon process and try again");
                        }
                        bridge.installAPILayerToApp(finalTraceManagerReference).run(traceManager.getExecutor());
                        coreMonitor.setTask("Connecting to the device", 100);
                        bridge.connectToDevice((ADBDevice)NullUtils.neverNull((Object)device), (ip, port) -> {
                            LiveTargetConnection connection = ConnectTargetHandler.doConnectTargetSynchronous(ip, port, device, finalTraceManagerReference, bridge, window);
                            coreMonitor.incProgress(100);
                            return connection != null;
                        }).run(traceManager.getExecutor());
                        bridge.startTracedPackage(finalTraceManagerReference).run(traceManager.getExecutor());
                    }
                    catch (Exception exceptionFromInstalling) {
                        CoreLogging.severe((Throwable)exceptionFromInstalling);
                        if (traceManager == null) break block12;
                        try {
                            traceManager.close();
                        }
                        catch (IADBTask.ADBException exceptionFromCleanup) {
                            CoreLogging.severe(null, (Throwable)exceptionFromCleanup, (String)"An exception was thrown while attempting to clean up GA from the target.");
                        }
                    }
                }
                monitor.done();
            }
        };
        this.closeDeviceManagerOnConnectionStarted();
        try {
            dialog.run(true, false, runnable);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            CoreLogging.severe((Throwable)exception);
        }
    }

    private void onADBException(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IADBTask.ADBException exception) {
        CoreLogging.severe((Throwable)exception);
        this.listItems.clear();
        this.blockingUpdateInProgress.set(false);
    }

    private void updateListItems(@NonNull List<@NonNull ADBInstalledPackage> packageList) {
        this.listItems.clear();
        for (ADBInstalledPackage pack : packageList) {
            if (pack.getMainActivities().isEmpty()) {
                this.listItems.add((Object)new ADBPackageItem(pack, ""));
                continue;
            }
            this.listItems.addAll((Collection)pack.getMainActivities().stream().map(activity -> new ADBPackageItem(pack, (String)activity)).collect(Collectors.toList()));
        }
        this.listItems.sort(null);
    }

    public @NonNull ReadOnlyBooleanProperty isSelectedPackageItemDebuggableProperty() {
        return (ReadOnlyBooleanProperty)NullUtils.neverNull((Object)this.isSelectedPackageItemDebuggable.getReadOnlyProperty());
    }

    private void closeDeviceManagerOnConnectionStarted() {
        Platform.runLater(() -> this.onConnectionOccurredProperty.set(!this.onConnectionOccurredProperty.get()));
    }

    public @NonNull Observable onConnectionOccuredObservable() {
        return this.onConnectionOccurredProperty;
    }
}

