/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui;

import com.arm.mgd.core.util.ListenerList;
import com.arm.mgd.ui.UIUpdateTimerListener;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jdt.annotation.NonNull;

public class UIUpdateTimer {
    private final Timer timer;
    private final ListenerList<UIUpdateTimerListener> listeners = new ListenerList();

    public UIUpdateTimer(String label, long refreshPeriodMillis) {
        this.timer = new Timer(label, true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                for (UIUpdateTimerListener listener : UIUpdateTimer.this.listeners) {
                    listener.onTick();
                }
            }
        }, 0L, refreshPeriodMillis);
    }

    public void addListener(@NonNull UIUpdateTimerListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(@NonNull UIUpdateTimerListener listener) {
        this.listeners.remove((Object)listener);
    }
}

