/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui;

import com.arm.mgd.ui.dialogs.CopyableMessageDialog;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.swt.widgets.Display;

public class UIHandler
extends Handler {
    @Override
    public void publish(LogRecord record) {
        if (record.getLevel() == Level.SEVERE) {
            UIHandler.errorMessage("Error", record.getMessage());
        } else if (record.getLevel() == Level.WARNING) {
            UIHandler.warningMessage("Warning", record.getMessage());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    private static void uiMessage(final String title, final int messageImage, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                new CopyableMessageDialog(title, messageImage, msg).open();
            }
        });
    }

    public static void errorMessage(String title, String message) {
        UIHandler.uiMessage(title, 1, message);
    }

    public static void warningMessage(String title, String message) {
        UIHandler.uiMessage(title, 4, message);
    }
}

