/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui;

import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.Dimension;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class SWTImageDataUtils {
    private static final PaletteData RGB32_PALETTE = new PaletteData(-16777216, 0xFF0000, 65280);
    private static final int ALPHA32_BYTE_POSITION = 3;

    public static ImageData getImageDataFromImageProvider(@NonNull IByteDataProvider dataProvider, Dimension size, boolean useAlpha, boolean flipY) {
        if (size.getArea() == 0) {
            return null;
        }
        byte[] data = dataProvider.cloneData();
        ImageData swtImageData = null;
        assert (size.getArea() * 4 == dataProvider.getLength());
        swtImageData = new ImageData(size.getWidth(), size.getHeight(), 32, RGB32_PALETTE);
        swtImageData.data = data;
        swtImageData.bytesPerLine = size.getWidth() * 4;
        if (useAlpha) {
            swtImageData.alphaData = new byte[data.length / 4];
            int alphaIndex = 0;
            int imageIndex = 3;
            while (alphaIndex < swtImageData.alphaData.length) {
                swtImageData.alphaData[alphaIndex] = swtImageData.data[imageIndex];
                ++alphaIndex;
                imageIndex += 4;
            }
        }
        if (flipY) {
            swtImageData = swtImageData.scaledTo(swtImageData.width, -swtImageData.height);
        }
        return swtImageData;
    }

    public static byte[] extractByteInformation(ImageData imageToExtract) {
        PaletteData imagePallet = imageToExtract.palette;
        int[] pixelData = new int[imageToExtract.width * imageToExtract.height];
        imageToExtract.getPixels(0, 0, imageToExtract.width * imageToExtract.height, pixelData, 0);
        ByteBuffer pixelByteBuffer = ByteBuffer.allocate(imageToExtract.width * imageToExtract.height * 3);
        int i = 0;
        while (i < imageToExtract.width * imageToExtract.height) {
            RGB rgb = imagePallet.getRGB(pixelData[i]);
            pixelByteBuffer.put((byte)rgb.red).put((byte)rgb.green).put((byte)rgb.blue);
            ++i;
        }
        return pixelByteBuffer.array();
    }
}

