/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui;

import com.arm.mali.mgd.editors.SourceEditor;
import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.ClProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureImageAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.SourceAsset;
import com.arm.mgd.core.asset.SourceProvider;
import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.texture.GlTextureCompositor;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.asset.texture.RGBAImageWriter;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.ui.UIHandler;
import com.arm.mgd.ui.editorinput.IModelConnectedEditor;
import com.arm.mgd.ui.editorinput.SourceEditorInput;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditorInputManager {
    private static Map<TraceDataModel, Map<IAssetItem, IEditorInput>> editorInputMap = new HashMap<TraceDataModel, Map<IAssetItem, IEditorInput>>();
    private static final @NonNull AtomicLong EXTERNAL_IMAGE_COUNT = new AtomicLong(0L);

    static {
        CoreInstance.getNavigationManager().addTargetRemovedListener(targetRemoved -> {
            Map<TraceDataModel, Map<IAssetItem, IEditorInput>> map = editorInputMap;
            synchronized (map) {
                targetRemoved.getModels().forEach(model -> {
                    Map<IAssetItem, IEditorInput> map = editorInputMap.remove(model);
                });
            }
        });
    }

    public static void updateModelNameForOpenEditors(TraceDataModel model) {
        IWorkbenchWindow[] windows;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] editors;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = window.getActivePage();
            IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
            int n3 = editors.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference iEditorReference = iEditorReferenceArray[n4];
                IEditorPart editor = iEditorReference.getEditor(false);
                if (editor instanceof IModelConnectedEditor) {
                    IModelConnectedEditor updateableEditor = (IModelConnectedEditor)editor;
                    updateableEditor.refreshModelName(model);
                }
                ++n4;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void openSourceEditor(SourceAsset sourceAsset) {
        IEditorInput ei;
        TraceDataModel model = sourceAsset.getCreatedByFunction().getModel();
        Map<TraceDataModel, Map<IAssetItem, IEditorInput>> map = editorInputMap;
        synchronized (map) {
            IEditorInput input;
            Map<IAssetItem, IEditorInput> assetMap = editorInputMap.get(sourceAsset);
            if (assetMap == null) {
                assetMap = new HashMap<IAssetItem, IEditorInput>();
            }
            if ((input = assetMap.get(sourceAsset)) == null) {
                SourceProvider esp;
                if (sourceAsset instanceof GlShaderAsset) {
                    esp = new SourceProvider((GlShaderAsset)sourceAsset);
                } else if (sourceAsset instanceof ClProgramAsset) {
                    esp = new SourceProvider((ClProgramAsset)sourceAsset);
                } else {
                    CoreLogging.severe(null, (String)"Source Editor tried to open unknown source asset.");
                    return;
                }
                input = new SourceEditorInput(esp, model);
                assetMap.put((IAssetItem)sourceAsset, input);
            }
            ei = input;
        }
        Display.getDefault().asyncExec(() -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(ei, SourceEditor.getID());
            }
            catch (PartInitException e) {
                CoreLogging.severe(null, (String)("Shader could not be opened: " + e.getMessage()));
            }
        });
    }

    public static void openEditor(@NonNull GlTextureAsset glTextureAsset) {
        GlTextureImageAsset mipImage = glTextureAsset.getTextureMipmapImage();
        GlTextureCompositor imageProvider = mipImage != null ? mipImage.getGlTextureCompositor() : null;
        EditorInputManager.openImageWithExternalEditor((IImageProvider)imageProvider);
    }

    public static void openEditor(VkImageAsset item) {
        EditorInputManager.openImageWithExternalEditor((IImageProvider)item);
    }

    public static void openEditor(SourceAsset sourceAsset) {
        String source = sourceAsset.getSource();
        if (source != null && !source.isEmpty()) {
            EditorInputManager.openSourceEditor(sourceAsset);
        }
    }

    private static void openImageWithExternalEditor(final @Nullable IImageProvider imageProvider) {
        if (imageProvider == null) {
            return;
        }
        Job job = new Job("Loading Image"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean pngOutputSuccess;
                File png;
                block9: {
                    png = null;
                    pngOutputSuccess = false;
                    try {
                        try {
                            RGBAImageData data = imageProvider.getImageData();
                            png = FileUtils.createTempFile((String)("ExternalImage_" + EXTERNAL_IMAGE_COUNT.incrementAndGet()), (String)".png");
                            RGBAImageWriter.writeAsPng((RGBAImageData)data, (File)png);
                            pngOutputSuccess = true;
                        }
                        catch (Throwable t) {
                            UIHandler.errorMessage("Problem Opening Image: ", t.getMessage());
                            if (!pngOutputSuccess && png != null) {
                                png.delete();
                            }
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        if (!pngOutputSuccess && png != null) {
                            png.delete();
                        }
                        throw throwable;
                    }
                    if (!pngOutputSuccess && png != null) {
                        png.delete();
                    }
                }
                if (pngOutputSuccess) {
                    File finalPng = png;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> EditorInputManager.openExternalEditor(finalPng));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void openExternalEditor(File fileToBeOpened) {
        try {
            Program.launch((String)fileToBeOpened.getAbsolutePath());
        }
        catch (UnsupportedOperationException e) {
            UIHandler.errorMessage("Could not open file " + fileToBeOpened, "Host system cannot open file of this type.");
        }
    }
}

