/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyToClipboard
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        if (selectionProvider.getSelection() == null || selectionProvider.getSelection().isEmpty()) {
            return null;
        }
        String stringToCopy = null;
        if (selectionProvider instanceof TableViewer) {
            stringToCopy = CopyToClipboard.tableToTabSeperatedString(((TableViewer)selectionProvider).getTable());
        }
        if (stringToCopy != null && stringToCopy.length() > 0) {
            TextTransfer textTransfer = TextTransfer.getInstance();
            Clipboard cb = new Clipboard(Display.getDefault());
            cb.setContents(new Object[]{stringToCopy}, new Transfer[]{textTransfer});
        }
        return null;
    }

    private static String tableToTabSeperatedString(Table table) {
        StringBuilder sb = new StringBuilder();
        String lineSeperator = System.getProperty("line.separator");
        int selectedItemIndex = 0;
        while (selectedItemIndex < table.getSelectionCount()) {
            int columnIndex = 0;
            while (columnIndex < table.getColumnCount()) {
                if (CopyToClipboard.isTableViewerColumnVisible(table.getColumn(columnIndex))) {
                    String tableText = table.getSelection()[selectedItemIndex].getText(columnIndex);
                    sb.append(tableText);
                    sb.append("\t");
                }
                ++columnIndex;
            }
            sb.append(lineSeperator);
            ++selectedItemIndex;
        }
        return sb.toString();
    }

    private static boolean isTableViewerColumnVisible(TableColumn tableColumn) {
        return tableColumn.getResizable() || tableColumn.getWidth() > 0;
    }
}

