/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.LoggerListener;
import com.arm.mgd.core.util.ReadOnlySubList;
import com.arm.mgd.core.util.executors.NamedSingleThreadExecutor;
import com.arm.mgd.ui.UIUpdateTimer;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;

public class ConsoleLogHandler
extends Handler
implements LoggerListener {
    private final @NonNull UIUpdateTimer updateTimer = new UIUpdateTimer("Console Log Update Tick", 100L);
    private final @NonNull NamedSingleThreadExecutor consoleLogThread = new NamedSingleThreadExecutor("Console Log Thread", true);
    private final @NonNull ArrayList<@NonNull LogRecord> logRecords = new ArrayList();
    private final @NonNull Map<ConsoleLogEntryListener, CurrentLogEntry> logListeners = new WeakHashMap<ConsoleLogEntryListener, CurrentLogEntry>();
    private volatile boolean isInvokingListeners = false;

    public ConsoleLogHandler() {
        Logger.getLogger("global").addHandler(this);
        CoreLogging.addLoggerListener((LoggerListener)this);
        this.updateTimer.addListener(() -> {
            if (!this.isInvokingListeners) {
                this.isInvokingListeners = true;
                this.consoleLogThread.runLater(() -> {
                    try {
                        int currentLogSize = this.logRecords.size();
                        this.logListeners.forEach((listener, currentLogEntry) -> {
                            if (currentLogEntry.currentEntry < currentLogSize) {
                                listener.onLogEntriesAdded((List<LogRecord>)new ReadOnlySubList(this.logRecords, currentLogEntry.currentEntry, currentLogSize));
                                currentLogEntry.currentEntry = currentLogSize;
                            }
                        });
                    }
                    finally {
                        this.isInvokingListeners = false;
                    }
                });
            }
        });
    }

    public void addWeakListener(@NonNull ConsoleLogEntryListener listener) {
        this.consoleLogThread.runLater(() -> this.logListeners.put(listener, new CurrentLogEntry()));
    }

    public void removeWeakListener(@NonNull ConsoleLogEntryListener listener) {
        this.consoleLogThread.runLater(() -> this.logListeners.remove(listener));
    }

    @Override
    public void publish(LogRecord record) {
        assert (record != null);
        this.consoleLogThread.runLater(() -> this.logRecords.add((LogRecord)NullUtils.neverNull((Object)record)));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public void onLoggerAdded(Logger logger) {
        logger.addHandler(this);
    }

    public static interface ConsoleLogEntryListener {
        public void onLogEntriesAdded(@NonNull List<@NonNull LogRecord> var1);
    }

    private static class CurrentLogEntry {
        int currentEntry = 0;

        private CurrentLogEntry() {
        }
    }
}

