/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.EditorAreaFileDropAdapter;
import com.arm.mgd.ui.TraceEditorPartListener;
import com.arm.mgd.ui.UIHandler;
import com.arm.mgd.ui.controls.IFXPartVisibilityListener;
import com.arm.mgd.ui.targetconn.RemoteControl;
import com.arm.mgd.utils.VersionProperties;
import java.io.IOException;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private Logger uiLogger;
    private static final @NonNull IPartListener2 VISIBILITY_PART_LISTENER = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
            this.setVisibilityOfFXViewPart(partRef, true);
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            this.setVisibilityOfFXViewPart(partRef, false);
        }

        private void setVisibilityOfFXViewPart(IWorkbenchPartReference partRef, boolean visible) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof IFXPartVisibilityListener) {
                ((IFXPartVisibilityListener)part).setVisible(visible);
            }
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            this.setVisibilityOfFXViewPart(partRef, true);
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }
    };

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public void postWindowCreate() {
        try {
            IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
            preferences.put("help_view_open_mode", "in browser");
            preferences.putBoolean("always_external_browser", true);
            preferences.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        int w = PlatformUI.getPreferenceStore().getInt("width");
        int h = PlatformUI.getPreferenceStore().getInt("height");
        if (w != 0 && h != 0) {
            configurer.setInitialSize(new Point(w, h));
        }
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShowPerspectiveBar(true);
        configurer.addEditorAreaTransfer((Transfer)FileTransfer.getInstance());
        configurer.configureEditorAreaDropListener((DropTargetListener)new EditorAreaFileDropAdapter(configurer.getWindow()));
        configurer.getWindow().addPageListener(new IPageListener(){

            public void pageOpened(IWorkbenchPage page) {
                page.addPartListener(VISIBILITY_PART_LISTENER);
            }

            public void pageClosed(IWorkbenchPage page) {
                page.removePartListener(VISIBILITY_PART_LISTENER);
            }

            public void pageActivated(IWorkbenchPage page) {
            }
        });
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        int x = PlatformUI.getPreferenceStore().getInt("posx");
        int y = PlatformUI.getPreferenceStore().getInt("posy");
        if (x != 0 && y != 0) {
            window.getShell().setLocation(x, y);
        }
        window.getPartService().addPartListener((IPartListener)new TraceEditorPartListener());
        window.getShell().setMinimumSize(300, 200);
        try {
            RemoteControl.start(window);
        }
        catch (IOException e) {
            CoreLogging.info(null, (String)("Unable to initialise remote control. This usually just means you have another instance of " + VersionProperties.FULL_PRODUCT_NAME + " running. " + "You will not be able to use remote connection features with this instance of " + VersionProperties.SHORT_PRODUCT_NAME + " (for example, Streamline / " + VersionProperties.SHORT_PRODUCT_NAME + " mode)."));
        }
        this.uiLogger = Logger.getLogger("com.arm.mgd.core.util.corelogging.usermessagelogger");
        this.uiLogger.addHandler(new UIHandler());
        LogManager.getLogManager().addLogger(this.uiLogger);
    }

    public boolean preWindowShellClose() {
        try {
            RemoteControl.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Shell shell = this.getWindowConfigurer().getWindow().getShell();
        int x = shell.getLocation().x;
        int y = shell.getLocation().y;
        int w = shell.getSize().x;
        int h = shell.getSize().y;
        PlatformUI.getPreferenceStore().setValue("posx", x);
        PlatformUI.getPreferenceStore().setValue("posy", y);
        PlatformUI.getPreferenceStore().setValue("width", w);
        PlatformUI.getPreferenceStore().setValue("height", h);
        return super.preWindowShellClose();
    }
}

