/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.authorisation.AlwaysAllowAuthorisationProvider;
import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.authorisation.Feature;
import com.arm.mgd.core.authorisation.IArmAuthorisationProvider;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.navigation.INavigationChangedListener;
import com.arm.mgd.core.util.ApplicationOptions;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.ui.ApplicationWorkbenchWindowAdvisor;
import com.arm.mgd.ui.handlers.OpenTraceFileHandler;
import com.arm.mgd.ui.perspectives.PerspectiveSwitcher;
import com.arm.mgd.ui.preferences.PreferenceConstant;
import com.arm.mgd.ui.views.DiffReportView;
import com.arm.mgd.ui.views.ICloseOnStartupView;
import com.arm.mgd.utils.VersionProperties;
import java.io.File;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.commands.ICommandService;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final Set<String> PREFERENCE_PANELS_TO_KEEP = Set.of("org.eclipse.ui.preferencePages.Workbench", "org.eclipse.help.ui.browsersPreferencePage");
    private final @NonNull PerspectiveSwitcher perspectiveSwitcher = new PerspectiveSwitcher();
    private @Nullable IWorkbenchWindowConfigurer cachedConfigurer = null;
    private final @NonNull Consumer<@NonNull Set<Feature>> authListChangedListener = authList -> Display.getDefault().asyncExec(() -> {
        if (this.cachedConfigurer != null) {
            this.cachedConfigurer.setTitle(ApplicationWorkbenchAdvisor.getWindowTitleText());
        }
    });
    private @Nullable Runnable coreInitialisationPostStartupAction = null;

    private static @NonNull String getWindowTitleText() {
        StringBuilder titleText = new StringBuilder(VersionProperties.FULL_PRODUCT_NAME);
        return titleText.toString();
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        this.cachedConfigurer = configurer;
        configurer.setTitle(ApplicationWorkbenchAdvisor.getWindowTitleText());
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return PerspectiveSwitcher.DEFAULT_PERSPECTIVE.getId();
    }

    public String getMainPreferencePageId() {
        return "com.arm.mgd.ui.preferences.GeneralPreferencesPage";
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        javafx.application.Platform.setImplicitExit((boolean)false);
        String runtimeVersion = (String)Platform.getBundle((String)"com.arm.mgd.ui").getHeaders().get("Bundle-Version");
        String previouslyOpenVersionKey = String.valueOf(VersionProperties.SHORT_PRODUCT_NAME) + "-Previously-Open-Version";
        String lastVersion = PlatformUI.getPreferenceStore().getString(previouslyOpenVersionKey);
        if (!runtimeVersion.equals(lastVersion)) {
            PlatformUI.getPreferenceStore().setValue(previouslyOpenVersionKey, runtimeVersion);
            configurer.setSaveAndRestore(false);
        } else {
            configurer.setSaveAndRestore(true);
        }
        new Thread("Loading API specification..."){

            @Override
            public void run() {
                KapiSpec.getAvailableKapiSpecs();
            }
        }.start();
        this.loadCore();
    }

    private void loadCore() {
        AlwaysAllowAuthorisationProvider authorisationProvider = new AlwaysAllowAuthorisationProvider();
        CoreInstance.setAuthorisationProvider((IArmAuthorisationProvider)authorisationProvider);
    }

    public void postStartup() {
        super.postStartup();
        this.getWorkbenchConfigurer().setSaveAndRestore(true);
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        this.removeUnwantedPreferenceNodes(pm);
        ApplicationWorkbenchAdvisor.closeViewsFlaggedToCloseOnStartup();
        CoreInstance.getNavigationManager().addNavigationChangedListener((INavigationChangedListener)this.perspectiveSwitcher);
        ApplicationFeatureAuthoriser.registerAnyAuthorisationConsumer(this.authListChangedListener);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                OpenTraceFileHandler.openFiles(window, ApplicationOptions.getDefault().getInputFiles());
            }
        });
        Menu systemMenu = Display.getDefault().getSystemMenu();
        if (systemMenu != null) {
            MenuItem[] menuItemArray = systemMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                if (item.getID() == -2) {
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                            Command command = commandService.getCommand("org.eclipse.ui.window.preferences");
                            try {
                                command.executeWithChecks(new ExecutionEvent());
                            }
                            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e1) {
                                CoreLogging.severe((Throwable)e1);
                            }
                        }
                    });
                }
                if (item.getID() == -1) {
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                            Command command = commandService.getCommand("org.eclipse.ui.help.aboutAction");
                            try {
                                command.executeWithChecks(new ExecutionEvent());
                            }
                            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e1) {
                                CoreLogging.severe((Throwable)e1);
                            }
                        }
                    });
                }
                ++n2;
            }
        }
        final IPreferenceStore preferenceStore = PreferenceConstant.getPreferenceStore();
        try {
            ApplicationWorkbenchAdvisor.setTempDirectoryIfValid(preferenceStore.getString(PreferenceConstant.TEMPORARY_STORAGE_DIRECTORY.getPreferenceName()));
        }
        catch (Exception e) {
            CoreLogging.userMessage(null, (Level)Level.WARNING, (String)("Invalid temporary directory: " + e.getLocalizedMessage() + ". Reverting to system default."));
            String defaultTemporaryDirectory = preferenceStore.getDefaultString(PreferenceConstant.TEMPORARY_STORAGE_DIRECTORY.getPreferenceName());
            preferenceStore.setValue(PreferenceConstant.TEMPORARY_STORAGE_DIRECTORY.getPreferenceName(), defaultTemporaryDirectory);
        }
        preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getProperty() == PreferenceConstant.TEMPORARY_STORAGE_DIRECTORY.getPreferenceName()) {
                    try {
                        ApplicationWorkbenchAdvisor.setTempDirectoryIfValid(preferenceStore.getString(PreferenceConstant.TEMPORARY_STORAGE_DIRECTORY.getPreferenceName()));
                    }
                    catch (Exception e) {
                        CoreLogging.userMessage(null, (Level)Level.WARNING, (String)("Invalid new temporary directory: " + e.getLocalizedMessage() + ". Using existing value instead."));
                    }
                }
            }
        });
        if (this.coreInitialisationPostStartupAction != null) {
            Display.getDefault().asyncExec(this.coreInitialisationPostStartupAction);
        }
    }

    private static void closeAllViewsMatchingPredicate(@NonNull Predicate<@Nullable IWorkbenchPart> predicate) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IViewReference[] iViewReferenceArray = page.getViewReferences();
                int n5 = iViewReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IViewReference viewRef = iViewReferenceArray[n6];
                    IWorkbenchPart viewPart = viewRef.getPart(false);
                    if (predicate.test(viewPart)) {
                        page.hideView(viewRef);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void closeAllDiffReportViews() {
        ApplicationWorkbenchAdvisor.closeAllViewsMatchingPredicate(viewPart -> viewPart instanceof DiffReportView);
    }

    private static void closeViewsFlaggedToCloseOnStartup() {
        ApplicationWorkbenchAdvisor.closeAllViewsMatchingPredicate(viewPart -> viewPart instanceof ICloseOnStartupView);
    }

    public boolean preShutdown() {
        ApplicationWorkbenchAdvisor.closeAllDiffReportViews();
        CoreInstance.getNavigationManager().removeNavigationChangedListener((INavigationChangedListener)this.perspectiveSwitcher);
        return super.preShutdown();
    }

    private static boolean isUnwantedPreferenceNode(IPreferenceNode preferenceNode) {
        String id = preferenceNode.getId();
        return !PREFERENCE_PANELS_TO_KEEP.contains(id) && !id.startsWith("com.arm");
    }

    private void removeUnwantedPreferenceNodes(IPreferenceNode parentNode) {
        IPreferenceNode[] iPreferenceNodeArray = parentNode.getSubNodes();
        int n = iPreferenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode preferenceNode = iPreferenceNodeArray[n2];
            if (ApplicationWorkbenchAdvisor.isUnwantedPreferenceNode(preferenceNode)) {
                parentNode.remove(preferenceNode);
            } else {
                this.removeUnwantedPreferenceNodes(preferenceNode);
            }
            ++n2;
        }
    }

    private void removeUnwantedPreferenceNodes(PreferenceManager pm) {
        IPreferenceNode[] iPreferenceNodeArray = pm.getRootSubNodes();
        int n = iPreferenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode preferenceNode = iPreferenceNodeArray[n2];
            if (ApplicationWorkbenchAdvisor.isUnwantedPreferenceNode(preferenceNode)) {
                pm.remove(preferenceNode);
            } else {
                this.removeUnwantedPreferenceNodes(preferenceNode);
            }
            ++n2;
        }
    }

    private static void setTempDirectoryIfValid(String newTempDirPath) throws Exception {
        if (newTempDirPath.isEmpty()) {
            FileUtils.setTemporaryDirectoryRoot(null);
            return;
        }
        File tempFile = new File(newTempDirPath);
        if (!tempFile.isDirectory()) {
            throw new Exception("Specified path is not a directory");
        }
        if (!(tempFile.canWrite() && tempFile.canRead() && tempFile.canExecute())) {
            throw new Exception("Directory must have read, write and execute permissions");
        }
        FileUtils.setTemporaryDirectoryRoot((String)newTempDirPath);
    }
}

