/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui;

import com.arm.mgd.core.util.ApplicationOptions;
import com.arm.mgd.headless.cli.CommandLineOutcome;
import com.arm.mgd.headless.cli.MGDCommandLineMain;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.ApplicationWorkbenchAdvisor;
import com.arm.mgd.ui.SplashScreenFixer;
import com.arm.mgd.ui.preferences.PreferenceConstant;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class Application
implements IApplication {
    private static boolean emptyHeadlessArguments = false;

    private static @NonNull List<String> getHeadlessCommandLineArgsFromEclipseEnvironment() {
        String[] eclipseCommandLineArgs = Platform.getApplicationArgs();
        if (eclipseCommandLineArgs == null) {
            System.err.println("Warning: unable to get command line arguments from the Eclipse environment.");
            return new ArrayList<String>();
        }
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(eclipseCommandLineArgs));
        if (!argList.remove("--headless") && !argList.remove("-h")) {
            if (!argList.isEmpty()) {
                System.out.println(String.valueOf(VersionProperties.FULL_PRODUCT_NAME) + " detected command line arguments. " + "If you want to launch headless mode, make sure to include the --headless flag. " + "The GUI will now be launched.");
            }
            return new ArrayList<String>();
        }
        if (argList.isEmpty()) {
            emptyHeadlessArguments = true;
        }
        return argList;
    }

    private static @Nullable Path getADBLocationFromConfig() {
        @NonNull String adbLocation = (String)NullUtils.neverNull((Object)PreferenceConstant.getPreferenceStore().getString(PreferenceConstant.LOCATION_OF_ADB.getPreferenceName()).strip());
        return adbLocation.isEmpty() ? null : Path.of(adbLocation, new String[0]);
    }

    public Object start(IApplicationContext context) {
        List<String> headlessCommandLineArgs = Application.getHeadlessCommandLineArgsFromEclipseEnvironment();
        if (emptyHeadlessArguments || headlessCommandLineArgs.size() > 0) {
            context.applicationRunning();
            CommandLineOutcome outcome = MGDCommandLineMain.runCommandLine((String[])headlessCommandLineArgs.toArray(new String[headlessCommandLineArgs.size()]), (Path)Application.getADBLocationFromConfig());
            if (outcome.getOutcomeCategory() != CommandLineOutcome.OutcomeCategory.SUCCESS) {
                System.setProperty("eclipse.exitdata", "");
                Activator.setCoreWasLoaded(outcome.getOutcomeCategory().wasCoreLoaded);
                outcome.logErrorMessageFromException();
            }
            return outcome.getOutcomeCategory().exitCode;
        }
        Display display = PlatformUI.createDisplay();
        ApplicationOptions.getDefault().parseCommandLine(Platform.getCommandLineArgs());
        SplashScreenFixer.fixSplashScreen();
        try {
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

