/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.DirectoryUserFileStore;
import com.arm.mgd.core.util.IMemoryListener;
import com.arm.mgd.core.util.IUserFileStore;
import com.arm.mgd.core.util.MemoryMonitor;
import com.arm.mgd.ui.ConsoleLogHandler;
import com.arm.mgd.ui.UIUpdateTimer;
import com.arm.mgd.ui.editorinput.TargetEditorInput;
import com.arm.mgd.ui.views.TraceEditor;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.io.File;
import java.net.URL;
import java.util.Optional;
import java.util.logging.Level;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IMemoryListener {
    public static final String PLUGIN_ID = "com.arm.mgd.ui";
    private static Activator plugin;
    private TraceEditor activeTraceEditor;
    private ConsoleLogHandler defaultConsole;
    private final @NonNull IUserFileStore userFileStore = new DirectoryUserFileStore((File)NullUtils.neverNull((Object)ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toFile()));
    private static boolean coreWasLoaded;
    public static final UIUpdateTimer uiUpdateTimer;

    static {
        coreWasLoaded = true;
        uiUpdateTimer = new UIUpdateTimer(String.valueOf(VersionProperties.SHORT_PRODUCT_NAME) + " UI Update Timer", 1000L);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.defaultConsole = new ConsoleLogHandler();
        MemoryMonitor.getInstance().addListener((IMemoryListener)this);
    }

    public void saveConnectionSettings() {
        this.saveDialogSettings();
    }

    public static void setCoreWasLoaded(boolean coreWasLoaded) {
        Activator.coreWasLoaded = coreWasLoaded;
    }

    public void stop(BundleContext context) throws Exception {
        Job job = new Job("Shutting down"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setRule(TargetEditorInput.EDITOR_CLOSE_SCHEDULING_RULE);
        job.schedule();
        job.join();
        MemoryMonitor.getInstance().stopMonitoring();
        this.defaultConsole.close();
        plugin = null;
        if (coreWasLoaded) {
            CoreInstance.shutdown();
        }
        System.gc();
        System.runFinalization();
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        Optional imgDesc = ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)path);
        if (imgDesc.isEmpty()) {
            CoreLogging.warning(null, (String)("Could not find image: " + path));
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return (ImageDescriptor)imgDesc.get();
    }

    public void setActiveTraceEditor(TraceEditor traceEditor) {
        this.activeTraceEditor = traceEditor;
    }

    public TraceEditor getActiveTraceEditor() {
        return this.activeTraceEditor;
    }

    public static void openBrowser(final URL url, final String id) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                        IWebBrowser browser = browserSupport.createBrowser(6, id, id, "Documentation for " + id);
                        browser.openURL(url);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        });
    }

    public void onMemoryBelowWarningLevel(int remainingMemory) {
        Display.getDefault().asyncExec(() -> CoreLogging.userMessageReportOnce(null, (Level)Level.WARNING, (String)((String)NullUtils.neverNull((Object)MemoryMonitor.CRITICAL_MEMORY_USER_MESSAGE))));
    }

    public void onMemoryBelowCriticalLevel(int remainingMemory) {
        Display.getDefault().asyncExec(() -> CoreLogging.userMessageReportOnce(null, (Level)Level.WARNING, (String)((String)NullUtils.neverNull((Object)MemoryMonitor.CRITICAL_MEMORY_USER_MESSAGE))));
    }

    public ConsoleLogHandler getDefaultConsole() {
        return this.defaultConsole;
    }

    public @NonNull IUserFileStore getUserFileStore() {
        return this.userFileStore;
    }
}

