/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mali.mgd.editors;

import com.arm.mali.mgd.editors.ColorManager;
import com.arm.mali.mgd.editors.EditorConfiguration;
import com.arm.mali.mgd.editors.EditorDocumentProvider;
import com.arm.mgd.core.asset.SourceProvider;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.Images;
import com.arm.mgd.ui.editorinput.IModelConnectedEditor;
import com.arm.mgd.ui.editorinput.SourceEditorInput;
import com.arm.mgd.ui.views.ICloseOnStartupView;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class SourceEditor
extends TextEditor
implements IModelConnectedEditor,
ICloseOnStartupView {
    private final ColorManager colorManager = new ColorManager();
    protected SourceEditorInput sourceEditorInput;

    public SourceEditor() {
        this.setSourceViewerConfiguration(new EditorConfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new EditorDocumentProvider());
    }

    public static String getID() {
        return "com.arm.mali.mgd.editors.essl.ESSLEditor";
    }

    public SourceEditor(EditorDocumentProvider documentProvider) {
        this.setSourceViewerConfiguration(new EditorConfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)documentProvider);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getSourceViewer().getTextWidget().setMenu(null);
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        super.doSetInput(newInput);
        if (newInput instanceof SourceEditorInput) {
            this.sourceEditorInput = (SourceEditorInput)newInput;
            SourceProvider srcProvider = this.sourceEditorInput.getSourceItem();
            switch (srcProvider.getSourceType()) {
                case CL: {
                    this.setTitleImage(Images.KERNEL_COMPUTE);
                    break;
                }
                case COMPUTE: {
                    this.setTitleImage(Images.SHADER_COMPUTE);
                    break;
                }
                case FRAGMENT: {
                    this.setTitleImage(Images.SHADER_FRAGMENT);
                    break;
                }
                case VERTEX: {
                    this.setTitleImage(Images.SHADER_VERTEX);
                    break;
                }
                case GEOMETRY: {
                    this.setTitleImage(Images.SHADER_GEOMETRY);
                    break;
                }
                case TESS_CONTROL: {
                    this.setTitleImage(Images.SHADER_TESS_CONTROL);
                    break;
                }
                case TESS_EVALUATION: {
                    this.setTitleImage(Images.SHADER_TESS_EVALUATION);
                    break;
                }
                default: {
                    this.setTitleImage(null);
                }
            }
            SourceEditor.annotateSource();
        }
    }

    protected static void annotateSource() {
    }

    private static void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    private static void removeActionFromMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    @Override
    public void refreshModelName(TraceDataModel model) {
        if (this.sourceEditorInput.isConnectedToModel(model)) {
            this.firePropertyChange(257);
            this.firePropertyChange(1);
        }
    }
}

