/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mali.mgd.editors;

import com.arm.mali.mgd.editors.ShaderOverrideDocumentProvider;
import com.arm.mali.mgd.editors.SourceEditor;
import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.offlinecompiler.GlShaderCompiler;
import com.arm.mgd.core.offlinecompiler.GlShaderCompilerError;
import com.arm.mgd.core.offlinecompiler.GlShaderStats;
import com.arm.mgd.core.util.CoreLogging;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ShaderOverrideEditor
extends SourceEditor {
    public ShaderOverrideEditor() {
        super(new ShaderOverrideDocumentProvider());
    }

    public static String getID() {
        return "com.arm.mali.mgd.editors.essl.ShaderOverrideEditor";
    }

    public String getCurrentEditorText() {
        return this.getSourceViewer().getTextWidget().getText();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        GlShaderStats theStats;
        GlShaderCompiler shaderCompiler = CoreInstance.getGlShaderCompiler();
        switch (this.sourceEditorInput.getSourceItem().getSourceType()) {
            case FRAGMENT: {
                theStats = (GlShaderStats)shaderCompiler.compile(this.getCurrentEditorText(), KapiSpec.GLES.constants.GL_FRAGMENT_SHADER).join();
                break;
            }
            case VERTEX: {
                theStats = (GlShaderStats)shaderCompiler.compile(this.getCurrentEditorText(), KapiSpec.GLES.constants.GL_VERTEX_SHADER).join();
                break;
            }
            default: {
                CoreLogging.severeNoAssert(null, (String)"The compilation of this shader type is unsupported");
                return;
            }
        }
        List generatedErrors = theStats.getErrorMessages();
        if (generatedErrors.isEmpty()) {
            CoreLogging.info(null, (String)"Compilation successful");
            IDocumentProvider p = this.getDocumentProvider();
            if (p == null) {
                return;
            }
            this.updateState(this.getEditorInput());
            this.validateState(this.getEditorInput());
            this.performSave(false, progressMonitor);
        } else {
            for (GlShaderCompilerError error : generatedErrors) {
                CoreLogging.info(null, (String)error.getErrorText());
            }
            CoreLogging.severeNoAssert(null, (String)"Save aborted as compilation was unsuccessful. Please consult console for more information.");
        }
    }
}

