/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mali.mgd.editors;

import com.arm.mali.mgd.editors.ColorManager;
import com.arm.mali.mgd.editors.EditorColorConstants;
import com.arm.mali.mgd.editors.EditorWhitespaceDetector;
import com.arm.mali.mgd.editors.EditorWordDetector;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class EditorScanner
extends RuleBasedScanner {
    private static final String[] builtinWords = new String[]{"gl_Position", "gl_PointSize", "gl_FragCoord", "gl_FrontFacing", "gl_FragColor", "gl_FragData", "gl_PointCoord"};
    private static final String[] builtinFuncWords = new String[]{"radians", "degrees", "sin", "cos", "tan", "asin", "acos", "atan", "pow", "exp", "log", "exp2", "log2", "sqrt", "inversesqrt", "abs", "sign", "floor", "ceil", "fract", "mod", "min", "max", "clamp", "mix", "step", "smoothstep", "length", "distance", "dot", "cross", "normalize", "faceforward", "reflect", "refract", "matrixCompMult", "lessThan", "lessThanEqual", "greaterThan", "greaterThanEqual", "equal", "notEqual", "any", "all", "not", "texture2D", "texture2DProj", "texture2DLod", "texture2DProjLod", "textureCube", "textureCubeLod"};
    private static final String[] storeWords = new String[]{"const", "attribute", "uniform", "varying", "invariant", "in", "out", "inout", "highp", "mediump", "lowp"};
    private static final String[] langWords = new String[]{"break", "continue", "do", "for", "while", "if", "else", "discard", "return"};
    private static final String[] typeWords = new String[]{"void", "bool", "int", "float", "vec2", "vec3", "vec4", "bvec2", "bvec3", "bvec4", "ivec2", "ivec3", "ivec4", "mat2", "mat3", "mat4", "sampler2D", "samplerCube", "struct"};
    private static final String[] preprocessorWords = new String[]{"#define", "#undef", "#if", "#ifdef", "#ifndef", "#else", "#elif", "#endif", "#error", "#pragma", "#extension", "#version", "#line"};

    public EditorScanner(ColorManager manager) {
        Token type = new Token((Object)new TextAttribute(manager.getColor(EditorColorConstants.ESSL_TYPE), null, 1));
        Token store = new Token((Object)new TextAttribute(manager.getColor(EditorColorConstants.ESSL_STORE_QUALIFIER)));
        Token string = new Token((Object)new TextAttribute(manager.getColor(EditorColorConstants.STRING)));
        Token builtin = new Token((Object)new TextAttribute(manager.getColor(EditorColorConstants.ESSL_BUILTIN)));
        Token builtinFunc = new Token((Object)new TextAttribute(manager.getColor(EditorColorConstants.ESSL_BUILTINFUNC), null, 1));
        Token lang = new Token((Object)new TextAttribute(manager.getColor(EditorColorConstants.ESSL_LANG)));
        Token preprocessor = new Token((Object)new TextAttribute(manager.getColor(EditorColorConstants.ESSL_PREPROCESSOR)));
        Token defaulttoken = new Token((Object)new TextAttribute(manager.getColor(EditorColorConstants.DEFAULT)));
        IRule[] rules = new IRule[9];
        rules[0] = new SingleLineRule("\"", "\"", (IToken)string, '\\');
        rules[1] = new SingleLineRule("'", "'", (IToken)string, '\\');
        rules[2] = new WordRule((IWordDetector)new EditorWordDetector());
        String[] stringArray = builtinWords;
        int n = builtinWords.length;
        int n2 = 0;
        while (n2 < n) {
            String builtinWord = stringArray[n2];
            ((WordRule)rules[2]).addWord(builtinWord, (IToken)builtin);
            ++n2;
        }
        rules[3] = new WordRule((IWordDetector)new EditorWordDetector());
        stringArray = builtinFuncWords;
        n = builtinFuncWords.length;
        n2 = 0;
        while (n2 < n) {
            String builtinFuncWord = stringArray[n2];
            ((WordRule)rules[3]).addWord(builtinFuncWord, (IToken)builtinFunc);
            ++n2;
        }
        rules[4] = new WordRule((IWordDetector)new EditorWordDetector());
        stringArray = typeWords;
        n = typeWords.length;
        n2 = 0;
        while (n2 < n) {
            String typeWord = stringArray[n2];
            ((WordRule)rules[4]).addWord(typeWord, (IToken)type);
            ++n2;
        }
        rules[5] = new WordRule((IWordDetector)new EditorWordDetector());
        stringArray = langWords;
        n = langWords.length;
        n2 = 0;
        while (n2 < n) {
            String langWord = stringArray[n2];
            ((WordRule)rules[5]).addWord(langWord, (IToken)lang);
            ++n2;
        }
        rules[6] = new WordRule((IWordDetector)new EditorWordDetector());
        stringArray = preprocessorWords;
        n = preprocessorWords.length;
        n2 = 0;
        while (n2 < n) {
            String preprocessorWord = stringArray[n2];
            ((WordRule)rules[6]).addWord(preprocessorWord, (IToken)preprocessor);
            ++n2;
        }
        rules[7] = new WordRule((IWordDetector)new EditorWordDetector(), (IToken)defaulttoken);
        stringArray = storeWords;
        n = storeWords.length;
        n2 = 0;
        while (n2 < n) {
            String storeWord = stringArray[n2];
            ((WordRule)rules[7]).addWord(storeWord, (IToken)store);
            ++n2;
        }
        rules[8] = new WhitespaceRule((IWhitespaceDetector)new EditorWhitespaceDetector());
        this.setRules(rules);
    }
}

