/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mali.mgd.editors;

import com.arm.mali.mgd.editors.EditorPartitionScanner;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.editorinput.SourceEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class EditorDocumentProvider
extends AbstractDocumentProvider {
    private AnnotationModel annotationModel;

    protected IDocument createDocument(Object element) throws CoreException {
        if (!(element instanceof SourceEditorInput)) {
            CoreLogging.severe(null, (String)("Failed to create a shader editor with element=" + element));
            return null;
        }
        SourceEditorInput sei = (SourceEditorInput)element;
        Document document = new Document(sei.getSourceItem().getSource());
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new EditorPartitionScanner(), new String[]{"__essl_preamble", "__essl_comment"});
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.createAnnotationModel(element);
        this.annotationModel.connect((IDocument)document);
        return document;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        this.annotationModel = new AnnotationModel();
        return this.annotationModel;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof SourceEditorInput) {
            SourceEditorInput sei = (SourceEditorInput)element;
            sei.getSourceItem().setSource(document.get());
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }
}

