/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.vm;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.ui.part.GatordRunningErrorDialogMessages;
import com.arm.streamline.ui.part.LandingPageMessages;
import com.arm.streamline.ui.vm.IAndroidDeviceModel;
import com.arm.streamline.ui.vm.IAndroidPackage;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import com.arm.streamline.ui.vm.IAndroidTargetLauncher;
import com.arm.streamline.ui.vm.ILandingPageActionHandler;
import com.arm.streamline.ui.vm.ILandingPageAdbPathPreferenceModel;
import com.arm.streamline.ui.vm.ILandingPageAndroidSubViewViewModel;
import com.arm.streamline.ui.vm.IPackageDetector;
import com.arm.utils.NullChecking;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.animation.PauseTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.services.IDisposable;

public class LandingPageAndroidSubViewViewModel
implements ILandingPageAndroidSubViewViewModel {
    private final @NonNull ILandingPageActionHandler actionsHandler;
    private final @NonNull ObjectBinding<@Nullable IAndroidTargetLauncher> activeTargetLauncher;
    private final @NonNull SimpleObjectProperty<@Nullable IAndroidDeviceModel.ADBPathChangeOutcome> adbPathChangeOutcome;
    private final @NonNull ILandingPageAdbPathPreferenceModel adbPathModel;
    private final @NonNull ReadOnlyStringWrapper adbPathStatus;
    private final @NonNull IDisposable adbToolPathChangeListener;
    private final @NonNull IAndroidDeviceModel androidDeviceModel;
    private final @NonNull SimpleStringProperty applicationFilterText;
    private final @NonNull AtomicReference<@Nullable PackageScanState> currentScanState;
    private final @NonNull ObservableList<@NonNull IAndroidTargetDevice> detectedDevices;
    private final @NonNull ObservableList<@NonNull IAndroidPackage> detectedPackages;
    private final @NonNull SimpleBooleanProperty packagesDetectionDone;
    private final @NonNull SimpleBooleanProperty deviceScanActiveProperty;
    private final @NonNull IDisposable deviceSelectionChange;
    private final @NonNull SimpleBooleanProperty disableRefreshDevicesProperty;
    private final @NonNull SimpleBooleanProperty disableRefreshPackagesProperty;
    private final @NonNull FilteredList<@NonNull IAndroidPackage> filteredPackagesProperty;
    private final @NonNull SimpleStringProperty noPackagesPlaceholderText;
    private final @NonNull ObservableMap<@NonNull IAndroidTargetDevice, @NonNull PackageScanState> packageScanStates;
    private final @NonNull SimpleFloatProperty progressProperty;
    private final @NonNull Consumer<@NonNull Runnable> runOnUIThread;
    private final @NonNull SimpleObjectProperty<@Nullable IAndroidTargetDevice> selectedDevice;
    private final @NonNull SimpleObjectProperty<@Nullable IAndroidPackage> selectedPackage;
    private final @NonNull SimpleBooleanProperty showDebuggablePackagesProperty;
    private final @NonNull SimpleBooleanProperty showProgressProperty;
    private final @NonNull SimpleBooleanProperty showResetAdbLink;
    private final @NonNull SortedList<@NonNull IAndroidPackage> sortedDetectedPackages;
    private @Nullable Consumer<@NonNull IAndroidTargetDevice> switchToTcp;
    private final  @NonNull LandingPageSceneViewModel.IAndroidTargetLauncherFactory targetLauncherFactory;
    private final @NonNull SimpleBooleanProperty uiElementsDisableProperty;
    private final @NonNull SimpleBooleanProperty overrideActivityProperty;
    private final @NonNull SimpleStringProperty overrideActivityNameProperty;
    private final @NonNull SimpleStringProperty applicationArgumentsProperty;
    private final @NonNull ObservableList<@NonNull String> applicationArgumentsHistoryProperty;
    private final @NonNull FilteredList<@NonNull String> filteredApplicationArgumentsHistoryProperty;
    private static final int MAX_HISTORY_ARGUMENTS = 10;

    public static void replaceDevicesList(@NonNull ObservableList<@NonNull IAndroidTargetDevice> observableList, @NonNull List<@NonNull IAndroidTargetDevice> newListContents) {
        LandingPageAndroidSubViewViewModel.replaceObservableList(observableList, newListContents, (od, nd) -> od.acceptChangesFrom((IAndroidTargetDevice)nd));
    }

    public static void replacePackagesList(@NonNull ObservableList<@NonNull IAndroidPackage> observableList, @NonNull List<@NonNull IAndroidPackage> newListContents) {
        LandingPageAndroidSubViewViewModel.replaceObservableList(observableList, newListContents, (op, np) -> {});
    }

    private static void changeSelection(@NonNull Consumer<@NonNull Runnable> runOnUIThread, @NonNull SimpleObjectProperty<@Nullable IAndroidTargetDevice> property, @Nullable IAndroidTargetDevice value) {
        runOnUIThread.accept(() -> property.set((Object)value));
    }

    private static int compareByStatus(IAndroidPackage package1, IAndroidPackage package2) {
        if (package1.getStatus() != IAndroidPackage.Status.DEBUGGABLE && package2.getStatus() == IAndroidPackage.Status.DEBUGGABLE) {
            return 1;
        }
        if (package1.getStatus() == IAndroidPackage.Status.DEBUGGABLE && package2.getStatus() != IAndroidPackage.Status.DEBUGGABLE) {
            return -1;
        }
        return 0;
    }

    private static int comparePackages(@NonNull IAndroidPackage package1, @NonNull IAndroidPackage package2) {
        int compareByStatus = LandingPageAndroidSubViewViewModel.compareByStatus(package1, package2);
        if (compareByStatus != 0) {
            return compareByStatus;
        }
        int pkgNameCmpResult = package1.getPackageName().compareTo(package2.getPackageName());
        if (pkgNameCmpResult != 0) {
            return pkgNameCmpResult;
        }
        int activityNameCmpResult = package1.getActivityName().compareTo(package2.getActivityName());
        if (activityNameCmpResult != 0) {
            return activityNameCmpResult;
        }
        return 0;
    }

    private static boolean isDebuggablePackage(@NonNull IAndroidPackage value) {
        return value.getStatus().equals((Object)IAndroidPackage.Status.DEBUGGABLE);
    }

    private static boolean isDeviceScanDisabled(boolean scanActive, @Nullable IAndroidDeviceModel.ADBPathChangeOutcome adbPathChangeOutcome) {
        return scanActive || adbPathChangeOutcome != IAndroidDeviceModel.ADBPathChangeOutcome.SUCCESS;
    }

    private static @NonNull Predicate<@NonNull IAndroidPackage> makeFilterRegex(@Nullable String pattern) {
        if (pattern == null || pattern.isBlank()) {
            return i -> true;
        }
        try {
            Pattern regex = Pattern.compile(pattern, 2);
            Predicate<String> predicate = regex.asPredicate();
            return i -> predicate.test(i.getPackageName()) || predicate.test(i.getActivityName());
        }
        catch (Throwable e) {
            return i -> false;
        }
    }

    private static <T> void replaceObservableList(@NonNull ObservableList<@NonNull T> observableList, @NonNull List<@NonNull T> newListContents, @NonNull BiConsumer<@NonNull T, @NonNull T> updater) {
        newListContents.stream().forEach(newValue -> {
            Optional<Object> foundMatchingOld = observableList.stream().filter(d -> d.equals(newValue)).findAny();
            if (foundMatchingOld.isPresent()) {
                Object oldValue = foundMatchingOld.get();
                updater.accept(oldValue, newValue);
            }
        });
        newListContents.stream().forEach(newValue -> {
            if (!observableList.contains(newValue)) {
                observableList.add(newValue);
            }
        });
        observableList.removeIf(oldValue -> !newListContents.contains(oldValue));
    }

    private static void updateSelectedPackage(@NonNull List<@NonNull IAndroidPackage> packageList, @NonNull ObjectProperty<@Nullable IAndroidPackage> selectedPackage, @Nullable IAndroidPackage currentSelection) {
        if (packageList.size() == 1 && packageList.get(0).getStatus() == IAndroidPackage.Status.DEBUGGABLE) {
            selectedPackage.set((Object)packageList.get(0));
        } else if (currentSelection != null) {
            if (packageList.contains(currentSelection)) {
                selectedPackage.set((Object)currentSelection);
            } else {
                selectedPackage.set(null);
            }
        }
    }

    public LandingPageAndroidSubViewViewModel(@NonNull ILandingPageActionHandler actionsHandler,  @NonNull LandingPageSceneViewModel.IAndroidTargetLauncherFactory targetLauncherFactory, @NonNull ILandingPageAdbPathPreferenceModel adbPathModel, @NonNull Consumer<@NonNull IAndroidTargetDevice> switchToTcp, @NonNull Consumer<@NonNull Runnable> runOnUIThread, @NonNull IAndroidDeviceModel androidDeviceModel) {
        this(actionsHandler, targetLauncherFactory, adbPathModel, runOnUIThread, androidDeviceModel);
        this.setSwitchToTcpCallback(switchToTcp);
    }

    /*
     * Exception decompiling
     */
    public LandingPageAndroidSubViewViewModel(@NonNull ILandingPageActionHandler actionsHandler,  @NonNull LandingPageSceneViewModel.IAndroidTargetLauncherFactory targetLauncherFactory, @NonNull ILandingPageAdbPathPreferenceModel adbPathModel, @NonNull Consumer<@NonNull Runnable> runOnUIThread, @NonNull IAndroidDeviceModel androidDeviceModel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public @NonNull ObservableObjectValue<@Nullable IAndroidTargetLauncher> activeTargetLauncherProperty() {
        return this.activeTargetLauncher;
    }

    @Override
    public @NonNull ReadOnlyStringProperty adbPathStatusProperty() {
        return this.adbPathStatus.getReadOnlyProperty();
    }

    @Override
    public @NonNull ObservableObjectValue<@Nullable File> adbToolPathProperty() {
        return this.adbPathModel.adbToolPathProperty();
    }

    @Override
    public @NonNull SimpleStringProperty applicationFilterTextProperty() {
        return this.applicationFilterText;
    }

    @Override
    public @NonNull ObservableList<@NonNull IAndroidTargetDevice> detectedDevicesProperty() {
        return this.detectedDevices;
    }

    @Override
    public @NonNull ObservableList<@NonNull IAndroidPackage> detectedPackagesProperty() {
        return this.detectedPackages;
    }

    @Override
    public @NonNull ReadOnlyBooleanProperty deviceScanActive() {
        return this.deviceScanActiveProperty;
    }

    @Override
    public @NonNull ReadOnlyBooleanProperty disableRefreshDevicesProperty() {
        return this.disableRefreshDevicesProperty;
    }

    @Override
    public @NonNull ReadOnlyBooleanProperty disableRefreshPackagesProperty() {
        return this.disableRefreshPackagesProperty;
    }

    @Override
    public void doRefreshPackages() {
        this.packageScanStateRefreshState((IAndroidTargetDevice)this.selectedDevice.get(), true, this.showDebuggablePackagesProperty.get());
    }

    @Override
    public void doScanForDevices() {
        this.deviceScanActiveProperty.set(true);
        this.disableRefreshDevicesProperty.set(true);
    }

    @Override
    public void doShowAdbPathConfigurationPreference() {
        this.adbPathModel.doShowAdbPathConfigurationPreference();
    }

    @Override
    public void resetAdbPathToDefault() {
        this.adbPathModel.resetAdbPathToDefault();
    }

    @Override
    public void doShowAndroidTargetHelp() {
        this.actionsHandler.showAndroidTargetHelp();
    }

    @Override
    public @NonNull FilteredList<@NonNull IAndroidPackage> filteredPackagesProperty() {
        return this.filteredPackagesProperty;
    }

    @Override
    public boolean handleGatordRunningStates() {
        IAndroidTargetDevice device = (IAndroidTargetDevice)this.selectedDevice.get();
        if (device != null) {
            switch (device.getStatus()) {
                case AVAILABLE: {
                    return true;
                }
                case UNAVAILABLE_GATORD_RUNNING: {
                    return this.handleGatordRunningState(device, GatordRunningErrorDialogMessages.HEADER_GATOR_UNAVAILABLE, GatordRunningErrorDialogMessages.BODY_GATOR_UNAVAILABLE, false, false);
                }
                case AVAILABLE_GATORD_RUNNING_PACKAGE: {
                    return this.handleGatordRunningWithPackage(device);
                }
                case AVAILABLE_BUT_OUTDATED_CONFIGURATION_XML: {
                    return true;
                }
                case UNAVAILABLE_INVALID_VERSION_KILLABLE: {
                    return this.handleGatordRunningState(device, GatordRunningErrorDialogMessages.HEADER_GATOR_INVALID_VERSION, GatordRunningErrorDialogMessages.BODY_GATOR_INVALID_VERSION_KILLABLE, false, false);
                }
                case UNAVAILABLE_INVALID_VERSION_UNKILLABLE: {
                    return this.handleGatordRunningState(device, GatordRunningErrorDialogMessages.HEADER_GATOR_INVALID_VERSION, GatordRunningErrorDialogMessages.BODY_GATOR_INVALID_VERSION_UNKILLABLE, false, true);
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public @NonNull ObservableBooleanValue hasValidAdbToolPathSetProperty() {
        return this.adbPathModel.hasValidAdbToolPathSetProperty();
    }

    @Override
    public @NonNull ReadOnlyStringProperty noPackagesPlaceholderTextProperty() {
        return this.noPackagesPlaceholderText;
    }

    @Override
    public @NonNull SimpleFloatProperty progressProperty() {
        return this.progressProperty;
    }

    @Override
    public @NonNull SimpleObjectProperty<@Nullable IAndroidTargetDevice> selectedDeviceProperty() {
        return this.selectedDevice;
    }

    @Override
    public @NonNull SimpleObjectProperty<@Nullable IAndroidPackage> selectedPackageProperty() {
        return this.selectedPackage;
    }

    @Override
    public void setSwitchToTcpCallback(@NonNull Consumer<@NonNull IAndroidTargetDevice> switchToTcp) {
        this.switchToTcp = switchToTcp;
    }

    @Override
    public SimpleBooleanProperty showDebuggablePackagesProperty() {
        return this.showDebuggablePackagesProperty;
    }

    @Override
    public @NonNull SimpleBooleanProperty showProgressProperty() {
        return this.showProgressProperty;
    }

    @Override
    public @NonNull SortedList<@NonNull IAndroidPackage> sortedDetectedPackageProperty() {
        return this.sortedDetectedPackages;
    }

    @Override
    public @NonNull SimpleBooleanProperty uiElementDisableProperty() {
        return this.uiElementsDisableProperty;
    }

    @Override
    public @NonNull SimpleBooleanProperty overrideActivityProperty() {
        return this.overrideActivityProperty;
    }

    @Override
    public @NonNull SimpleStringProperty overrideActivityNameProperty() {
        return this.overrideActivityNameProperty;
    }

    @Override
    public @NonNull SimpleStringProperty applicationArgumentsProperty() {
        return this.applicationArgumentsProperty;
    }

    @Override
    public @NonNull SimpleBooleanProperty showResetAdbLink() {
        return this.showResetAdbLink;
    }

    @Override
    public @NonNull ObservableList<@NonNull String> applicationArgumentsHistoryProperty() {
        return this.applicationArgumentsHistoryProperty;
    }

    @Override
    public @NonNull FilteredList<@NonNull String> filteredApplicationArgumentsHistoryProperty() {
        return this.filteredApplicationArgumentsHistoryProperty;
    }

    @Override
    public void storeArguments() {
        String currentArguments = this.applicationArgumentsProperty().get();
        if (currentArguments != null) {
            if (currentArguments.trim().length() != 0) {
                ObservableList list = FXCollections.observableArrayList(this.applicationArgumentsHistoryProperty());
                list.remove((Object)currentArguments);
                list.add(0, (Object)currentArguments);
                if (list.size() > 10) {
                    list.remove(10, list.size());
                }
                this.storeArgumentsHistory((List<String>)list);
            } else {
                this.applicationArgumentsProperty().set("");
            }
        }
    }

    private void storeArgumentsHistory(@NonNull List<@NonNull String> history) {
        this.actionsHandler.setApplicationArgumentsHistory(history);
    }

    private void loadArgumentsHistory() {
        this.applicationArgumentsHistoryProperty().clear();
        this.applicationArgumentsHistoryProperty().addAll(this.actionsHandler.getApplicationArgumentsHistory());
    }

    private @Nullable IAndroidTargetLauncher calculateActiveTargetLauncher() {
        IAndroidTargetDevice targetDevice = (IAndroidTargetDevice)this.selectedDevice.get();
        IAndroidPackage pkg = (IAndroidPackage)this.selectedPackage.getValue();
        if (targetDevice != null && pkg != null && targetDevice.getStatus().canListPackages() && (LandingPageAndroidSubViewViewModel.isDebuggablePackage(pkg) || targetDevice.canProfileNonDebuggableApps())) {
            return this.targetLauncherFactory.create(targetDevice.getTargetAddress(), pkg, true, targetDevice.getDeviceRootMode());
        }
        return null;
    }

    private @NonNull Predicate<IAndroidPackage> filterDebuggablePackages() {
        Predicate<IAndroidPackage> regexPredicate = LandingPageAndroidSubViewViewModel.makeFilterRegex(this.applicationFilterText.get());
        if (this.showDebuggablePackagesProperty.get()) {
            return detectedPkg -> detectedPkg != null && detectedPkg.getStatus() == IAndroidPackage.Status.DEBUGGABLE && regexPredicate.test((IAndroidPackage)detectedPkg);
        }
        return detectedPkg -> detectedPkg != null && regexPredicate.test((IAndroidPackage)detectedPkg);
    }

    private boolean handleGatordRunningState(@NonNull IAndroidTargetDevice device, @NonNull String messageHeader, @NonNull String messageBody, boolean hideUseButton, boolean hideStopButton) {
        @Nullable ILandingPageAndroidSubViewViewModel.ErrorDialogResult result = this.actionsHandler.showGatorRunningErrorDialog(device, messageHeader, messageBody, hideUseButton, hideStopButton);
        if (result != null) {
            switch (result) {
                case CANCEL: {
                    return false;
                }
                case STOP: {
                    return this.androidDeviceModel.doKillGatordOnDevice(device);
                }
                case USE: {
                    if (this.switchToTcp != null) {
                        this.switchToTcp.accept(device);
                    }
                    return false;
                }
            }
            assert (false) : "Not Supported";
        }
        return false;
    }

    private boolean handleGatordRunningWithPackage(@NonNull IAndroidTargetDevice device) {
        boolean hideUseButton;
        String dialogBody;
        assert (device.getRunAsInfo().isPresent());
        boolean isPackageInstalled = this.androidDeviceModel.isPackageInstalled(device.getSerialNumber(), device.getRunAsInfo().get());
        @NonNull String dialogHeader = MessageFormat.format(GatordRunningErrorDialogMessages.HEADER_GATOR_RUNNING_WITH_PACKAGE, device.getRunAsInfo().get().getWaitProcessCommand());
        if (isPackageInstalled) {
            dialogBody = GatordRunningErrorDialogMessages.BODY_GATOR_UNAVAILABLE;
            hideUseButton = false;
        } else {
            dialogBody = GatordRunningErrorDialogMessages.BODY_GATOR_RUNNING_WITH_PACKAGE_REMOVED;
            hideUseButton = true;
        }
        return this.handleGatordRunningState(device, dialogHeader, dialogBody, hideUseButton, false);
    }

    private void packageScanStateChangeDeviceSelection(@Nullable IAndroidTargetDevice newSelection, boolean fromDeviceUpdate) {
        this.runOnUIThread.accept(() -> {
            if (newSelection == null) {
                PackageScanState state = this.currentScanState.getAndSet(null);
                if (state != null) {
                    state.clearBindings(this.disableRefreshPackagesProperty, this.showProgressProperty, this.progressProperty, this.detectedPackages, this.packagesDetectionDone, this.selectedPackage);
                }
                this.androidDeviceModel.cancelPackageListing();
            } else {
                PackageScanState prevState;
                PackageScanState state = (PackageScanState)this.packageScanStates.computeIfAbsent((Object)newSelection, k -> new PackageScanState(this.runOnUIThread));
                if (state != (prevState = this.currentScanState.getAndSet(state))) {
                    if (prevState != null) {
                        prevState.clearBindings(this.disableRefreshPackagesProperty, this.showProgressProperty, this.progressProperty, this.detectedPackages, this.packagesDetectionDone, this.selectedPackage);
                    }
                    state.bind(this.disableRefreshPackagesProperty, this.showProgressProperty, this.progressProperty, this.detectedPackages, this.packagesDetectionDone, this.selectedPackage);
                }
                if (newSelection.getStatus().canListPackages()) {
                    state.performRefresh(this.androidDeviceModel, newSelection, false, this.showDebuggablePackagesProperty.get(), fromDeviceUpdate);
                } else {
                    state.clearPackagesAsUnsupported();
                }
            }
        });
    }

    private void packageScanStateClearDeviceAsUnsupported(@NonNull IAndroidTargetDevice device) {
        PackageScanState state = (PackageScanState)this.packageScanStates.get((Object)device);
        if (state != null) {
            this.runOnUIThread.accept(() -> state.clearPackagesAsUnsupported());
        }
    }

    private void packageScanStateRefreshState(@Nullable IAndroidTargetDevice device, boolean forceRefresh, boolean debuggableOnly) {
        if (device == null) {
            return;
        }
        this.runOnUIThread.accept(() -> {
            PackageScanState state = (PackageScanState)this.packageScanStates.computeIfAbsent((Object)device, k -> new PackageScanState(this.runOnUIThread));
            if (device.getStatus().canListPackages()) {
                state.performRefresh(this.androidDeviceModel, device, forceRefresh, debuggableOnly, false);
            } else {
                state.clearPackagesAsUnsupported();
            }
        });
    }

    private void packageScanStateRemoveDevice(@NonNull IAndroidTargetDevice device) {
        this.packageScanStates.remove((Object)device);
    }

    private /* synthetic */ void lambda$11(IAndroidTargetDevice oldSelection, IAndroidTargetDevice newSelection) {
        this.applicationFilterText.set("");
        if (oldSelection == null && newSelection == null) {
            return;
        }
        if (oldSelection != null && newSelection != null && oldSelection.equals(newSelection)) {
            return;
        }
        this.packageScanStateChangeDeviceSelection(newSelection, false);
    }

    private /* synthetic */ void lambda$12(ObservableValue v, Boolean o, Boolean n) {
        this.packageScanStateRefreshState((IAndroidTargetDevice)this.selectedDevice.get(), false, n);
    }

    private /* synthetic */ void lambda$14(ILandingPageActionHandler iLandingPageActionHandler, IAndroidDeviceModel iAndroidDeviceModel, Consumer consumer, ObservableValue e, IAndroidDeviceModel.ADBPathChangeOutcome o, IAndroidDeviceModel.ADBPathChangeOutcome n) {
        this.showResetAdbLink.set(false);
        if (n == null) {
            assert (false);
            this.adbPathStatus.set(LandingPageMessages.ADB_FAILED_NO_PATH);
        } else {
            switch (n) {
                case FAILURE: {
                    if (iLandingPageActionHandler.isDefaultAdbValid()) {
                        this.adbPathStatus.set(LandingPageMessages.ADB_FAILED_BUT_EXIST_IN_PATH);
                        this.showResetAdbLink.set(true);
                        break;
                    }
                    this.adbPathStatus.set(LandingPageMessages.ADB_FAILED_INVALID_EXE);
                    break;
                }
                case NULL_PATH: {
                    this.adbPathStatus.set(LandingPageMessages.ADB_FAILED_NO_PATH);
                    break;
                }
                case SUCCESS: {
                    this.adbPathStatus.set(LandingPageMessages.ADB_SUCCESS);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        iAndroidDeviceModel.requestDevices(newDevicesList -> {
            IAndroidTargetDevice newSelection;
            LandingPageAndroidSubViewViewModel.replaceDevicesList(this.detectedDevices, newDevicesList);
            IAndroidTargetDevice currentSelection = (IAndroidTargetDevice)this.selectedDevice.get();
            IAndroidTargetDevice iAndroidTargetDevice = newSelection = currentSelection != null ? (IAndroidTargetDevice)this.detectedDevices.stream().filter(p -> p.equals(currentSelection)).findFirst().orElse(null) : null;
            if (!NullChecking.equalsNullable((Object)currentSelection, newSelection)) {
                LandingPageAndroidSubViewViewModel.changeSelection(consumer, this.selectedDevice, newSelection);
            }
        });
    }

    private /* synthetic */ void lambda$17(IAndroidDeviceModel iAndroidDeviceModel, File p) {
        this.adbPathChangeOutcome.set((Object)iAndroidDeviceModel.handleADBPathChange(p));
    }

    private static /* synthetic */ boolean lambda$18(IAndroidPackage p) {
        return true;
    }

    private /* synthetic */ String lambda$21() throws Exception {
        if (this.selectedDevice.get() == null) {
            return LandingPageMessages.NO_DEVICE_SELECTED;
        }
        if (this.packagesDetectionDone.get() && this.filteredPackagesProperty.size() == 0) {
            this.showProgressProperty.set(false);
            if (!this.applicationFilterText.getValue().isEmpty()) {
                return LandingPageMessages.NO_PACKAGES_DETECTED_WITH_FILTER;
            }
            if (this.showDebuggablePackagesProperty.get()) {
                return LandingPageMessages.NO_DEBUGGABLE_PACKAGES_DETECTED;
            }
        }
        this.showProgressProperty.set(true);
        return LandingPageMessages.NO_PACKAGES_DETECTED;
    }

    private /* synthetic */ void lambda$22(ActionEvent e) {
        this.deviceScanActiveProperty.set(true);
    }

    private /* synthetic */ void lambda$23(Consumer consumer, PauseTransition pauseTransition, ObservableValue e, Boolean o, Boolean n) {
        boolean disableButton = LandingPageAndroidSubViewViewModel.isDeviceScanDisabled(n, (IAndroidDeviceModel.ADBPathChangeOutcome)((Object)this.adbPathChangeOutcome.get()));
        consumer.accept(() -> {
            if (!disableButton) {
                pauseTransition.stop();
                this.disableRefreshDevicesProperty.set(false);
                this.deviceScanActiveProperty.set(false);
            } else {
                pauseTransition.playFromStart();
            }
        });
    }

    private /* synthetic */ void lambda$25(IAndroidDeviceModel iAndroidDeviceModel, Consumer consumer, ObservableValue e, IAndroidDeviceModel.ADBPathChangeOutcome o, IAndroidDeviceModel.ADBPathChangeOutcome n) {
        boolean disableButton = LandingPageAndroidSubViewViewModel.isDeviceScanDisabled(iAndroidDeviceModel.scanActiveProperty().get(), n);
        consumer.accept(() -> this.disableRefreshDevicesProperty.set(disableButton));
    }

    private /* synthetic */ void lambda$27(IAndroidDeviceModel iAndroidDeviceModel, ObservableValue v, Exception o, Exception n) {
        if (n != null) {
            CommonPlugin.error((Throwable)n);
            iAndroidDeviceModel.handleADBPathChange(null);
            LandingPageAndroidSubViewViewModel.replaceDevicesList(this.detectedDevices, Collections.emptyList());
            this.adbPathChangeOutcome.set((Object)IAndroidDeviceModel.ADBPathChangeOutcome.FAILURE);
        }
    }

    private /* synthetic */ void lambda$28() {
        this.loadArgumentsHistory();
    }

    private /* synthetic */ void lambda$29(ObservableValue v, IAndroidPackage o, IAndroidPackage n) {
        this.filteredApplicationArgumentsHistoryProperty.setPredicate(s -> true);
        this.overrideActivityProperty.set(false);
        this.applicationArgumentsProperty.set("");
    }

    private static final class PackageScanState {
        private final @NonNull ObservableList<@NonNull IAndroidPackage> detectedPackages = FXCollections.observableArrayList();
        private final @NonNull SimpleBooleanProperty packagesDetectionDone = new SimpleBooleanProperty(false);
        private final @NonNull SimpleBooleanProperty disableRefreshPackagesProperty = new SimpleBooleanProperty(false);
        private final @NonNull AtomicBoolean onlyDebuggable = new AtomicBoolean(true);
        private final @NonNull AtomicBoolean pendingRefresh = new AtomicBoolean(false);
        private final @NonNull SimpleFloatProperty progressProperty = new SimpleFloatProperty(-1.0f);
        private final @NonNull Consumer<@NonNull Runnable> runOnUIThread;
        private final @NonNull SimpleObjectProperty<@Nullable IAndroidPackage> selectedPackage = new SimpleObjectProperty();
        private final @NonNull SimpleBooleanProperty showProgressProperty = new SimpleBooleanProperty(false);

        public PackageScanState(@NonNull Consumer<@NonNull Runnable> runOnUIThread) {
            this.runOnUIThread = runOnUIThread;
        }

        public void bind(@NonNull SimpleBooleanProperty disableRefreshPackagesProperty, @NonNull SimpleBooleanProperty showProgressProperty, @NonNull SimpleFloatProperty progressProperty, @NonNull ObservableList<@NonNull IAndroidPackage> detectedPackages, @NonNull SimpleBooleanProperty packagesDetectionDone, @NonNull SimpleObjectProperty<@Nullable IAndroidPackage> selectedPackage) {
            IAndroidPackage currentSelection = (IAndroidPackage)this.selectedPackage.get();
            disableRefreshPackagesProperty.bindBidirectional((Property)this.disableRefreshPackagesProperty);
            showProgressProperty.bindBidirectional((Property)this.showProgressProperty);
            progressProperty.bindBidirectional((Property)this.progressProperty);
            selectedPackage.bindBidirectional(this.selectedPackage);
            Bindings.bindContent(detectedPackages, this.detectedPackages);
            packagesDetectionDone.bindBidirectional((Property)this.packagesDetectionDone);
            LandingPageAndroidSubViewViewModel.updateSelectedPackage(this.detectedPackages, this.selectedPackage, currentSelection);
        }

        public void clearBindings(@NonNull SimpleBooleanProperty disableRefreshPackagesProperty, @NonNull SimpleBooleanProperty showProgressProperty, @NonNull SimpleFloatProperty progressProperty, @NonNull ObservableList<@NonNull IAndroidPackage> detectedPackages, @NonNull SimpleBooleanProperty packagesDetectionDone, @NonNull SimpleObjectProperty<@Nullable IAndroidPackage> selectedPackage) {
            IAndroidPackage currentSelection = (IAndroidPackage)this.selectedPackage.get();
            disableRefreshPackagesProperty.unbindBidirectional((Property)this.disableRefreshPackagesProperty);
            showProgressProperty.unbindBidirectional((Property)this.showProgressProperty);
            progressProperty.unbindBidirectional((Property)this.progressProperty);
            selectedPackage.unbindBidirectional(this.selectedPackage);
            Bindings.unbindContent(detectedPackages, this.detectedPackages);
            packagesDetectionDone.unbindBidirectional((Property)this.packagesDetectionDone);
            showProgressProperty.set(false);
            disableRefreshPackagesProperty.set(true);
            progressProperty.set(0.0f);
            detectedPackages.clear();
            selectedPackage.set(null);
            LandingPageAndroidSubViewViewModel.updateSelectedPackage(this.detectedPackages, this.selectedPackage, currentSelection);
        }

        public void clearPackagesAsUnsupported() {
            this.showProgressProperty.set(false);
            this.disableRefreshPackagesProperty.set(true);
            this.progressProperty.set(0.0f);
            this.detectedPackages.clear();
            this.selectedPackage.set(null);
            this.onlyDebuggable.set(true);
        }

        public void performRefresh(final @NonNull IAndroidDeviceModel androidDeviceModel, final @NonNull IAndroidTargetDevice deviceToRefresh, boolean forceRefresh, boolean onlyDebuggable, boolean fromDeviceUpdate) {
            final IAndroidPackage originalSelection = (IAndroidPackage)this.selectedPackage.get();
            if (forceRefresh || !this.pendingRefresh.get() && !fromDeviceUpdate || this.onlyDebuggable.get() && !onlyDebuggable) {
                this.showProgressProperty.set(true);
                this.disableRefreshPackagesProperty.set(true);
                this.progressProperty.set(-1.0f);
                this.detectedPackages.clear();
                this.selectedPackage.set(null);
            }
            this.pendingRefresh.set(true);
            this.packagesDetectionDone.set(false);
            this.onlyDebuggable.set(onlyDebuggable);
            androidDeviceModel.requestPackageList(forceRefresh, onlyDebuggable, deviceToRefresh, new IPackageDetector.IPackageTaskProgressConsumer(){
                private final @NonNull AtomicReference<@Nullable Runnable> action = new AtomicReference();

                @Override
                public void cancelled(@NonNull IAndroidTargetDevice progressDevice) {
                    pendingRefresh.set(false);
                    this.enqueueAction(progressDevice, () -> {
                        showProgressProperty.set(false);
                        disableRefreshPackagesProperty.set(false);
                    });
                }

                @Override
                public void complete(@NonNull IAndroidTargetDevice progressDevice, boolean onlyDebuggable, @NonNull List<@NonNull IAndroidPackage> results) {
                    pendingRefresh.set(false);
                    this.enqueueAction(progressDevice, () -> {
                        LandingPageAndroidSubViewViewModel.replacePackagesList(detectedPackages, results);
                        LandingPageAndroidSubViewViewModel.updateSelectedPackage(detectedPackages, selectedPackage, originalSelection);
                        packagesDetectionDone.set(true);
                        showProgressProperty.set(false);
                        disableRefreshPackagesProperty.set(false);
                    });
                }

                @Override
                public void progress(@NonNull IAndroidTargetDevice progressDevice, int num, int total) {
                    this.enqueueAction(progressDevice, () -> {
                        if (androidDeviceModel.isDevicePackageListingCached(deviceToRefresh)) {
                            disableRefreshPackagesProperty.set(false);
                        } else {
                            disableRefreshPackagesProperty.set(true);
                            showProgressProperty.set(true);
                            progressProperty.set(total > 0 ? (float)num / (float)total : 0.0f);
                        }
                    });
                }

                private void enqueueAction(@NonNull IAndroidTargetDevice progressDevice, @NonNull Runnable runnable) {
                    Runnable oldRunnable;
                    if (deviceToRefresh.equals(progressDevice) && (oldRunnable = this.action.getAndSet(runnable)) == null) {
                        runOnUIThread.accept(this::processAction);
                    }
                }

                private void processAction() {
                    Runnable runnable = this.action.getAndSet(null);
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
        }
    }
}

