/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.utils;

import com.arm.streamline.ui.utils.ObservableUtils;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ui.services.IDisposable;

public final class BidirectionalKeyedToggleGroup<K, T extends Toggle> {
    protected final @NonNull ToggleGroup toggleGroup = new ToggleGroup();
    private final @NonNull IDisposable activeKeyChangeListener;
    private final @NonNull IDisposable selectedToggleChangeListener;
    private final @NonNull Map<@NonNull K, @NonNull T> toggles;

    public static <K, T extends Toggle> @NonNull BidirectionalKeyedToggleGroup<K, T> create(@NonNull ObjectProperty<@NonNull K> activeKey, @NonNull Map<@NonNull K, @NonNull T> toggles) {
        return new BidirectionalKeyedToggleGroup<K, T>(activeKey, toggles);
    }

    public BidirectionalKeyedToggleGroup(@NonNull ObjectProperty<@NonNull K> activeKey, @NonNull Map<@NonNull K, @NonNull T> toggles) {
        if (toggles.isEmpty()) {
            throw new IllegalArgumentException("no toggles");
        }
        this.toggles = toggles;
        toggles.forEach((k, t) -> t.setToggleGroup(this.toggleGroup));
        this.activeKeyChangeListener = ObservableUtils.onChange(activeKey, this::selectToggle);
        this.selectedToggleChangeListener = ObservableUtils.mapValue(this.toggleGroup.selectedToggleProperty(), activeKey, this::mapToggleToKey);
    }

    public void selectToggle(@NonNull K key) {
        Toggle toggle = (Toggle)this.toggles.get(key);
        if (toggle == null) {
            throw new IllegalStateException("Invalid toggle selection key: " + String.valueOf(key));
        }
        this.toggleGroup.selectToggle(toggle);
    }

    private @NonNull K mapToggleToKey(Toggle toggle) {
        Optional<Map.Entry> entryOpt = this.toggles.entrySet().stream().filter(e -> e.getValue() == toggle).findFirst();
        Map.Entry entry = entryOpt.orElse(null);
        if (entry == null) {
            throw new IllegalStateException("Invalid toggle: " + String.valueOf(toggle));
        }
        return entry.getKey();
    }
}

