/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part;

import com.arm.streamline.ui.controls.table.SvgImageTableCell;
import com.arm.streamline.ui.controls.table.TooltipTableRow;
import com.arm.streamline.ui.part.LandingPageScene;
import com.arm.streamline.ui.utils.LandingPagesUiUitility;
import com.arm.streamline.ui.utils.ObservableUtils;
import com.arm.streamline.ui.utils.SvgImageUtility;
import com.arm.streamline.ui.vm.IAndroidPackage;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import com.arm.streamline.ui.vm.ILandingPageAndroidSubViewViewModel;
import java.io.IOException;
import java.util.ResourceBundle;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Window;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ui.services.IDisposable;

public final class LandingPageAndroidSubView {
    private final @NonNull VBox rootNode;
    @FXML
    private TableView<IAndroidTargetDevice> tblExistingTargets;
    @FXML
    private TableColumn<IAndroidTargetDevice, String> colSerial;
    @FXML
    private TableColumn<IAndroidTargetDevice, String> colDetails;
    @FXML
    private TableColumn<IAndroidTargetDevice, IAndroidTargetDevice.Status> colStatus;
    @FXML
    private TableColumn<IAndroidTargetDevice, String> colRooted;
    @FXML
    private Button btnRefreshPackages;
    @FXML
    private Button btnRefreshDevices;
    @FXML
    private TableView<IAndroidPackage> tblPackages;
    @FXML
    private TableColumn<IAndroidPackage, String> colPackage;
    @FXML
    private TableColumn<IAndroidPackage, String> colActivity;
    @FXML
    private TableColumn<IAndroidPackage, IAndroidPackage.Status> colDebugStatus;
    @FXML
    private TextField inpApplicationFilter;
    @FXML
    private CheckBox btnShowDebuggable;
    @FXML
    private ProgressBar prgPackageProgress;
    @FXML
    private ProgressIndicator prgDeviceProgress;
    @FXML
    private TextFlow flNoPackages;
    @FXML
    private Text txtNoPackages;
    @FXML
    private Hyperlink lnkPlacholder_Android;
    @FXML
    private Text noDevicesExplanation;
    @FXML
    private Hyperlink lnkPlacholder_ResetAdb;
    @FXML
    private CheckBox btnOverrideActivity;
    @FXML
    private TextField inpActivityName;
    @FXML
    private ComboBox<String> inpArguments;
    private @NonNull IDisposable deviceSelectionChangeListener;
    private @NonNull IDisposable packageSelectionChangeListener;
    private final @NonNull String TEXT_FIELD_INVALID = "invalid-input";
    private final @NonNull ChangeListener<? super Number> windowPositionChangeListener = (p, o, n) -> this.inpArguments.hide();

    private static boolean isCharacterEvent(@NonNull KeyEvent event) {
        KeyCode keycode = event.getCode();
        return !event.isControlDown() && !keycode.isModifierKey() && !keycode.isNavigationKey() && !keycode.isFunctionKey() && !keycode.isMediaKey() && !keycode.isArrowKey();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void setUpAutocompleteBoilerplate(@NonNull ComboBox<@NonNull String> widget, @NonNull FilteredList<@NonNull String> filteredArgumentsList) {
        @NonNull ComboBoxListViewSkin skin = new ComboBoxListViewSkin(widget);
        skin.getPopupContent().addEventFilter(KeyEvent.ANY, e -> {
            if (e.getCode() == KeyCode.SPACE) {
                e.consume();
            }
        });
        widget.setSkin((Skin)skin);
        widget.setUserData((Object)0L);
        widget.setOnKeyPressed(e -> widget.hide());
        widget.setOnKeyReleased(event -> {
            KeyCode keycode = event.getCode();
            switch (keycode) {
                case UP: 
                case DOWN: {
                    LandingPagesUiUitility.runLater(() -> {
                        if (!widget.isShowing()) {
                            widget.show();
                        }
                    });
                    return;
                }
                case BACK_SPACE: 
                case DELETE: {
                    break;
                }
                default: {
                    assert (widget.getUserData() instanceof Long);
                    if (keycode == KeyCode.A && System.nanoTime() - (Long)widget.getUserData() < 500000000L) {
                        return;
                    }
                    if (keycode == KeyCode.CONTROL || keycode == KeyCode.COMMAND) {
                        widget.setUserData((Object)System.nanoTime());
                        return;
                    }
                    if (LandingPageAndroidSubView.isCharacterEvent(event)) break;
                    return;
                }
            }
            LandingPagesUiUitility.runLater(() -> {
                @NonNull String text = widget.getEditor().getText();
                int caret = widget.getEditor().getCaretPosition();
                if (text == null) {
                    return;
                }
                filteredArgumentsList.setPredicate(s -> s.startsWith(text));
                widget.getEditor().setText(text);
                widget.getEditor().positionCaret(caret);
                widget.getEditor().commitValue();
            });
        });
    }

    public LandingPageAndroidSubView(@NonNull ILandingPageAndroidSubViewViewModel viewModel, boolean licenseSupportsAndroid) throws IOException {
        FXMLLoader fxmlLoader = new FXMLLoader(LandingPageScene.class.getResource("/resources/fxml/landing-page-android-target-subview.fxml"));
        fxmlLoader.setResources(ResourceBundle.getBundle("com.arm.streamline.ui.part.LandingPageFxmlMessages"));
        fxmlLoader.setController((Object)this);
        this.rootNode = (VBox)fxmlLoader.load();
        this.noDevicesExplanation.textProperty().bind((ObservableValue)viewModel.adbPathStatusProperty());
        this.lnkPlacholder_ResetAdb.visibleProperty().bind((ObservableValue)viewModel.showResetAdbLink());
        this.lnkPlacholder_ResetAdb.setOnAction(e -> viewModel.resetAdbPathToDefault());
        this.prgDeviceProgress.visibleProperty().bind((ObservableValue)viewModel.deviceScanActive());
        this.tblExistingTargets.setItems(viewModel.detectedDevicesProperty());
        this.tblExistingTargets.setRowFactory(v -> new TooltipTableRow<IAndroidTargetDevice>(IAndroidTargetDevice::tooltipProperty));
        this.colStatus.setCellFactory(c -> new SvgImageTableCell(true, SvgImageUtility::mapStatusToSvgImage, s -> null, s -> null));
        this.colStatus.setCellValueFactory(d -> ((IAndroidTargetDevice)d.getValue()).statusProperty());
        this.colRooted.setCellValueFactory(d -> new SimpleStringProperty(((IAndroidTargetDevice)d.getValue()).canProfileNonDebuggableApps() ? "Development" : "Production"));
        this.colSerial.setCellValueFactory(d -> new SimpleStringProperty(((IAndroidTargetDevice)d.getValue()).getTargetAddress()));
        this.colDetails.setCellValueFactory(d -> new SimpleStringProperty(((IAndroidTargetDevice)d.getValue()).getDescription()));
        this.btnRefreshDevices.disableProperty().bind((ObservableValue)viewModel.disableRefreshDevicesProperty());
        this.btnRefreshDevices.setOnAction(e -> viewModel.doScanForDevices());
        this.btnShowDebuggable.selectedProperty().bindBidirectional((Property)viewModel.showDebuggablePackagesProperty());
        this.tblPackages.setItems(viewModel.sortedDetectedPackageProperty());
        this.tblPackages.setRowFactory(v -> TooltipTableRow.fromUnobservable(IAndroidPackage::getTooltip));
        this.inpApplicationFilter.textProperty().bindBidirectional((Property)viewModel.applicationFilterTextProperty());
        this.colDebugStatus.setCellFactory(c -> new SvgImageTableCell(true, SvgImageUtility::mapPackageStatusToSvgImage, s -> null, s -> null));
        this.colDebugStatus.setCellValueFactory(d -> new SimpleObjectProperty((Object)((IAndroidPackage)d.getValue()).getStatus()));
        this.colPackage.setCellValueFactory(d -> new SimpleObjectProperty((Object)((IAndroidPackage)d.getValue()).getPackageName()));
        this.colActivity.setCellValueFactory(d -> new SimpleObjectProperty((Object)((IAndroidPackage)d.getValue()).getActivityName()));
        TableView.TableViewSelectionModel selectionModel = this.tblExistingTargets.getSelectionModel();
        selectionModel.setSelectionMode(SelectionMode.SINGLE);
        this.deviceSelectionChangeListener = ObservableUtils.bindSingleSelectionBidirectional(viewModel.selectedDeviceProperty(), selectionModel);
        TableView.TableViewSelectionModel debuggablePackageModel = this.tblPackages.getSelectionModel();
        debuggablePackageModel.setSelectionMode(SelectionMode.SINGLE);
        this.packageSelectionChangeListener = ObservableUtils.bindSingleSelectionBidirectional(viewModel.selectedPackageProperty(), debuggablePackageModel);
        this.prgPackageProgress.visibleProperty().bind((ObservableValue)viewModel.showProgressProperty());
        this.prgPackageProgress.progressProperty().bind((ObservableValue)viewModel.progressProperty());
        this.flNoPackages.visibleProperty().bind((ObservableValue)this.prgPackageProgress.visibleProperty().not());
        this.txtNoPackages.textProperty().bind((ObservableValue)viewModel.noPackagesPlaceholderTextProperty());
        this.btnRefreshPackages.setOnAction(e -> viewModel.doRefreshPackages());
        this.tblExistingTargets.disableProperty().bind((ObservableValue)viewModel.uiElementDisableProperty());
        this.tblPackages.disableProperty().bind((ObservableValue)viewModel.uiElementDisableProperty());
        this.btnShowDebuggable.disableProperty().bind((ObservableValue)viewModel.uiElementDisableProperty());
        this.btnRefreshPackages.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)viewModel.disableRefreshPackagesProperty(), (ObservableBooleanValue)viewModel.uiElementDisableProperty()));
        this.inpApplicationFilter.disableProperty().bind((ObservableValue)viewModel.uiElementDisableProperty());
        if (licenseSupportsAndroid) {
            this.lnkPlacholder_Android.setOnAction(e -> viewModel.doShowAndroidTargetHelp());
        } else {
            this.lnkPlacholder_Android.setDisable(true);
        }
        this.btnOverrideActivity.selectedProperty().bindBidirectional((Property)viewModel.overrideActivityProperty());
        this.btnOverrideActivity.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)viewModel.selectedPackageProperty().isNull(), (ObservableBooleanValue)viewModel.uiElementDisableProperty()));
        this.inpActivityName.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)Bindings.or((ObservableBooleanValue)viewModel.selectedPackageProperty().isNull(), (ObservableBooleanValue)viewModel.overrideActivityProperty().not()), (ObservableBooleanValue)viewModel.uiElementDisableProperty()));
        this.inpActivityName.textProperty().bindBidirectional((Property)viewModel.overrideActivityNameProperty());
        this.inpActivityName.textProperty().addListener((obsrvr, old_val, new_val) -> this.updateActivityNameFieldStyle(viewModel));
        viewModel.overrideActivityProperty().addListener((obsrvr, old_val, new_val) -> this.updateActivityNameFieldStyle(viewModel));
        this.inpArguments.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)viewModel.selectedPackageProperty().isNull(), (ObservableBooleanValue)viewModel.uiElementDisableProperty()));
        this.inpArguments.getEditor().textProperty().bindBidirectional((Property)viewModel.applicationArgumentsProperty());
        this.inpArguments.setItems(viewModel.filteredApplicationArgumentsHistoryProperty());
        LandingPageAndroidSubView.setUpAutocompleteBoilerplate(this.inpArguments, viewModel.filteredApplicationArgumentsHistoryProperty());
    }

    public @NonNull Node getNode() {
        return this.rootNode;
    }

    private void updateActivityNameFieldStyle(@NonNull ILandingPageAndroidSubViewViewModel viewModel) {
        if (viewModel.overrideActivityProperty().get() && ((String)this.inpActivityName.textProperty().get()).isBlank()) {
            this.inpActivityName.getStyleClass().add((Object)"invalid-input");
        } else {
            this.inpActivityName.getStyleClass().removeIf(style -> style.equals("invalid-input"));
        }
    }

    public void addListenersToScene(@NonNull Scene scene) {
        Window window = scene.getWindow();
        window.xProperty().addListener(this.windowPositionChangeListener);
        window.yProperty().addListener(this.windowPositionChangeListener);
        window.widthProperty().addListener(this.windowPositionChangeListener);
        window.heightProperty().addListener(this.windowPositionChangeListener);
    }
}

