/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.controls.table;

import com.arm.utils.NullChecking;
import java.util.function.Function;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.layout.BorderPane;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GraphicTableCell<S, T>
extends TableCell<S, T> {
    private final @NonNull Function<T, @Nullable Node> graphicMapper;
    private final @NonNull Function<T, @Nullable String> textMapper;
    private final @NonNull Function<T, @Nullable String> styleClassMapper;
    private @Nullable String currentStyleClass = null;
    private final @NonNull BorderPane container = new BorderPane();

    public GraphicTableCell(@NonNull Function<T, @Nullable Node> graphicMapper, @NonNull Function<T, @Nullable String> textMapper, @NonNull Function<T, @Nullable String> styleClassMapper) {
        this.graphicMapper = graphicMapper;
        this.textMapper = textMapper;
        this.styleClassMapper = styleClassMapper;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            this.setStyleClass(null);
        } else {
            Node graphic = this.graphicMapper.apply(item);
            String text = this.textMapper.apply(item);
            String styleClass = this.styleClassMapper.apply(item);
            if (graphic != null) {
                this.container.setCenter(graphic);
                this.setGraphic((Node)this.container);
            } else {
                this.setGraphic(null);
                this.container.setCenter(null);
            }
            this.setStyleClass(styleClass);
            this.setText(text);
        }
    }

    private void setStyleClass(@Nullable String newClass) {
        String currentStyleClass = this.currentStyleClass;
        if (NullChecking.equalsNullable((Object)currentStyleClass, (Object)newClass)) {
            return;
        }
        if (currentStyleClass != null) {
            this.getStyleClass().remove((Object)currentStyleClass);
        }
        if (newClass != null) {
            this.getStyleClass().add((Object)newClass);
        }
        this.currentStyleClass = newClass;
    }
}

