/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.controls;

import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.ArrayUtils;
import com.arm.utils.function.IThrowingBiConsumer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SimpleSvgParser {
    public static void load(@NonNull File file, @NonNull ISimpleSvgVisitorFactory visitorFactory) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLParser parser = XMLParser.create((File)file);){
            SimpleSvgParser.load(parser, visitorFactory);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void load(@NonNull InputStream stream, @NonNull ISimpleSvgVisitorFactory visitorFactory) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLParser parser = new XMLParser(stream);){
            SimpleSvgParser.load(parser, visitorFactory);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void load(@NonNull XMLParser parser, @NonNull ISimpleSvgVisitorFactory visitorFactory) throws IOException {
        String rootTag = parser.nextTag();
        if (!"svg".contentEquals(rootTag)) {
            throw new IOException("not an svg");
        }
        SimpleSvgParser.requireOnlyAttributes(parser, "class", "width", "height", "viewBox", "fill");
        ISimpleSvgVisitor visitor = visitorFactory.create(Set.of(parser.getAttribute("class", "").split("[ \\t]+")), parser.getAttribute("width", ""), parser.getAttribute("height", ""), SimpleSvgParser.toRectangle(parser.getAttribute("viewBox", "")), parser.getAttribute("fill", ""));
        SimpleSvgParser.parseNested(parser, (IThrowingBiConsumer<XMLParser, String, IOException>)((IThrowingBiConsumer)(p, t) -> SimpleSvgParser.parseElement(p, t, visitor)));
    }

    private static @Nullable Bounds toRectangle(@NonNull String str) throws IOException {
        String[] parts = str.split("[ \\t]+");
        if (parts.length == 4) {
            return new BoundingBox(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
        }
        if (parts.length == 0) {
            return null;
        }
        throw new IOException("unsupported rectangle format " + str);
    }

    private static void parseElement(@NonNull XMLParser parser, @NonNull String tag, @NonNull ISimpleSvgVisitor visitor) throws IOException {
        switch (tag) {
            case "path": {
                SimpleSvgParser.requireOnlyAttributes(parser, "fill-rule", "d", "fill");
                visitor.path(parser.getAttribute("fill-rule", ""), parser.getAttribute("fill", ""), parser.getAttribute("d", ""));
                break;
            }
            default: {
                throw new IOException("Unsupported element " + tag);
            }
        }
    }

    private static void parseNested(@NonNull XMLParser parser, @NonNull IThrowingBiConsumer<@NonNull XMLParser, @NonNull String, IOException> consumer) throws IOException {
        String tag;
        String marker = parser.getMarker();
        while ((tag = parser.nextTag(marker)) != null) {
            consumer.accept((Object)parser, (Object)tag);
        }
    }

    private static void requireOnlyAttributes(@NonNull XMLParser parser, String ... attrs) throws IOException {
        int count = parser.getAttributeCount();
        int i = 0;
        while (i < count) {
            String name = parser.getAttributeName(i);
            if (ArrayUtils.indexOf((Object[])attrs, (Object)name) < 0) {
                throw new IOException("Unexpected attribute " + name + " on " + parser.getCurrentTag());
            }
            ++i;
        }
    }

    public static interface ISimpleSvgVisitor {
        public void path(@NonNull String var1, @NonNull String var2, @NonNull String var3);
    }

    @FunctionalInterface
    public static interface ISimpleSvgVisitorFactory {
        public @NonNull ISimpleSvgVisitor create(@NonNull Set<@NonNull String> var1, @NonNull String var2, @NonNull String var3, @Nullable Bounds var4, @NonNull String var5);
    }
}

