/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.controls;

import com.arm.streamline.ui.controls.SimpleSvgParser;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.geometry.Bounds;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SimpleSvgObjectModelFactory
implements SimpleSvgParser.ISimpleSvgVisitorFactory {
    private @Nullable SimpleSvg newImage;

    public static @NonNull SimpleSvg load(@NonNull File file) throws IOException {
        SimpleSvgObjectModelFactory visitorFactory = new SimpleSvgObjectModelFactory();
        SimpleSvgParser.load(file, (SimpleSvgParser.ISimpleSvgVisitorFactory)visitorFactory);
        return (SimpleSvg)NullChecking.neverNull((Object)visitorFactory.newImage);
    }

    public static @NonNull SimpleSvg load(@NonNull InputStream stream) throws IOException {
        SimpleSvgObjectModelFactory visitorFactory = new SimpleSvgObjectModelFactory();
        SimpleSvgParser.load(stream, (SimpleSvgParser.ISimpleSvgVisitorFactory)visitorFactory);
        return (SimpleSvg)NullChecking.neverNull((Object)visitorFactory.newImage);
    }

    private SimpleSvgObjectModelFactory() {
    }

    @Override
    public @NonNull SimpleSvgParser.ISimpleSvgVisitor create(@NonNull Set<@NonNull String> classes, @NonNull String width, @NonNull String height, @Nullable Bounds viewBox, @NonNull String fill) {
        SimpleSvg newImage;
        this.newImage = newImage = new SimpleSvg(classes, width, height, viewBox, fill);
        return new SimpleSvgParser.ISimpleSvgVisitor(){

            @Override
            public void path(@NonNull String fillRule, @NonNull String fill, @NonNull String d) {
                newImage.elements.add(new SimpleSvgPath(fillRule, fill, d));
            }
        };
    }

    public static interface ISimpleSvgElement {
        public void accept(@NonNull SimpleSvgParser.ISimpleSvgVisitor var1);
    }

    public static final class SimpleSvg {
        public final @NonNull Set<@NonNull String> classes;
        public final @NonNull List<ISimpleSvgElement> elements = new ArrayList<ISimpleSvgElement>();
        public final @NonNull String fill;
        public final @NonNull String height;
        public final @Nullable Bounds viewBox;
        public final @NonNull String width;

        public SimpleSvg(@NonNull Set<@NonNull String> classes, @NonNull String width, @NonNull String height, @Nullable Bounds viewBox, @NonNull String fill) {
            this.classes = classes;
            this.width = width;
            this.height = height;
            this.viewBox = viewBox;
            this.fill = fill;
        }

        public void accept(@NonNull SimpleSvgParser.ISimpleSvgVisitorFactory factory) {
            SimpleSvgParser.ISimpleSvgVisitor visitor = factory.create(this.classes, this.width, this.height, this.viewBox, this.fill);
            this.elements.forEach(e -> e.accept(visitor));
        }
    }

    public static final class SimpleSvgPath
    implements ISimpleSvgElement {
        public final @NonNull String d;
        public final @NonNull String fill;
        public final @NonNull String fillRule;

        public SimpleSvgPath(@NonNull String fillRule, @NonNull String fill, @NonNull String d) {
            this.fillRule = fillRule;
            this.fill = fill;
            this.d = d;
        }

        @Override
        public void accept(@NonNull SimpleSvgParser.ISimpleSvgVisitor visitor) {
            visitor.path(this.fillRule, this.fill, this.d);
        }
    }
}

