/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.utils.config;

import com.arm.mgd.utils.OSUtils;
import com.arm.mgd.utils.config.IReadOnlyConfigCollection;
import com.arm.mgd.utils.config.IWritableConfigCollection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessEnvironment
implements IWritableConfigCollection {
    public static final IReadOnlyConfigCollection ENV = new ProcessEnvironment();
    private final Map<String, String> environment;

    public ProcessEnvironment() {
        if (OSUtils.OS == OSUtils.OSType.WINDOWS) {
            this.environment = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            try {
                this.environment.putAll(new ProcessBuilder(new String[0]).environment());
            }
            catch (Exception exception) {}
        } else {
            this.environment = new ProcessBuilder(new String[0]).environment();
        }
    }

    @Override
    public @Nullable String asString(@NonNull String key) {
        return this.environment.get(key);
    }

    @Override
    public void put(@NonNull String key, @NonNull String value) {
        this.environment.put(key, value);
    }

    public Map<String, String> getAll() {
        return Collections.unmodifiableMap(this.environment);
    }

    public String[] getAllAsArray() {
        return (String[])this.environment.entrySet().stream().map(entry -> String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue()).toArray(String[]::new);
    }

    @Override
    public @NonNull Class<?> getValueClass(@NonNull String key) {
        return String.class;
    }
}

