/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.utils;

import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.jdt.annotation.NonNull;

public class VersionProperties {
    private static final @NonNull Properties VERSION_PROPERTIES;
    public static final @NonNull String FULL_PRODUCT_NAME;
    public static final @NonNull String SHORT_PRODUCT_NAME;
    public static final @NonNull String BUILD_ID;
    public static final @NonNull String PRODUCT_VERSION;
    public static final @NonNull String PRODUCT_VERSION_MAJOR_MINOR_ONLY;
    public static final @NonNull String PRODUCT_NAME_AND_VERSION;

    static {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (InputStream stream = VersionProperties.class.getResourceAsStream("version.properties");){
                if (stream == null) {
                    throw new PropertiesError("Can't find essential system settings.");
                }
                VERSION_PROPERTIES = new Properties();
                VERSION_PROPERTIES.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new PropertiesError("Can't read essential system settings.", e);
        }
        FULL_PRODUCT_NAME = VersionProperties.getSystemProperty("com.arm.mgd.product_full_name");
        SHORT_PRODUCT_NAME = VersionProperties.getSystemProperty("com.arm.mgd.product_short_name");
        BUILD_ID = VersionProperties.getSystemProperty("com.arm.mgd.build");
        PRODUCT_VERSION = VersionProperties.getSystemProperty("com.arm.mgd.version");
        PRODUCT_VERSION_MAJOR_MINOR_ONLY = NullUtils.neverNull(PRODUCT_VERSION.substring(0, PRODUCT_VERSION.indexOf(".", PRODUCT_VERSION.indexOf(".") + 1)));
        PRODUCT_NAME_AND_VERSION = NullUtils.neverNull(String.format("%s %s", FULL_PRODUCT_NAME, PRODUCT_VERSION));
    }

    private static @NonNull String getSystemProperty(@NonNull String propertyName) {
        String propertyValue = VERSION_PROPERTIES.getProperty(propertyName);
        if (propertyValue == null) {
            throw new PropertiesError("Can't read \"" + propertyName + "\", an essential system setting.");
        }
        return propertyValue;
    }

    private static class PropertiesError
    extends Error {
        private static final long serialVersionUID = 3492832075674905509L;
        private static final String MESSAGE_TEMPLATE = "%s The application cannot continue. Please report this message to Arm.";

        PropertiesError(@NonNull String message) {
            super(String.format(MESSAGE_TEMPLATE, message));
        }

        PropertiesError(@NonNull String message, @NonNull Throwable cause) {
            super(String.format(MESSAGE_TEMPLATE, message), cause);
        }
    }
}

