/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.utils;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NullUtils {
    public static final @NonNull Boolean FALSE = NullUtils.neverNull(Boolean.FALSE);
    public static final @NonNull Boolean TRUE = NullUtils.neverNull(Boolean.TRUE);
    public static final @NonNull List EMPTY_LIST = NullUtils.neverNull(Collections.EMPTY_LIST);
    public static final @NonNull Set EMPTY_SET = NullUtils.neverNull(Collections.EMPTY_SET);
    public static final @NonNull Map EMPTY_MAP = NullUtils.neverNull(Collections.EMPTY_MAP);
    public static final @NonNull WeakReference EMPTY_WEAK_REFERENCE = new WeakReference<Object>(null);
    public static final @NonNull Instant EPOCH = NullUtils.neverNull(Instant.EPOCH);

    public static final <T> @NonNull List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static final <K, V> @NonNull Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static final <T> @NonNull Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static <T> @NonNull WeakReference<T> emptyWeakReference() {
        return EMPTY_WEAK_REFERENCE;
    }

    public static <T> @NonNull List<T> unmodifiableList(@NonNull List<? extends T> list) {
        return NullUtils.neverNull(Collections.unmodifiableList(list));
    }

    public static <T> @NonNull Collection<T> unmodifiableCollection(@NonNull Collection<? extends T> collection) {
        return NullUtils.neverNull(Collections.unmodifiableCollection(collection));
    }

    public static <K, V> @NonNull Map<K, V> unmodifiableMap(@NonNull Map<? extends K, ? extends V> map) {
        return NullUtils.neverNull(Collections.unmodifiableMap(map));
    }

    public static <T> @NonNull Set<T> unmodifiableSet(@NonNull Set<? extends T> set) {
        return NullUtils.neverNull(Collections.unmodifiableSet(set));
    }

    public static <T> @NonNull Collector<@NonNull T, ?, Long> counter() {
        return NullUtils.neverNull(Collectors.counting());
    }

    public static <T> @NonNull List<T> collectToList(@NonNull Stream<T> stream) {
        List list = stream.collect(Collectors.toList());
        assert (list != null);
        return list;
    }

    public static <T> @NonNull Set<T> collectToSet(@NonNull Stream<T> stream) {
        Set set = stream.collect(Collectors.toSet());
        assert (set != null);
        return set;
    }

    public static <T> boolean equals(T a, T b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static <T> boolean isArrayNonNull(T[] values) {
        return values == null ? false : Stream.of(values).noneMatch(value -> value == null);
    }

    public static <T> boolean isCollectionNonNull(Collection<T> collection) {
        return collection == null ? false : collection.stream().noneMatch(entry -> entry == null);
    }

    public static byte @NonNull [] neverNull(byte[] value) {
        assert (value != null);
        return value;
    }

    public static short @NonNull [] neverNull(short[] value) {
        assert (value != null);
        return value;
    }

    public static int @NonNull [] neverNull(int[] value) {
        assert (value != null);
        return value;
    }

    public static long @NonNull [] neverNull(long[] value) {
        assert (value != null);
        return value;
    }

    public static float @NonNull [] neverNull(float[] value) {
        assert (value != null);
        return value;
    }

    public static double @NonNull [] neverNull(double[] value) {
        assert (value != null);
        return value;
    }

    public static char @NonNull [] neverNull(char[] value) {
        assert (value != null);
        return value;
    }

    public static boolean @NonNull [] neverNull(boolean[] value) {
        assert (value != null);
        return value;
    }

    public static <T> @NonNull T neverNull(@Nullable T value) {
        assert (value != null);
        return value;
    }

    public static <T> T @NonNull [] neverNull(T[] value) {
        assert (value != null);
        return value;
    }

    public static <T> @NonNull List<@NonNull T> neverNullList(List<T> list) {
        return list;
    }

    public static <T> @NonNull Collection<@NonNull T> neverNullCollection(Collection<T> collection) {
        return collection;
    }

    public static <T> @NonNull T nonNullOrDefault(@Nullable T value, @NonNull T deflt) {
        if (value != null) {
            return value;
        }
        return deflt;
    }

    public static @NonNull Long longValueOf(long l) {
        return NullUtils.neverNull(l);
    }

    public static @NonNull Float floatValueOf(float f) {
        return NullUtils.neverNull(Float.valueOf(f));
    }

    public static @NonNull Byte byteValueOf(byte b) {
        return NullUtils.neverNull(b);
    }

    public static @NonNull Short shortValueOf(short s) {
        return NullUtils.neverNull(s);
    }

    public static @NonNull Integer intValueOf(int i) {
        return NullUtils.neverNull(i);
    }

    public static @NonNull Integer intValueOf(String s) {
        return NullUtils.neverNull(Integer.valueOf(s));
    }

    public static @NonNull Double doubleValueOf(double d) {
        return NullUtils.neverNull(d);
    }

    public static @NonNull Boolean booleanValueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static @NonNull Boolean invertBoolean(@NonNull Boolean B) {
        return B != false ? FALSE : TRUE;
    }

    public static @NonNull String stringValueOf(long l) {
        return NullUtils.neverNull(String.valueOf(l));
    }

    public static @NonNull String stringValueOf(float f) {
        return NullUtils.neverNull(String.valueOf(f));
    }

    public static @NonNull String stringValueOf(boolean b) {
        return NullUtils.neverNull(String.valueOf(b));
    }

    public static @NonNull String toString(Object[] a) {
        return NullUtils.neverNull(Arrays.toString(a));
    }

    @SafeVarargs
    public static <T> @NonNull List<T> asList(T ... a) {
        return NullUtils.neverNull(Arrays.asList(a));
    }

    @SafeVarargs
    public static <T> @NonNull Set<T> setOf(T ... a) {
        return NullUtils.neverNull(Set.of(a));
    }

    public static @NonNull String formattedString(@NonNull String format, Object ... args) {
        return NullUtils.neverNull(String.format(format, args));
    }

    public static @NonNull String buildString(@NonNull StringBuilder builder) {
        return NullUtils.neverNull(builder.toString());
    }

    public static <T> @NonNull Future<T> future(@NonNull ExecutorService executor, @NonNull Callable<T> callable) {
        return NullUtils.neverNull(executor.submit(callable));
    }

    public static <T> @NonNull Stream<T> filteredStream(@NonNull Collection<T> collection, @NonNull Predicate<? super T> predicate) {
        return NullUtils.neverNull(collection.stream().filter(predicate));
    }

    public static <T> @NonNull Stream<@NonNull T> nullFilteredStream(@NonNull Collection<T> collection) {
        return NullUtils.filteredStream(collection, value -> value != null);
    }

    public static <T, R> @NonNull Stream<? extends R> mappedStream(@NonNull Stream<T> stream, @NonNull Function<? super T, ? extends R> mapper) {
        return NullUtils.neverNull(stream.map(mapper));
    }

    public static <T, R> @NonNull Stream<? extends R> mappedStream(@NonNull Collection<T> collection, @NonNull Function<? super T, ? extends R> mapper) {
        return NullUtils.neverNull(collection.stream().map(mapper));
    }

    public static <T, R> @NonNull IntStream mappedIntStream(@NonNull Collection<T> collection, @NonNull ToIntFunction<? super T> mapper) {
        return NullUtils.neverNull(collection.stream().mapToInt(mapper));
    }

    public static @NonNull ByteBuffer asReadOnlyByteBuffer(byte @NonNull [] bytes) {
        return NullUtils.neverNull(ByteBuffer.wrap(bytes).asReadOnlyBuffer());
    }

    @SafeVarargs
    public static <T> @NonNull List<@NonNull T> asNullFilteredList(T ... a) {
        return NullUtils.collectToList(NullUtils.nullFilteredStream(Arrays.asList(a)));
    }

    public static @NonNull Instant now() {
        return NullUtils.neverNull(Instant.now());
    }
}

