/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.misc;

import com.arm.streamline.common.utility.UnsignedUtil;
import com.arm.utils.NullChecking;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public final class LinuxMapsParser {
    private static final Pattern MAPS_PATTERN = Pattern.compile("([0-9a-f]+)-([0-9a-f]+) [r-][w-]x[ps] ([0-9a-f]+) [0-9a-f]+:[0-9a-f]+ [0-9]+ +(.*)");

    public static <E extends Throwable> void parse(@NonNull String maps, @NonNull ILinuxMapsParserConsumer<E> consumer) throws E {
        Matcher matcher = MAPS_PATTERN.matcher(maps);
        while (matcher.find()) {
            long startAddress = UnsignedUtil.parseHexStr((String)matcher.group(1));
            long endAddress = UnsignedUtil.parseHexStr((String)matcher.group(2));
            long offset = UnsignedUtil.parseHexStr((String)matcher.group(3));
            String filename = (String)NullChecking.neverNull((Object)matcher.group(4));
            consumer.consume(startAddress, endAddress, offset, filename);
        }
    }

    @FunctionalInterface
    public static interface ILinuxMapsParserConsumer<E extends Throwable> {
        public void consume(long var1, long var3, long var5, @NonNull String var7) throws E;
    }
}

