/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.misc;

import com.arm.streamline.analysis.model.KernelSymbol;
import com.arm.utils.NullChecking;
import com.arm.utils.numbers.UnsignedLong;
import gnu.trove.map.TObjectCharMap;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectCharHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class LinuxKAllSymsSymbolToModuleTransform {
    static final long TYPICAL_MAX_FUNCTION_SIZE = 16384L;

    public static @NonNull List<@NonNull ModuleInfo> map(@NonNull List<@NonNull KernelSymbol> kernelSymbols) throws IOException {
        @NonNull TObjectLongHashMap moduleStart = new TObjectLongHashMap(10, 0.5f, -1L);
        @NonNull TObjectLongHashMap moduleEnd = new TObjectLongHashMap(10, 0.5f, 0L);
        @NonNull TObjectCharHashMap moduleEndType = new TObjectCharHashMap();
        kernelSymbols.forEach(arg_0 -> LinuxKAllSymsSymbolToModuleTransform.lambda$0((TObjectLongMap)moduleEnd, (TObjectLongMap)moduleStart, (TObjectCharMap)moduleEndType, arg_0));
        @NonNull ArrayList<@NonNull ModuleInfo> result = new ArrayList<ModuleInfo>();
        for (String module : moduleStart.keySet()) {
            long endToUse;
            assert (module != null);
            long start = moduleStart.get((Object)module);
            long end = moduleEnd.get((Object)module);
            char endSymbolType = moduleEndType.get((Object)module);
            if (endSymbolType == 'T' || endSymbolType == 't') {
                long nextStart = 0L;
                long[] lArray = moduleStart.values();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long possibleNextStart = lArray[n2];
                    if (Long.compareUnsigned(possibleNextStart, start) > 0 && (nextStart == 0L || Long.compareUnsigned(possibleNextStart, nextStart) < 0)) {
                        nextStart = possibleNextStart;
                    }
                    ++n2;
                }
                endToUse = end + UnsignedLong.min((long)(nextStart - end), (long)16384L);
            } else {
                endToUse = end;
            }
            long length = endToUse - start;
            if (length == 0L) continue;
            result.add(new ModuleInfo(module, start, length));
        }
        result.sort((a, b) -> {
            int r = UnsignedLong.compare((long)a.address, (long)b.address);
            if (r != 0) {
                return r;
            }
            r = NullChecking.compareToNullable((Comparable)((Object)a.name), (Comparable)((Object)b.name), (boolean)true);
            if (r != 0) {
                return r;
            }
            return UnsignedLong.compare((long)a.length, (long)b.length);
        });
        return result;
    }

    private static /* synthetic */ void lambda$0(TObjectLongMap tObjectLongMap, TObjectLongMap tObjectLongMap2, TObjectCharMap tObjectCharMap, KernelSymbol ks) {
        long startAddress = ks.address;
        @NonNull String module = ks.module;
        char symbolType = ks.type;
        if (symbolType != 'a' && symbolType != 'A') {
            long previousEnd = tObjectLongMap.get((Object)module);
            tObjectLongMap2.put((Object)module, UnsignedLong.min((long)startAddress, (long)tObjectLongMap2.get((Object)module)));
            if (Long.compareUnsigned(startAddress, previousEnd) > 0) {
                tObjectLongMap.put((Object)module, startAddress);
                tObjectCharMap.put((Object)module, symbolType);
            }
        }
    }

    public static final class ModuleInfo {
        public final long address;
        public final long length;
        public final @NonNull String name;

        public ModuleInfo(@NonNull String name, long address, long length) {
            this.name = name;
            this.address = address;
            this.length = length;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModuleInfo) {
                ModuleInfo that = (ModuleInfo)obj;
                return this.name.contentEquals(that.name) && this.address == that.address && this.length == that.length;
            }
            return false;
        }

        public int hashCode() {
            return (NullChecking.hashNullable((Object)this.name) * 31 + Long.hashCode(this.address)) * 31 + Long.hashCode(this.length);
        }

        public String toString() {
            return String.format("ModuleInfo [name=%s, address=0x%016x, length=0x%08x]", this.name, this.address, this.length);
        }
    }
}

