/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.misc;

import com.arm.streamline.analysis.model.KernelSymbol;
import com.arm.streamline.common.utility.UnsignedUtil;
import com.arm.streamline.protocol.misc.ILinuxKAllSymsSymbolParser;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public final class LinuxKAllSymsSymbolParser
implements ILinuxKAllSymsSymbolParser {
    private static final Pattern KALLSYMS_PATTERN = Pattern.compile("([0-9a-f]+) ([a-zA-Z]) ([^\\t\\n]*)(?:|\\t\\[(.*)\\])\\n");
    private final @NonNull List<@NonNull KernelSymbol> symbols = new ArrayList<KernelSymbol>();

    @Override
    public void append(@NonNull String text) {
        Matcher matcher = KALLSYMS_PATTERN.matcher(text);
        while (matcher.find()) {
            long address = UnsignedUtil.parseHexStr((String)matcher.group(1));
            char type = ((String)NullChecking.neverNull((Object)matcher.group(2))).charAt(0);
            @NonNull String symbol = ((String)NullChecking.neverNull((Object)matcher.group(3))).trim();
            @NonNull String module = ((String)NullChecking.neverNullOr((Object)matcher.group(4), (Object)"")).trim();
            this.symbols.add(new KernelSymbol(module, symbol, type, address));
        }
    }

    @Override
    public @NonNull List<@NonNull KernelSymbol> getAllSymbols() {
        return Collections.unmodifiableList(this.symbols);
    }
}

