/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.v22.perf;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import com.arm.streamline.protocol.gator.messages.ILongProperty;
import com.arm.streamline.protocol.gator.messages.IMessage;
import com.arm.streamline.protocol.gator.messages.IMessageCodec;
import com.arm.streamline.protocol.gator.messages.PackedIntProperty;
import com.arm.streamline.protocol.gator.messages.PackedLongProperty;
import com.arm.streamline.protocol.gator.v22.AbstractFrameWithCore;
import com.arm.streamline.protocol.gator.v22.IMessageCodecContextV22;
import gnu.trove.list.array.TLongArrayList;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;

public final class PerfSyncThreadFrame
extends AbstractFrameWithCore
implements IMessage<Codec> {
    public static final long INVALID_OR_DISABLED_FREQ_VALUE = 0L;
    public final long freq;
    public final long @NonNull [] monotonicRaws;
    public final int syncThreadPid;
    public final int syncThreadTid;
    public final long @NonNull [] vcounts;

    public PerfSyncThreadFrame(int cpu, int syncThreadPid, int syncThreadTid, long freq, long @NonNull [] monotonicRaws, long @NonNull [] vcounts) {
        super(cpu);
        if (monotonicRaws.length != vcounts.length) {
            throw new IllegalArgumentException("ids and keys must be same length");
        }
        this.syncThreadPid = syncThreadPid;
        this.syncThreadTid = syncThreadTid;
        this.freq = freq;
        this.monotonicRaws = monotonicRaws;
        this.vcounts = vcounts;
    }

    @Override
    public @NonNull Codec getCodec() {
        return Codec.INSTANCE;
    }

    @Override
    public @NonNull String toString() {
        return String.format("PerfSyncThreadFrame(%s, %s, %s, %s, %s, %s)", this.cpu, this.syncThreadPid, this.syncThreadTid, this.freq, Arrays.toString(this.monotonicRaws), Arrays.toString(this.vcounts));
    }

    public static final class Codec
    extends Enum<Codec>
    implements IMessageCodec<PerfSyncThreadFrame, IPerfSyncThreadFrameConsumer, IMessageCodecContextV22> {
        public static final /* enum */ Codec INSTANCE = new Codec();
        public static final @NonNull ILongProperty PROPERTY_CLOCK_MONOTONIC_RAW;
        public static final @NonNull ILongProperty PROPERTY_FREQ;
        public static final @NonNull IIntProperty PROPERTY_PID;
        public static final @NonNull IIntProperty PROPERTY_TID;
        public static final @NonNull ILongProperty PROPERTY_VCOUNT;
        private static final /* synthetic */ Codec[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Codec[]{INSTANCE};
            PROPERTY_CLOCK_MONOTONIC_RAW = new PackedLongProperty("clock_monotonic_raw");
            PROPERTY_FREQ = new PackedLongProperty("freq");
            PROPERTY_PID = new PackedIntProperty("syncThreadPid");
            PROPERTY_TID = new PackedIntProperty("syncThreadTid");
            PROPERTY_VCOUNT = new PackedLongProperty("vcount");
        }

        @Override
        public void decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream, @NonNull IPerfSyncThreadFrameConsumer consumer) throws IOException {
            assert (token == this.token());
            if (stream.hasRemaining()) {
                int cpu = PROPERTY_CPU.read(stream);
                if (stream.hasRemaining()) {
                    int syncThreadPid = PROPERTY_PID.read(stream);
                    int syncThreadTid = PROPERTY_TID.read(stream);
                    long freq = PROPERTY_FREQ.read(stream);
                    TLongArrayList monotonicRaws = new TLongArrayList();
                    TLongArrayList vcounts = new TLongArrayList();
                    while (stream.hasRemaining()) {
                        long monotonicRaw = PROPERTY_CLOCK_MONOTONIC_RAW.read(stream);
                        long vcount = PROPERTY_VCOUNT.read(stream);
                        monotonicRaws.add(monotonicRaw);
                        vcounts.add(vcount);
                    }
                    long @NonNull [] monotonicRawsArray = monotonicRaws.toArray();
                    long @NonNull [] vcountsArray = vcounts.toArray();
                    @NonNull PerfSyncThreadFrame frame = new PerfSyncThreadFrame(cpu, syncThreadPid, syncThreadTid, freq, monotonicRawsArray, vcountsArray);
                    consumer.consumePerfSyncThreadFrame(frame);
                }
            }
        }

        @Override
        public int encode(@NonNull PerfSyncThreadFrame message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            PROPERTY_CPU.write(stream, message.cpu);
            PROPERTY_PID.write(stream, message.syncThreadPid);
            PROPERTY_TID.write(stream, message.syncThreadTid);
            PROPERTY_FREQ.write(stream, message.freq);
            int i = 0;
            while (i < message.monotonicRaws.length) {
                PROPERTY_CLOCK_MONOTONIC_RAW.write(stream, message.monotonicRaws[i]);
                PROPERTY_VCOUNT.write(stream, message.vcounts[i]);
                ++i;
            }
            return this.token();
        }

        @Override
        public int token() {
            return 15;
        }

        public static Codec[] values() {
            Codec[] codecArray = ENUM$VALUES;
            int n = codecArray.length;
            Codec[] codecArray2 = new Codec[n];
            System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
            return codecArray2;
        }

        public static Codec valueOf(String string) {
            return Enum.valueOf(Codec.class, string);
        }
    }

    public static interface IPerfSyncThreadFrameConsumer {
        public void consumePerfSyncThreadFrame(@NonNull PerfSyncThreadFrame var1) throws IOException;
    }
}

