/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.v22;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import com.arm.streamline.protocol.gator.messages.IMessage;
import com.arm.streamline.protocol.gator.messages.IMessageCodec;
import com.arm.streamline.protocol.gator.messages.IMessageRecord;
import com.arm.streamline.protocol.gator.messages.IMessageRecordCodec;
import com.arm.streamline.protocol.gator.messages.IObjectProperty;
import com.arm.streamline.protocol.gator.messages.IRecordListProperty;
import com.arm.streamline.protocol.gator.messages.NullTerminatedStringProperty;
import com.arm.streamline.protocol.gator.messages.PackedIntProperty;
import com.arm.streamline.protocol.gator.messages.SingleRecordListProperty;
import com.arm.streamline.protocol.gator.v22.IMessageCodecContextV22;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class MetadataFrame
implements IMessage<Codec> {
    public final @NonNull List<@NonNull Record> records;

    public MetadataFrame(@NonNull List<@NonNull Record> records) {
        this.records = Collections.unmodifiableList(records);
    }

    @Override
    public @NonNull Codec getCodec() {
        return Codec.INSTANCE;
    }

    public static final class Codec
    extends Enum<Codec>
    implements IMessageCodec<MetadataFrame, IConsumer, IMessageCodecContextV22> {
        public static final /* enum */ Codec INSTANCE = new Codec();
        public static final @NonNull IRecordListProperty<Record, @NonNull IMessageCodecContextV22> PROPERTY_RECORDS;
        private static final /* synthetic */ Codec[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Codec[]{INSTANCE};
            PROPERTY_RECORDS = new SingleRecordListProperty<Record, IMessageCodecContextV22>("records", Record.Codec.INSTANCE);
        }

        @Override
        public void decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream, @NonNull IConsumer consumer) throws IOException {
            assert (token == this.token());
            Throwable throwable = null;
            Object var6_7 = null;
            try (IRecordConsumer recordsConsumer = consumer.consumeMetadataFrame();){
                PROPERTY_RECORDS.stream(context, stream, recordsConsumer::consume);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public int encode(@NonNull MetadataFrame message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            PROPERTY_RECORDS.write(context, stream, message.records);
            return this.token();
        }

        @Override
        public int token() {
            return 16;
        }

        public static Codec[] values() {
            Codec[] codecArray = ENUM$VALUES;
            int n = codecArray.length;
            Codec[] codecArray2 = new Codec[n];
            System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
            return codecArray2;
        }

        public static Codec valueOf(String string) {
            return Enum.valueOf(Codec.class, string);
        }
    }

    public static interface IConsumer {
        public @NonNull IRecordConsumer consumeMetadataFrame() throws IOException;
    }

    public static interface IRecordConsumer
    extends Closeable {
        public void consume(@NonNull Record var1) throws IOException;
    }

    public static final class Record
    implements IMessageRecord<Record, IMessageCodecContextV22> {
        public final int key;
        public final @NonNull String value;

        public Record(int key, @NonNull String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public @NonNull IMessageRecordCodec<Record, @NonNull IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public static enum Codec implements IMessageRecordCodec<Record, IMessageCodecContextV22>
        {
            INSTANCE;

            public static final @NonNull IIntProperty PROPERTY_KEY;
            public static final @NonNull IObjectProperty<String> PROPERTY_VALUE;

            static {
                PROPERTY_KEY = new PackedIntProperty("key");
                PROPERTY_VALUE = new NullTerminatedStringProperty("value", StandardCharsets.UTF_8);
            }

            @Override
            public @NonNull Record decode(@NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                int key = PROPERTY_KEY.read(stream);
                @NonNull String value = PROPERTY_VALUE.read(stream);
                return new Record(key, value);
            }

            @Override
            public void encode(@NonNull Record message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                PROPERTY_KEY.write(stream, message.key);
                PROPERTY_VALUE.write(stream, message.value);
            }
        }
    }
}

