/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.messages;

import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IObjectProperty;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class PerfEventAttributeProperty
implements IObjectProperty<EventAttribute> {
    private final @NonNull String name;

    public PerfEventAttributeProperty(@NonNull String name) {
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull EventAttribute read(@NonNull IAPCByteReader stream) throws IOException {
        return new EventAttribute(new EventAttributeDataInputAdapter(stream));
    }

    @Override
    public void write(@NonNull IAPCByteWriter stream, @NonNull EventAttribute value) throws IOException {
        value.write(new EventAttributeDataOutputAdapter(stream));
    }

    private static final class EventAttributeDataInputAdapter
    implements EventAttribute.IDataInput {
        private final @NonNull IAPCByteReader stream;

        public EventAttributeDataInputAdapter(@NonNull IAPCByteReader stream) {
            this.stream = stream;
        }

        @Override
        public int readInt() throws IOException {
            return this.stream.getLEInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.stream.getLELong();
        }

        @Override
        public void skipBytes(int i) throws IOException {
            this.stream.skipBytes(i);
        }
    }

    private static final class EventAttributeDataOutputAdapter
    implements EventAttribute.IDataOutput {
        private final @NonNull IAPCByteWriter stream;

        public EventAttributeDataOutputAdapter(@NonNull IAPCByteWriter stream) {
            this.stream = stream;
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.stream.writeLEInt(v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.stream.writeLELong(v);
        }
    }
}

