/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.messages;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import com.arm.streamline.protocol.gator.messages.IOptionalIntProperty;
import com.arm.streamline.protocol.gator.messages.IOptionalObjectProperty;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class PackedIntProperty
implements IIntProperty,
IOptionalIntProperty {
    private final @NonNull String name;

    public PackedIntProperty(@NonNull String name) {
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public int read(@NonNull IAPCByteReader stream) throws IOException {
        return stream.getPackedInt();
    }

    @Override
    public @Nullable Integer readOptional(@NonNull IAPCByteReader stream) throws IOException {
        if (!IOptionalObjectProperty.test(stream)) {
            return null;
        }
        return this.read(stream);
    }

    @Override
    public void write(@NonNull IAPCByteWriter stream, int value) throws IOException {
        stream.writePackedInt(value);
    }

    @Override
    public void writeOptional(@NonNull IAPCByteWriter stream, @Nullable Integer value) throws IOException {
        if (IOptionalObjectProperty.set(stream, value)) {
            assert (value != null);
            this.write(stream, value);
        }
    }
}

