/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.messages;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IObjectProperty;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class ByteBlobProperty
implements IObjectProperty<byte[]> {
    private final @NonNull String name;

    public ByteBlobProperty(@NonNull String name) {
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public byte @NonNull [] read(@NonNull IAPCByteReader stream) throws IOException {
        int length = stream.getPackedInt();
        if (length < 0) {
            throw new IOException("Invalid byte array length");
        }
        byte[] result = new byte[length];
        stream.get(result);
        return result;
    }

    @Override
    public void write(@NonNull IAPCByteWriter stream, byte @NonNull [] value) throws IOException {
        stream.writePackedInt(value.length);
        stream.write(value);
    }
}

