/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.io;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;

public class ByteBufferAPCByteReader
implements IAPCByteReader {
    private final @NonNull ByteBuffer mBuffer;

    public ByteBufferAPCByteReader(byte @NonNull [] buffer) {
        this.mBuffer = ByteBuffer.wrap(buffer);
        this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public byte @NonNull [] bytes() {
        return this.mBuffer.array();
    }

    @Override
    public void get(byte @NonNull [] data) throws IOException {
        try {
            this.mBuffer.get(data);
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void get(byte @NonNull [] data, int offset, int length) throws IOException {
        try {
            this.mBuffer.get(data, offset, length);
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getLEInt() throws IOException {
        try {
            return this.mBuffer.getInt();
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getLELong() throws IOException {
        try {
            return this.mBuffer.getLong();
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public short getLEShort() throws IOException {
        try {
            return this.mBuffer.getShort();
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public byte getSignedByte() throws IOException {
        try {
            return this.mBuffer.get();
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean hasRemaining() {
        return this.mBuffer.hasRemaining();
    }

    @Override
    public int peekUnsignedByte() throws IOException {
        try {
            return this.mBuffer.get(this.position()) & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int position() {
        return this.mBuffer.position();
    }

    @Override
    public int remaining() {
        return this.mBuffer.remaining();
    }

    @Override
    public void skipBytes(int i) throws IOException {
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        this.mBuffer.position(Math.min(this.mBuffer.position() + i, this.mBuffer.limit()));
    }
}

