/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.time;

import com.arm.streamline.protocol.capture.apc.protocol.DelayProcessingException;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.capture.apc.time.Timestamp;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface ITimestampMapper {
    public static final long BEFORE_START = -1L;
    public static final long MAX_TIMESTAMP = Long.MAX_VALUE;
    public static final /* synthetic */ int[] $SWITCH_TABLE$com$arm$streamline$protocol$capture$apc$time$ClockSource;

    static {
        $SWITCH_TABLE$com$arm$streamline$protocol$capture$apc$time$ClockSource = ITimestampMapper.$SWITCH_TABLE$com$arm$streamline$protocol$capture$apc$time$ClockSource();
    }

    public static int compare(long a, long b) {
        return Long.compare(a, b);
    }

    public static int compareTimestamps(long a, long b) {
        return Long.compare(a, b);
    }

    public static long mapTimestamp(@NonNull ITimestampMapper mapper, @NonNull ClockSource clockSource, long timestamp) throws DelayProcessingException {
        switch (clockSource) {
            case BEFORE_START: {
                return -1L;
            }
            case LOCAL_CLOCK: {
                return mapper.mapLocalClock(timestamp);
            }
            case LOCAL_CLOCK_OR_MONOTONIC_RAW: {
                return mapper.mapLocalClockOrMonotonicRaw(timestamp);
            }
            case MONOTONIC_DELTA: {
                return mapper.mapMonotonicDelta(timestamp);
            }
            case MONOTONIC_RAW: {
                return mapper.mapMonotonicRaw(timestamp);
            }
        }
        throw new AssertionError((Object)clockSource);
    }

    public static long mapTimestamp(@NonNull ITimestampMapper mapper, @NonNull Timestamp timestamp) throws DelayProcessingException {
        return ITimestampMapper.mapTimestamp(mapper, timestamp.clockSource, timestamp.timestamp);
    }

    public static long mapTimestampUsingOptionalMapper(@Nullable ITimestampMapper mapper, @NonNull Timestamp timestamp) throws DelayProcessingException {
        if (mapper != null) {
            return ITimestampMapper.mapTimestamp(mapper, timestamp);
        }
        if (timestamp.clockSource == ClockSource.BEFORE_START) {
            return -1L;
        }
        throw new IllegalArgumentException();
    }

    public static long max(long a, long b) {
        return Long.max(a, b);
    }

    public static long min(long a, long b) {
        return Long.min(a, b);
    }

    public long mapLocalClock(long var1) throws DelayProcessingException;

    public long mapLocalClockOrMonotonicRaw(long var1) throws DelayProcessingException;

    public long mapMonotonicDelta(long var1);

    public long mapMonotonicRaw(long var1) throws DelayProcessingException;

    public long mapSpeClock(int var1, long var2);

    default public long mapTimestamp(@NonNull ClockSource clockSource, long timestamp) throws DelayProcessingException {
        return ITimestampMapper.mapTimestamp(this, clockSource, timestamp);
    }
}

