/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.perf;

import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.records.RecordBlob;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfDataBufferRecordTimestampTracker;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.capture.apc.time.Timestamp;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class PerfDataBufferRecordTimestampTracker
implements IPerfDataBufferRecordTimestampTracker {
    private final @NonNull TLongObjectMap<Timestamp> lastTimestamps = new TLongObjectHashMap();

    @Override
    public @NonNull Timestamp fromSampleId(int deviceNumber, @NonNull RecordBlob.SampleId sampleId) {
        @Nullable Long timestamp = sampleId.time;
        if (timestamp == null) {
            return this.getLastTimestamp(deviceNumber);
        }
        return this.fromTimestamp(deviceNumber, sampleId, timestamp);
    }

    @Override
    public @NonNull Timestamp fromTimestamp(int deviceNumber, @NonNull RecordBlob.SampleId sampleId, long time) {
        if (time == 0L) {
            return Timestamp.BEFORE_START;
        }
        @Nullable EventAttribute attribute = sampleId.attribute;
        if (attribute == null) {
            return this.getLastTimestamp(deviceNumber);
        }
        if (attribute.isFlagSet(EventAttribute.Flags.USE_CLOCKID)) {
            return this.setLastTimestamp(deviceNumber, new Timestamp(ClockSource.MONOTONIC_RAW, time));
        }
        return this.setLastTimestamp(deviceNumber, new Timestamp(ClockSource.LOCAL_CLOCK, time));
    }

    private @NonNull Timestamp getLastTimestamp(int deviceNumber) {
        @Nullable Timestamp timestamp = (Timestamp)this.lastTimestamps.get((long)deviceNumber);
        if (timestamp == null) {
            return Timestamp.BEFORE_START;
        }
        return timestamp;
    }

    private @NonNull Timestamp setLastTimestamp(int deviceNumber, @NonNull Timestamp timestamp) {
        this.lastTimestamps.put((long)deviceNumber, (Object)timestamp);
        return timestamp;
    }
}

