/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.perf;

import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferReader;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferWriter;
import com.arm.utils.io.ByteChannelUtils;
import com.arm.utils.numbers.UnsignedLong;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class PerfAuxDataBuffer
implements IPerfAuxDataBufferReader,
IPerfAuxDataBufferWriter,
Closeable {
    private final @NonNull SeekableByteChannel fileChannel;
    private final @NonNull List<@NonNull ValidRange> validRanges = new ArrayList<ValidRange>();

    public PerfAuxDataBuffer(@NonNull File outputFile) throws IOException {
        this.fileChannel = FileChannel.open(outputFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SPARSE);
    }

    @Override
    public void append(long offset, byte @NonNull [] data) throws IOException {
        if (data.length > 0) {
            ValidRange.appendRange(this.validRanges, new ValidRange(offset, Integer.toUnsignedLong(data.length)));
            this.fileChannel.position(offset);
            ByteChannelUtils.writeBytes((ByteChannel)this.fileChannel, (ByteBuffer)ByteBuffer.wrap(data));
        }
    }

    @Override
    public void close() throws IOException {
        this.fileChannel.close();
    }

    public @NonNull List<@NonNull ValidRange> getValidRanges() {
        return Collections.unmodifiableList(this.validRanges);
    }

    @Override
    public @Nullable InputStream read(long offset, long size) {
        if (size <= 0L) {
            return null;
        }
        @Nullable ValidRange range = ValidRange.findRange(this.validRanges, offset);
        if (range == null || range.contains(offset + size - 1L) != 0) {
            return null;
        }
        return ByteChannelUtils.newInputStream((SeekableByteChannel)this.fileChannel, (long)offset, (long)size);
    }

    public static final class ValidRange
    implements Comparable<ValidRange> {
        public final long length;
        public final long offset;

        public static void appendRange(@NonNull List<@NonNull ValidRange> validRanges, @NonNull ValidRange newRange) throws IOException {
            if (newRange.length == 0L) {
                return;
            }
            ValidRange rangeToInsert = newRange;
            int numValidRanges = validRanges.size();
            int i = numValidRanges - 1;
            while (i >= 0) {
                @NonNull ValidRange range = validRanges.get(i);
                long rangeEnd = range.offset + range.length - 1L;
                long insertEnd = rangeToInsert.offset + rangeToInsert.length - 1L;
                if (UnsignedLong.compare((long)rangeToInsert.offset, (long)(rangeEnd + 1L)) > 0) {
                    validRanges.add(i + 1, rangeToInsert);
                    return;
                }
                if (UnsignedLong.compare((long)(insertEnd + 1L), (long)range.offset) >= 0) {
                    if (UnsignedLong.compare((long)range.offset, (long)rangeToInsert.offset) <= 0 && UnsignedLong.compare((long)rangeEnd, (long)insertEnd) >= 0) {
                        return;
                    }
                    long offset = UnsignedLong.min((long)range.offset, (long)rangeToInsert.offset);
                    long end = UnsignedLong.max((long)rangeEnd, (long)insertEnd);
                    rangeToInsert = new ValidRange(offset, end - offset + 1L);
                    assert (rangeToInsert.length != 0L);
                    validRanges.remove(i);
                }
                --i;
            }
            validRanges.add(0, rangeToInsert);
        }

        public static @Nullable ValidRange findRange(@NonNull List<@NonNull ValidRange> validRanges, long offset) {
            int start = 0;
            int end = validRanges.size();
            while (start < end) {
                int middle = (end + start) / 2;
                @NonNull ValidRange range = validRanges.get(middle);
                int result = range.contains(offset);
                if (result == 0) {
                    return range;
                }
                if (result > 0) {
                    start = middle + 1;
                    continue;
                }
                end = middle;
            }
            return null;
        }

        public ValidRange(long offset, long length) {
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int compareTo(ValidRange o) {
            return Long.compareUnsigned(this.offset, o.offset);
        }

        public int contains(long offsetToCheck) {
            if (UnsignedLong.compare((long)offsetToCheck, (long)this.offset) < 0) {
                return -1;
            }
            if (UnsignedLong.compare((long)offsetToCheck, (long)(this.offset + this.length)) >= 0) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ValidRange) {
                ValidRange that = (ValidRange)obj;
                return this.offset == that.offset && this.length == that.length;
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode(this.offset);
        }

        public String toString() {
            return String.format("{0x%08x + 0x%08x}", this.offset, this.length);
        }
    }
}

