/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.tl;

import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClClosure;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClCommand;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClContext;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClEvent;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClKernel;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClQueue;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.Collections;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class OpenClTimeline {
    private final @NonNull TLongObjectMap<OpenClClosure> closures = new TLongObjectHashMap(10, 0.5f, 0L);
    private final @NonNull TLongObjectMap<OpenClCommand> commands = new TLongObjectHashMap(10, 0.5f, 0L);
    private final @NonNull TLongObjectMap<OpenClContext> contexts = new TLongObjectHashMap(10, 0.5f, 0L);
    private final @NonNull TLongObjectMap<OpenClEvent> events = new TLongObjectHashMap(10, 0.5f, 0L);
    private final @NonNull IntSupplier jobUIDSupplier;
    private final @NonNull TLongObjectMap<OpenClKernel> kernels = new TLongObjectHashMap(10, 0.5f, 0L);
    private final @NonNull TLongObjectMap<OpenClQueue> queues = new TLongObjectHashMap(10, 0.5f, 0L);
    private final @NonNull IntSupplier trackUIDSupplier;

    public OpenClTimeline(@NonNull IntSupplier trackUIDSupplier, @NonNull IntSupplier jobUIDSupplier) {
        this.trackUIDSupplier = trackUIDSupplier;
        this.jobUIDSupplier = jobUIDSupplier;
    }

    public @NonNull OpenClClosure createClosure(long closure) {
        @NonNull OpenClClosure closureObject = new OpenClClosure(closure);
        this.closures.put(closure, (Object)closureObject);
        return closureObject;
    }

    public @NonNull OpenClCommand createCommand(long command) {
        @NonNull OpenClCommand commandObject = new OpenClCommand(command, this.jobUIDSupplier);
        this.commands.put(command, (Object)commandObject);
        return commandObject;
    }

    public void deleteClosure(long closure) {
        this.closures.remove(closure);
    }

    public void deleteCommand(long command) {
        this.commands.remove(command);
    }

    public void deleteEvent(long event) {
        this.events.remove(event);
    }

    public @Nullable OpenClClosure getClosure(long closure) {
        return (OpenClClosure)this.closures.get(closure);
    }

    public @Nullable OpenClCommand getCommand(long command) {
        return (OpenClCommand)this.commands.get(command);
    }

    public @Nullable OpenClCommand getCommandForClosure(long closure) {
        @Nullable OpenClClosure closureObject = (OpenClClosure)this.closures.get(closure);
        if (closureObject == null) {
            return null;
        }
        return closureObject.getCommand();
    }

    public @Nullable OpenClEvent getEvent(long event) {
        return (OpenClEvent)this.events.get(event);
    }

    public @NonNull OpenClClosure getOrCreateClosure(long closure) {
        OpenClClosure closureObject = (OpenClClosure)this.closures.get(closure);
        if (closureObject == null) {
            closureObject = new OpenClClosure(closure);
            this.closures.put(closure, (Object)closureObject);
        }
        return closureObject;
    }

    public @NonNull OpenClContext getOrCreateContext(long context) {
        OpenClContext contextObject = (OpenClContext)this.contexts.get(context);
        if (contextObject == null) {
            contextObject = new OpenClContext(context, this.trackUIDSupplier);
            this.contexts.put(context, (Object)contextObject);
        }
        return contextObject;
    }

    public @NonNull OpenClEvent getOrCreateEvent(long event) {
        OpenClEvent eventObject = (OpenClEvent)this.events.get(event);
        if (eventObject == null) {
            eventObject = new OpenClEvent(event);
            this.events.put(event, (Object)eventObject);
        }
        return eventObject;
    }

    public @NonNull OpenClKernel getOrCreateKernel(long kernel) {
        OpenClKernel kernelObject = (OpenClKernel)this.kernels.get(kernel);
        if (kernelObject == null) {
            kernelObject = new OpenClKernel(kernel);
            this.kernels.put(kernel, (Object)kernelObject);
        }
        return kernelObject;
    }

    public @NonNull OpenClQueue getOrCreateQueue(long queue) {
        OpenClQueue queueObject = (OpenClQueue)this.queues.get(queue);
        if (queueObject == null) {
            int queueTrackUID = this.trackUIDSupplier.getAsInt();
            int chainTrackUID = this.trackUIDSupplier.getAsInt();
            int executionTrackUID = this.trackUIDSupplier.getAsInt();
            int syncTrackUID = this.trackUIDSupplier.getAsInt();
            int memoryTrackUID = this.trackUIDSupplier.getAsInt();
            queueObject = new OpenClQueue(queue, queueTrackUID, executionTrackUID, syncTrackUID, memoryTrackUID, chainTrackUID);
            this.queues.put(queue, (Object)queueObject);
        }
        return queueObject;
    }

    public @NonNull Iterable<@NonNull OpenClQueue> getQueues() {
        return Collections.unmodifiableCollection(this.queues.valueCollection());
    }
}

