/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.tl;

import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClContext;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClDevice;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class OpenClQueue {
    private final int chainTrackUID;
    private @Nullable OpenClContext context;
    private @Nullable OpenClDevice device;
    private @Nullable String deviceName;
    private final int executionTrackUID;
    private final long id;
    private final int memoryTrackUID;
    private final int queueTrackUID;
    private final int syncTrackUID;

    public OpenClQueue(long id, int queueTrackUID, int executionTrackUID, int syncTrackUID, int memoryTrackUID, int chainTrackUID) {
        this.id = id;
        this.queueTrackUID = queueTrackUID;
        this.executionTrackUID = executionTrackUID;
        this.syncTrackUID = syncTrackUID;
        this.memoryTrackUID = memoryTrackUID;
        this.chainTrackUID = chainTrackUID;
    }

    public int getChainTrackUID() {
        return this.chainTrackUID;
    }

    public @Nullable OpenClContext getContext() {
        return this.context;
    }

    public @Nullable OpenClDevice getDevice() {
        return this.device;
    }

    public @Nullable String getDeviceName() {
        return this.deviceName;
    }

    public int getExecTrackUID() {
        return this.executionTrackUID;
    }

    public long getId() {
        return this.id;
    }

    public int getMemoryTrackUID() {
        return this.memoryTrackUID;
    }

    public int getSyncTrackUID() {
        return this.syncTrackUID;
    }

    public int getTrackUID() {
        return this.queueTrackUID;
    }

    public void setContext(@NonNull OpenClContext context) {
        @Nullable OpenClDevice device = this.device;
        if (device != null && device.getContext() != context) {
            return;
        }
        this.context = context;
    }

    public void setDevice(@NonNull OpenClDevice device) {
        if (this.device != null) {
            return;
        }
        this.device = device;
        this.deviceName = device.getName();
        this.context = device.getContext();
        device.getQueueNumber(this);
    }

    public void setDeviceName(@NonNull String deviceName) {
        assert (!deviceName.isEmpty());
        assert (this.device == null);
        this.deviceName = deviceName;
    }

    public String toString() {
        return String.format("0x%x", this.id);
    }
}

