/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.tl;

import com.arm.streamline.protocol.capture.apc.protocol.external.MaliOpenCLCAMGenerator;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClKernel;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClQueue;
import com.arm.utils.numbers.UnsignedLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class OpenClCommand {
    private final @NonNull Set<@NonNull OpenClCommand> dependsOn = new HashSet<OpenClCommand>();
    private final long id;
    private int jobChainIndexForAccurateTimestamps;
    private int jobChainIndexForCommandApiName;
    private int jobChainIndexForKernelName;
    private final int jobChainJobUID;
    private final @NonNull List<@NonNull OpenClCommandChainJob> jobs = new ArrayList<OpenClCommandChainJob>();
    private final @NonNull IntSupplier jobUIDSupplier;
    private @Nullable OpenClQueue queue;
    private long queueTimestamp;
    private @Nullable OpenClCommandType type;

    public OpenClCommand(long id, @NonNull IntSupplier jobUIDSupplier) {
        this.id = id;
        this.jobUIDSupplier = jobUIDSupplier;
        this.jobChainJobUID = jobUIDSupplier.getAsInt();
    }

    public void addDependencies(@NonNull Collection<@NonNull OpenClCommand> command) {
        this.dependsOn.addAll(command);
    }

    public @NonNull Set<@NonNull OpenClCommand> getDependencies() {
        return this.dependsOn;
    }

    public long getId() {
        return this.id;
    }

    public @NonNull List<@NonNull OpenClCommandChainJob> getJobChain() {
        return Collections.unmodifiableList(this.jobs);
    }

    public int getJobChainJobUID() {
        return this.jobChainJobUID;
    }

    public @Nullable OpenClQueue getQueue() {
        return this.queue;
    }

    public long getQueueTimestamp() {
        return this.queueTimestamp;
    }

    public @Nullable OpenClCommandType getType() {
        return this.type;
    }

    public void resetAccurateTimestamps() {
        assert (this.jobChainIndexForAccurateTimestamps < 2);
        this.jobChainIndexForAccurateTimestamps = 0;
    }

    public boolean seenAccurateTimestamps() {
        return this.jobs.stream().allMatch(OpenClCommandChainJob::areTimestampsAreAccurate);
    }

    public void setAccurateStartAndStopTimes(long start, long stop) {
        @NonNull OpenClCommandChainJob job = this.getNextJob(this.jobChainIndexForAccurateTimestamps);
        this.jobChainIndexForAccurateTimestamps = Math.min(this.jobChainIndexForAccurateTimestamps + 1, this.jobs.size());
        job.setAccurateStartAndStopTimes(start, stop);
    }

    public void setCommandApiName(@NonNull String apiName) {
        @NonNull OpenClCommandChainJob job = this.getNextJob(this.jobChainIndexForCommandApiName);
        this.jobChainIndexForCommandApiName = Math.min(this.jobChainIndexForCommandApiName + 1, this.jobs.size());
        job.setNameIfNotAlreadySet(apiName);
    }

    public void setInaccurateStartTime(long timestamp) {
        this.jobs.forEach(job -> job.setInaccurateStartTime(timestamp));
    }

    public void setInaccurateStopTime(long timestamp) {
        this.jobs.forEach(job -> job.setInaccurateStopTime(timestamp));
    }

    public void setKernel(long timestamp, @NonNull OpenClKernel kernelObject) {
        @NonNull OpenClCommandChainJob job = this.getNextJob(this.jobChainIndexForKernelName);
        this.jobChainIndexForKernelName = Math.min(this.jobChainIndexForKernelName + 1, this.jobs.size());
        job.setKernelTimestamp(timestamp);
        job.setName(kernelObject.getName());
    }

    public void setQueue(long queueTimestamp, @NonNull OpenClQueue queue) {
        this.queueTimestamp = queueTimestamp;
        this.queue = queue;
    }

    public void setType(@Nullable OpenClCommandType type) {
        this.type = type;
    }

    public String toString() {
        return String.format("0x%x", this.id);
    }

    private @NonNull OpenClCommandChainJob getNextJob(int index) {
        if (index < this.jobs.size()) {
            return this.jobs.get(index);
        }
        int jobUID = this.jobUIDSupplier.getAsInt();
        MaliOpenCLCAMGenerator.log(String.format("Creating new chain job for command: %s -> %d / %d%n", this, this.jobs.size(), jobUID));
        @NonNull OpenClCommandChainJob job = new OpenClCommandChainJob(jobUID);
        this.jobs.add(job);
        return job;
    }

    public final class OpenClCommandChainJob {
        private final int jobUID;
        private @Nullable Long kernelTimestamp;
        private @Nullable String name;
        private long startTimestamp;
        private long stopTimestamp;
        private boolean timestampsAreAccurate;

        public OpenClCommandChainJob(int jobUID) {
            this.jobUID = jobUID;
        }

        public boolean areTimestampsAreAccurate() {
            return this.timestampsAreAccurate;
        }

        public void fixStopTime(long timestamp) {
            assert (timestamp != 0L);
            assert (this.startTimestamp >= this.stopTimestamp);
            assert (timestamp >= this.startTimestamp);
            this.stopTimestamp = timestamp;
        }

        public int getJobUID() {
            return this.jobUID;
        }

        public @Nullable Long getKernelTimestamp() {
            return this.kernelTimestamp;
        }

        public @Nullable String getName() {
            return this.name;
        }

        public long getStartTimestamp() {
            return this.startTimestamp;
        }

        public long getStopTimestamp() {
            return this.stopTimestamp;
        }

        public void setAccurateStartAndStopTimes(long start, long stop) {
            assert (stop >= start);
            this.timestampsAreAccurate = true;
            this.startTimestamp = start;
            this.stopTimestamp = stop;
        }

        public void setInaccurateStartTime(long timestamp) {
            if (this.timestampsAreAccurate) {
                return;
            }
            if (this.startTimestamp == 0L || UnsignedLong.compare((long)this.startTimestamp, (long)timestamp) > 0) {
                this.startTimestamp = timestamp;
            }
        }

        public void setInaccurateStopTime(long timestamp) {
            if (this.timestampsAreAccurate) {
                return;
            }
            if (this.stopTimestamp == 0L || UnsignedLong.compare((long)this.stopTimestamp, (long)timestamp) < 0) {
                this.stopTimestamp = timestamp;
            }
        }

        public void setKernelTimestamp(long timestamp) {
            this.kernelTimestamp = timestamp;
        }

        public void setName(@Nullable String name) {
            if (name != null && !name.isEmpty()) {
                this.name = name;
            }
        }

        public void setNameIfNotAlreadySet(@NonNull String name) {
            if (this.name == null) {
                this.setName(name);
            }
        }
    }

    public static enum OpenClCommandType {
        EXEC,
        MEM;

    }
}

