/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.mipe;

import org.eclipse.jdt.annotation.NonNull;

public final class MipeVersion
implements Comparable<MipeVersion> {
    public static final @NonNull MipeVersion ONE = new MipeVersion(1, 0, 0);
    public static final @NonNull MipeVersion ZERO = new MipeVersion(0, 0, 0);
    public final int major;
    public final int minor;
    public final int patch;

    public static @NonNull MipeVersion fromTiebreak(int value) {
        if (value < 5 && value >= 0) {
            return new MipeVersion(value, 0, 0);
        }
        int patch = value & 0xFFF;
        int minor = value >>> 12 & 0x3FF;
        int major = value >>> 22 & 0x3FF;
        assert (major >= 5);
        return new MipeVersion(major, minor, patch);
    }

    public static @NonNull MipeVersion fromVersionInt(int value) {
        int patch = value & 0xFFF;
        int minor = value >>> 12 & 0x3FF;
        int major = value >>> 22 & 0x3FF;
        return new MipeVersion(major, minor, patch);
    }

    public static @NonNull MipeVersion maxForMajor(int major) {
        return new MipeVersion(major, 1023, 4095);
    }

    public static @NonNull MipeVersion minForMajor(int major) {
        return new MipeVersion(major, 0, 0);
    }

    public MipeVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    @Override
    public int compareTo(MipeVersion o) {
        return Integer.compareUnsigned(this.toInt(), o.toInt());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MipeVersion) {
            MipeVersion that = (MipeVersion)obj;
            return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
        }
        return false;
    }

    public int hashCode() {
        return this.toInt();
    }

    public int toInt() {
        return (this.major & 0x3FF) << 22 | (this.minor & 0x3FF) << 12 | this.patch & 0xFFF;
    }

    public @NonNull String toString() {
        return String.format("MipeVersion [major=%s, minor=%s, patch=%s]", this.major, this.minor, this.patch);
    }
}

