/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.mipe;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MipeHeader {
    public static final int PACKET_FAMILY_CONTROL = 0;
    public static final int PACKET_FAMILY_HUGE = 2;
    public static final int PACKET_FAMILY_HW_COUNTER = 3;
    public static final int PACKET_FAMILY_INTERNAL = 62;
    public static final int PACKET_FAMILY_INTERNAL_HUGE = 63;
    public static final int PACKET_FAMILY_TIMELINE = 1;
    public static final int PACKET_ID_CLASS_MASK = 127;
    public static final int PACKET_ID_CLASS_SHIFT = 3;
    public static final int PACKET_ID_CONTROL_HW_COUNTER_DIRECTORY = 2;
    public static final int PACKET_ID_CONTROL_SHARED = 0;
    public static final int PACKET_ID_HUGE_CLASS_WINDUMP = 0;
    public static final int PACKET_ID_HW_COUNTER_CLASS_PER_FRAME = 2;
    public static final int PACKET_ID_HW_COUNTER_CLASS_PER_JOB = 1;
    public static final int PACKET_ID_HW_COUNTER_CLASS_PERIODIC = 0;
    public static final int PACKET_ID_TIMELINE_CLASS_PM = 1;
    public static final int PACKET_ID_TIMELINE_CLASS_TIMELINE = 0;
    public static final int PACKET_ID_TIMELINE_STREAM_ID_KERNEL = 1;
    public static final int PACKET_ID_TIMELINE_STREAM_ID_USERSPACE = 0;
    public static final int PACKET_ID_TIMELINE_TYPE_SWTRACE_DIRECTORY = 0;
    public static final int PACKET_ID_TIMELINE_TYPE_SWTRACE_STREAM = 1;
    public static final int PACKET_ID_TIMELINE_TYPE_SWTRACE_SUMMARY = 2;
    public static final int PACKET_ID_TIMELINE_VALUE_PM_HEADER = 8;
    public static final int PACKET_ID_TIMELINE_VALUE_PM_STREAM = 9;
    public static final int PACKET_ID_TIMELINE_VALUE_TIMELINE_HEADER = 0;
    public static final int PACKET_ID_TIMELINE_VALUE_TIMELINE_STREAM = 1;
    public static final int PACKET_ID_TYPE_MASK = 7;
    public static final int SIZE_HEADER = 8;
    public static final int SIZE_SEQUENCE_NUMBER = 4;
    private final @NonNull ByteOrder byteOrder;
    private final short identifier;
    private final byte implSpec;
    private final int length;
    private final byte reserved0;
    private final int sequenceNumber;

    public static @Nullable MipeHeader create(@NonNull ByteOrder byteOrder, byte @NonNull [] header) {
        int sequenceNumber;
        if (header.length < 8) {
            return null;
        }
        @NonNull ByteBuffer buffer = ByteBuffer.wrap(header);
        buffer.order(byteOrder);
        int word0 = buffer.getInt();
        short identifier = (short)(word0 >>> 16);
        byte reserved0 = (byte)(word0 >>> 8);
        byte implSpec = (byte)(word0 >>> 0);
        int length = buffer.getInt();
        if (MipeHeader.isSequenceNumbered(identifier, length)) {
            if (header.length < 12) {
                return null;
            }
            if ((length & 0xFFFFFF) < 4) {
                throw new AssertionError();
            }
            sequenceNumber = buffer.getInt();
        } else {
            sequenceNumber = 0;
        }
        return new MipeHeader(byteOrder, identifier, reserved0, implSpec, length, sequenceNumber);
    }

    private static int getPacketFamily(short identifier) {
        return identifier >>> 10 & 0x3F;
    }

    private static boolean isHugePacket(short identifier) {
        int packetFamily = MipeHeader.getPacketFamily(identifier);
        return packetFamily == 2 || packetFamily == 63;
    }

    private static boolean isSequenceNumbered(short identifier, int length) {
        if (MipeHeader.isHugePacket(identifier)) {
            return false;
        }
        return (length & 0x1000000) != 0;
    }

    protected MipeHeader(@NonNull ByteOrder byteOrder, short identifier, byte reserved0, byte implSpec, int length, int sequenceNumber) {
        this.byteOrder = byteOrder;
        this.identifier = identifier;
        this.reserved0 = reserved0;
        this.implSpec = implSpec;
        this.length = length;
        this.sequenceNumber = sequenceNumber;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MipeHeader) {
            MipeHeader that = (MipeHeader)obj;
            return this.byteOrder == that.byteOrder && this.identifier == that.identifier && this.reserved0 == that.reserved0 && this.implSpec == that.implSpec && this.length == that.length && this.sequenceNumber == that.sequenceNumber;
        }
        return false;
    }

    public @NonNull ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getDataLength() {
        if (this.isHugePacket()) {
            return this.length;
        }
        return (this.length & 0xFFFFFF) - (this.isSequenceNumbered() ? 4 : 0);
    }

    public int getImplSpec() {
        return this.implSpec & 0xFF;
    }

    public int getLengthWord() {
        return this.length;
    }

    public int getPacketClass() {
        return this.identifier >>> 3 & 0x7F;
    }

    public int getPacketFamily() {
        return MipeHeader.getPacketFamily(this.identifier);
    }

    public int getPacketId() {
        return this.identifier & 0x3FF;
    }

    public int getPacketType() {
        return this.identifier & 7;
    }

    public int getReserved0() {
        return this.reserved0 & 0xFF;
    }

    public int getReserved1() {
        if (this.isHugePacket()) {
            return 0;
        }
        return this.length >>> 25 & 0x7F;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int hashCode() {
        return this.identifier * 31 + this.length;
    }

    public boolean isHugePacket() {
        return MipeHeader.isHugePacket(this.identifier);
    }

    public boolean isSequenceNumbered() {
        return MipeHeader.isSequenceNumbered(this.identifier, this.length);
    }

    public int size() {
        return 8 + (this.isSequenceNumbered() ? 4 : 0);
    }

    public @NonNull MipeHeader swapEndian() {
        int sequenceNumber;
        int length;
        byte implSpec;
        byte reserved0;
        int word0;
        int rWord0;
        short identifier;
        @NonNull ByteOrder byteOrder = this.byteOrder == ByteOrder.LITTLE_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        @NonNull MipeHeader result = new MipeHeader(byteOrder, identifier = (short)((rWord0 = Integer.reverseBytes(word0 = (this.identifier & 0xFFFF) << 16 | (this.reserved0 & 0xFF) << 8 | this.implSpec & 0xFF)) >>> 16), reserved0 = (byte)(rWord0 >>> 8), implSpec = (byte)(rWord0 >>> 0), length = Integer.reverseBytes(this.length), sequenceNumber = Integer.reverseBytes(this.sequenceNumber));
        if (result.isSequenceNumbered() != this.isSequenceNumbered()) {
            throw new AssertionError();
        }
        return result;
    }

    public String toString() {
        return String.format("MIPE(%s, 0x%04x, 0x%02x, 0x%02x, 0x%08x, 0x%08x)", this.byteOrder, this.identifier, this.reserved0, this.implSpec, this.length, this.sequenceNumber);
    }
}

