/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.armnn;

import com.arm.armnn.timeline.TimelineDecoderException;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Entity;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Event;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.ITrack;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.ITrackable;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Layer;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Track;
import com.arm.streamline.protocol.misc.TaskId;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Network
extends Entity
implements ITrackable {
    private @Nullable TaskId taskId;
    private @Nullable Long timestamp;

    public Network(long guid, int trackID) {
        super(guid, trackID);
        this.setName("network");
    }

    public void setTaskId(@NonNull TaskId taskId) {
        this.taskId = taskId;
    }

    public @NonNull TaskId getTaskId() {
        TaskId taskId = this.taskId;
        if (taskId == null) {
            throw new TimelineDecoderException(String.format("Network(%s) must have an associated taskId", this.guid));
        }
        return taskId;
    }

    @Override
    public @NonNull ITrack toTrack() {
        TaskId taskId = this.getTaskId();
        long timestamp = this.getTimestamp();
        return new Track(timestamp, taskId, -1, this.trackId, this.getName());
    }

    public void setStartEvent(@NonNull Event start) {
        this.timestamp = start.timestamp;
    }

    public long getTimestamp() {
        Long timestamp = this.timestamp;
        if (timestamp == null) {
            throw new TimelineDecoderException(String.format("Network(%s) must have an associated timestamp", this.guid));
        }
        return timestamp;
    }

    public @NonNull List<Layer> layers() {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Entity t : this.getChildren()) {
            if (!(t instanceof Layer)) continue;
            layers.add((Layer)t);
        }
        return layers;
    }
}

