/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.armnn;

import com.arm.armnn.timeline.TimelineDecoderException;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Entity;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.INetworkable;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.ITrack;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.ITrackable;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Network;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Track;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Workload;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Layer
extends Entity
implements INetworkable,
ITrackable {
    private @Nullable Network network;
    private @NonNull List<@NonNull Layer> inputsFrom = new ArrayList<Layer>();

    public Layer(long guid, int trackId) {
        super(guid, trackId);
    }

    public void addInput(@NonNull Layer input) {
        this.inputsFrom.add(input);
    }

    public @NonNull List<@NonNull Layer> getInputs() {
        return this.inputsFrom;
    }

    @Override
    public @Nullable Network getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(@NonNull Network network) {
        this.network = network;
    }

    @Override
    public @NonNull ITrack toTrack() {
        if (this.network == null) {
            throw new TimelineDecoderException(String.format("Layer(%d) must belong to a network", this.guid));
        }
        return new Track(((Network)NullChecking.neverNull((Object)this.network)).getTimestamp(), ((Network)NullChecking.neverNull((Object)this.network)).getTaskId(), ((Network)NullChecking.neverNull((Object)this.network)).getTrackId(), this.trackId, this.getName());
    }

    public @NonNull List<Workload> workloads() {
        ArrayList<Workload> workloads = new ArrayList<Workload>();
        for (Entity e : this.getChildren()) {
            if (!(e instanceof Workload)) continue;
            workloads.add((Workload)e);
        }
        return workloads;
    }
}

